/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.JMultilineToolTip;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.JSortTable;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class LimeJTable
extends JTable
implements JSortTable {
    protected Map _hiddenColumns = new HashMap();
    protected int sortedColumnIndex = -1;
    protected boolean sortedColumnAscending = true;
    protected int pressedColumnIndex = -1;
    private String[] tips;
    private final String[] CLIPPED_TIP = new String[1];
    private static LimeTableColumn _lastRemoved;
    protected ColumnPreferenceHandler columnPreferences;
    protected TableSettings tableSettings;
    private static final boolean IS_JAVA_13;

    public LimeJTable() {
        this.setToolTipText("");
    }

    public LimeJTable(DataLineModel dm) {
        super(dm);
        this.setToolTipText("");
    }

    public boolean isManagingFocus() {
        return false;
    }

    public int getSelectedRow() {
        int selected = super.getSelectedRow();
        if (selected >= this.dataModel.getRowCount()) {
            return -1;
        }
        return selected;
    }

    public int[] getSelectedRows() {
        int[] selected = super.getSelectedRows();
        if (selected == null || selected.length == 0) {
            return selected;
        }
        Arrays.sort(selected);
        int tableSize = this.dataModel.getRowCount();
        int i = 0;
        while (i < selected.length) {
            if (selected[i] >= tableSize) {
                int[] newData = new int[i];
                System.arraycopy(selected, 0, newData, 0, i);
                return newData;
            }
            ++i;
        }
        return selected;
    }

    public void ensureSelectionVisible() {
        this.ensureRowVisible(this.getSelectedRow());
    }

    public void ensureRowVisible(int row) {
        if (row != -1) {
            Rectangle cellRect = this.getCellRect(row, 0, false);
            Rectangle visibleRect = this.getVisibleRect();
            if (!visibleRect.intersects(cellRect)) {
                this.scrollRectToVisible(cellRect);
            }
        }
    }

    public boolean isSelectionVisible() {
        return this.isRowVisible(this.getSelectedRow());
    }

    public boolean isRowVisible(int row) {
        if (row != -1) {
            Rectangle cellRect = this.getCellRect(row, 0, false);
            Rectangle visibleRect = this.getVisibleRect();
            return visibleRect.intersects(cellRect);
        }
        return false;
    }

    public ColumnPreferenceHandler getColumnPreferenceHandler() {
        return this.columnPreferences;
    }

    public void setColumnPreferenceHandler(ColumnPreferenceHandler handl) {
        this.columnPreferences = handl;
    }

    public TableSettings getTableSettings() {
        return this.tableSettings;
    }

    public void setTableSettings(TableSettings settings) {
        this.tableSettings = settings;
    }

    public void setPressedColumnIndex(int col) {
        this.pressedColumnIndex = col;
    }

    public int getPressedColumnIndex() {
        return this.convertColumnIndexToView(this.pressedColumnIndex);
    }

    public int getSortedColumnIndex() {
        return this.convertColumnIndexToView(this.sortedColumnIndex);
    }

    public boolean isSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    public void sortColumn(int index, boolean ascending) {
        this.sortedColumnIndex = index;
        this.sortedColumnAscending = ascending;
    }

    public void setColumnVisible(Object columnId, boolean visible) throws LastColumnException {
        if (!visible) {
            TableColumnModel model = this.getColumnModel();
            if (model.getColumnCount() == 1) {
                throw new LastColumnException();
            }
            TableColumn column = model.getColumn(model.getColumnIndex(columnId));
            this._hiddenColumns.put(columnId, column);
            _lastRemoved = (LimeTableColumn)column;
            this.removeColumn(column);
        } else {
            TableColumn column = (TableColumn)this._hiddenColumns.get(columnId);
            this._hiddenColumns.remove(columnId);
            this.addColumn(column);
        }
    }

    public Iterator getHiddenColumns() {
        return Collections.unmodifiableCollection(this._hiddenColumns.values()).iterator();
    }

    public LimeTableColumn getLastRemovedColumn() {
        return _lastRemoved;
    }

    public boolean isColumnVisible(Object columnId) {
        return !this._hiddenColumns.containsKey(columnId);
    }

    public String getToolTipText(MouseEvent e) {
        boolean isClippable;
        Point p = e.getPoint();
        int row = this.rowAtPoint(p);
        int col = this.columnAtPoint(p);
        int colModel = this.convertColumnIndexToModel(col);
        DataLineModel dlm = (DataLineModel)this.dataModel;
        boolean bl = isClippable = col > -1 && row > -1 ? dlm.isClippable(colModel) : false;
        if (!this.tableSettings.DISPLAY_TOOLTIPS.getValue()) {
            if (isClippable) {
                return this.clippedToolTip(row, col, colModel);
            }
            return null;
        }
        if (row > -1) {
            this.tips = dlm.getToolTipArray(row, colModel);
            if (this.tips == null) {
                if (isClippable) {
                    return this.clippedToolTip(row, col, colModel);
                }
                return null;
            }
            return dlm.get(row).toString() + col;
        }
        this.tips = DataUtils.EMPTY_STRING_ARRAY;
        return null;
    }

    private String clippedToolTip(int row, int col, int colModel) {
        int dataWidth;
        TableColumn tc = this.getColumnModel().getColumn(col);
        int columnWidth = tc.getWidth();
        if (columnWidth < (dataWidth = this.getDataWidth(row, colModel))) {
            this.tips = this.CLIPPED_TIP;
            return ((DataLineModel)this.dataModel).get(row).toString() + col;
        }
        this.tips = DataUtils.EMPTY_STRING_ARRAY;
        return null;
    }

    private int getDataWidth(int row, int col) {
        DataLineModel dlm = (DataLineModel)this.dataModel;
        DataLine dl = dlm.get(row);
        Object data = dl.getValueAt(col);
        if (data != null) {
            String info;
            this.CLIPPED_TIP[0] = info = data.toString();
            TableCellRenderer tcr = this.getDefaultRenderer(dlm.getColumnClass(col));
            JComponent renderer = (JComponent)tcr.getTableCellRendererComponent(this, data, false, false, row, col);
            FontMetrics fm = ((Component)renderer).getFontMetrics(renderer.getFont());
            return fm.stringWidth(info) + 3;
        }
        return -1;
    }

    public JToolTip createToolTip() {
        JMultilineToolTip ret = JMultilineToolTip.instance();
        ret.setToolTipArray(this.tips);
        this.tips = DataUtils.EMPTY_STRING_ARRAY;
        return ret;
    }

    public void createDefaultColumnsFromModel() {
        DataLineModel dlm = (DataLineModel)this.dataModel;
        if (dlm != null) {
            TableColumnModel cm = this.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            int i = 0;
            while (i < dlm.getColumnCount()) {
                LimeTableColumn newColumn = dlm.getTableColumn(i);
                this.addColumn(newColumn);
                ++i;
            }
        }
    }

    public Color getBackgroundForRow(int row) {
        if (row % 2 == 0 || !this.tableSettings.ROWSTRIPE.getValue()) {
            return this.getBackground();
        }
        return ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue();
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        if (renderer == null) {
            throw new IllegalStateException("null renderer, row: " + row + ", column: " + column + ", id: " + this.tableSettings.getID() + ", columnId: " + this.getColumnModel().getColumn(column));
        }
        Object value = this.getValueAt(row, column);
        boolean isSelected = this.isCellSelected(row, column);
        boolean rowIsAnchor = this.selectionModel.getAnchorSelectionIndex() == row;
        boolean colIsAnchor = this.columnModel.getSelectionModel().getAnchorSelectionIndex() == column;
        boolean hasFocus = rowIsAnchor && colIsAnchor && this.hasFocus();
        Component r = renderer.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, column);
        Color odd = ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue();
        Color even = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        if (!(isSelected || hasFocus && this.isCellEditable(row, column) || even.equals(odd))) {
            if (!this.tableSettings.ROWSTRIPE.getValue()) {
                if (r != null && !r.equals(even)) {
                    r.setBackground(even);
                }
            } else if (row % 2 != 0) {
                r.setBackground(odd);
            } else {
                r.setBackground(even);
            }
        }
        if (IS_JAVA_13) {
            Color back = r.getBackground();
            boolean colorMatch = back != null && back.equals(even);
            ((JComponent)r).setOpaque(!colorMatch);
        }
        return r;
    }

    static {
        IS_JAVA_13 = CommonUtils.isJava13OrLater() && !CommonUtils.isJava14OrLater();
    }
}

