/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.JSortTable;
import com.limegroup.gnutella.gui.tables.SortArrowIcon;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public final class SortHeaderRenderer
extends DefaultTableCellRenderer {
    public static Icon ASCENDING = SortArrowIcon.getAscendingIcon();
    public static Icon DECENDING = SortArrowIcon.getDescendingIcon();
    private boolean allowIcon = true;

    public SortHeaderRenderer() {
        this.setHorizontalAlignment(0);
        this.setIconTextGap(2);
        this.setHorizontalTextPosition(2);
    }

    public void setAllowIcon(boolean allow) {
        this.allowIcon = allow;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        JTableHeader header;
        int index = -1;
        boolean ascending = true;
        boolean isPressed = false;
        if (this.allowIcon && table instanceof JSortTable) {
            JSortTable sortTable = (JSortTable)((Object)table);
            index = sortTable.getSortedColumnIndex();
            ascending = sortTable.isSortedColumnAscending();
            boolean bl = isPressed = sortTable.getPressedColumnIndex() == col;
        }
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }
        Icon icon = col == index ? (ascending ? ASCENDING : DECENDING) : null;
        this.setIcon(icon);
        this.setText(value == null ? null : value.toString());
        if (isPressed) {
            Border bd = UIManager.getBorder("TableHeader.cellPressedBorder");
            if (bd == null) {
                bd = UIManager.getBorder("TableHeader.cellBorder");
            }
            this.setBorder(bd);
        } else {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
        return this;
    }
}

