/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PingRequest
extends Message {
    private byte[] payload = null;

    public PingRequest(byte[] guid, byte ttl, byte hops) {
        super(guid, (byte)0, ttl, hops, 0);
    }

    protected PingRequest(byte[] guid, byte ttl, byte hops, byte length) {
        super(guid, (byte)0, ttl, hops, length);
    }

    public PingRequest(byte[] guid, byte ttl, byte hops, byte[] payload) {
        super(guid, (byte)0, ttl, hops, payload.length);
        this.payload = payload;
    }

    public PingRequest(byte ttl) {
        super((byte)0, ttl, 0);
        this.addLocale();
    }

    protected PingRequest(byte ttl, byte length) {
        super((byte)0, ttl, length);
    }

    public static PingRequest createQueryKeyRequest() {
        return new PingRequest();
    }

    private PingRequest() {
        this(1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GGEP ggepBlock = new GGEP(false);
            ggepBlock.put("QK");
            ggepBlock.write(baos);
            baos.write(0);
        }
        catch (IOException why) {
            ErrorService.error(why);
        }
        this.payload = baos.toByteArray();
        this.updateLength(this.payload.length);
    }

    protected void writePayload(OutputStream out) throws IOException {
        if (this.payload != null) {
            out.write(this.payload);
        }
        if (Message.RECORD_STATS) {
            SentMessageStatHandler.TCP_PING_REQUESTS.addMessage(this);
        }
    }

    public Message stripExtendedPayload() {
        if (this.payload == null) {
            return this;
        }
        return new PingRequest(this.getGUID(), this.getTTL(), this.getHops());
    }

    public boolean isQueryKeyRequest() {
        if (this.getTTL() != 0 || this.getHops() != 1) {
            return false;
        }
        if (this.payload == null) {
            return false;
        }
        return this.parseGGEP(this.payload);
    }

    private final boolean parseGGEP(byte[] ggepBytes) {
        try {
            GGEP ggepBlock = new GGEP(ggepBytes, 0, null);
            if (ggepBlock.hasKey("QK")) {
                return true;
            }
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            // empty catch block
        }
        return false;
    }

    public void recordDrop() {
        if (Message.RECORD_STATS) {
            DroppedSentMessageStatHandler.TCP_PING_REQUESTS.addMessage(this);
        }
    }

    public String toString() {
        return "PingRequest(" + super.toString() + ")";
    }

    public boolean isHeartbeat() {
        return this.getHops() == 1 && this.getTTL() == 0;
    }

    private void addLocale() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GGEP ggep = new GGEP(true);
            ggep.put("LOC", ApplicationSettings.LANGUAGE.getValue());
            ggep.write(baos);
            baos.write(0);
            this.payload = baos.toByteArray();
            this.updateLength(this.payload.length);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
    }

    public String getLocale() {
        if (this.payload != null) {
            try {
                GGEP ggepBlock = new GGEP(this.payload, 0, null);
                if (ggepBlock.hasKey("LOC")) {
                    return ggepBlock.getString("LOC");
                }
                return ApplicationSettings.DEFAULT_LOCALE.getValue();
            }
            catch (BadGGEPBlockException ignored) {
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
            return ApplicationSettings.DEFAULT_LOCALE.getValue();
        }
        return ApplicationSettings.DEFAULT_LOCALE.getValue();
    }
}

