/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.IOException;
import java.io.OutputStream;

public class GiveStatsVendorMessage
extends VendorMessage {
    public static final int VERSION = 1;
    public static final byte GNUTELLA_INCOMING_TRAFFIC = 0;
    public static final byte GNUTELLA_OUTGOING_TRAFFIC = 1;
    public static final byte HTTP_DOWNLOAD_TRAFFIC_STATS = 2;
    public static final byte HTTP_UPLOAD_TRAFFIC_STATS = 3;
    public static final byte PER_CONNECTION_STATS = 0;
    public static final byte ALL_CONNECTIONS_STATS = 1;
    public static final byte LEAF_CONNECTIONS_STATS = 2;
    public static final byte UP_CONNECTIONS_STATS = 3;

    GiveStatsVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload, int network) throws BadPacketException {
        super(guid, ttl, hops, VendorMessage.F_LIME_VENDOR_ID, 14, version, payload, network);
        if (this.getPayload().length < 2) {
            throw new BadPacketException("INVALID PAYLOAD LENGTH: " + payload.length);
        }
        if (version == 1 && this.getPayload().length != 2) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + payload.length);
        }
    }

    public GiveStatsVendorMessage(byte statsControl, byte statType, int network) {
        super(VendorMessage.F_LIME_VENDOR_ID, 14, 1, GiveStatsVendorMessage.derivePayload(statsControl, statType), network);
    }

    private static byte[] derivePayload(byte control, byte type) {
        if (control < 0 || control > 3) {
            throw new IllegalArgumentException(" invalid control byte ");
        }
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException(" invalid stat type ");
        }
        byte[] ret = new byte[]{control, type};
        return ret;
    }

    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
        if (Message.RECORD_STATS) {
            if (this.isTCP()) {
                SentMessageStatHandler.TCP_GIVE_STATS.addMessage(this);
            } else if (this.isUDP()) {
                SentMessageStatHandler.UDP_GIVE_STATS.addMessage(this);
            }
        }
    }

    public void recordDrop() {
        super.recordDrop();
    }

    protected byte getStatControl() {
        byte[] payload = this.getPayload();
        return payload[0];
    }

    protected byte getStatType() {
        byte[] payload = this.getPayload();
        return payload[1];
    }
}

