/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.IOException;
import java.io.OutputStream;

public final class LimeACKVendorMessage
extends VendorMessage {
    public static final int VERSION = 2;

    LimeACKVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, VendorMessage.F_LIME_VENDOR_ID, 11, version, payload);
        if (this.getVersion() == 1) {
            throw new BadPacketException("UNSUPPORTED OLD VERSION");
        }
        if (this.getPayload().length < 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
        if (this.getVersion() == 2 && this.getPayload().length != 1) {
            throw new BadPacketException("VERSION 2 UNSUPPORTED PAYLOAD LEN: " + this.getPayload().length);
        }
    }

    public LimeACKVendorMessage(GUID replyGUID, int numResults) {
        super(VendorMessage.F_LIME_VENDOR_ID, 11, 2, LimeACKVendorMessage.derivePayload(numResults));
        this.setGUID(replyGUID);
    }

    public int getNumResults() {
        return ByteOrder.ubyte2int(this.getPayload()[0]);
    }

    private static byte[] derivePayload(int numResults) {
        if (numResults < 0 || numResults > 255) {
            throw new IllegalArgumentException("Number of results too big: " + numResults);
        }
        byte[] payload = new byte[1];
        byte[] bytes = new byte[2];
        ByteOrder.short2leb((short)numResults, bytes, 0);
        payload[0] = bytes[0];
        return payload;
    }

    public boolean equals(Object other) {
        if (other instanceof LimeACKVendorMessage) {
            GUID myGuid = new GUID(this.getGUID());
            GUID otherGuid = new GUID(((VendorMessage)other).getGUID());
            int otherResults = ((LimeACKVendorMessage)other).getNumResults();
            return myGuid.equals(otherGuid) && this.getNumResults() == otherResults && super.equals(other);
        }
        return false;
    }

    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
        if (Message.RECORD_STATS) {
            SentMessageStatHandler.UDP_LIME_ACK.addMessage(this);
        }
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

