/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;

public final class QueryDispatcher
implements Runnable {
    private final Map QUERIES = new HashMap();
    private final List NEW_QUERIES = Collections.synchronizedList(new LinkedList());
    private static volatile boolean _done = true;
    private static final QueryDispatcher INSTANCE = new QueryDispatcher();
    private final Set TO_REMOVE = Collections.synchronizedSet(new HashSet());

    public static QueryDispatcher instance() {
        return INSTANCE;
    }

    private QueryDispatcher() {
    }

    public void start() {
        ManagedThread dispatcher = new ManagedThread(this, "QueryDispatcher");
        dispatcher.setDaemon(true);
        dispatcher.start();
    }

    public void addQuery(QueryHandler handler) {
        handler.sendQuery();
        this.NEW_QUERIES.add(handler);
    }

    public void removeReplyHandler(ReplyHandler handler) {
        if (!handler.isSupernodeClientConnection()) {
            return;
        }
        QueryDispatcher.removeFromCollection(this.NEW_QUERIES, handler);
        QueryDispatcher.removeFromMap(this.QUERIES, handler);
    }

    public void updateLeafResultsForQuery(GUID queryGUID, int numResults) {
        Map map = this.QUERIES;
        synchronized (map) {
            QueryHandler qh = (QueryHandler)this.QUERIES.get(queryGUID);
            if (qh != null) {
                qh.updateLeafResults(numResults);
            }
        }
    }

    public int getLeafResultsForQuery(GUID queryGUID) {
        Map map = this.QUERIES;
        synchronized (map) {
            QueryHandler qh = (QueryHandler)this.QUERIES.get(queryGUID);
            if (qh == null) {
                int n = -1;
                return n;
            }
            int n = qh.getNumResultsReportedByLeaf();
            return n;
        }
    }

    private static void removeFromCollection(Collection coll, ReplyHandler handler) {
        LinkedList toRemove = new LinkedList();
        Collection collection = coll;
        synchronized (collection) {
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                QueryHandler qh = (QueryHandler)iter.next();
                ReplyHandler rh = qh.getReplyHandler();
                if (handler != rh) continue;
                toRemove.add(qh);
            }
            coll.removeAll(toRemove);
        }
    }

    private static void removeFromMap(Map map, ReplyHandler handler) {
        LinkedList toRemove = new LinkedList();
        Map map2 = map;
        synchronized (map2) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                QueryHandler qh = (QueryHandler)((Map.Entry)iter.next()).getValue();
                if (qh.getReplyHandler() != handler) continue;
                toRemove.add(qh.getGUID());
            }
            iter = toRemove.iterator();
            while (iter.hasNext()) {
                map.remove((GUID)iter.next());
            }
        }
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep(400L);
                this.processQueries();
            }
        }
        catch (Throwable t) {
            ErrorService.error(t);
            return;
        }
    }

    private void processQueries() {
        if (!_done) {
            return;
        }
        _done = false;
        List list = this.NEW_QUERIES;
        synchronized (list) {
            Map map = this.QUERIES;
            synchronized (map) {
                Iterator iter = this.NEW_QUERIES.iterator();
                while (iter.hasNext()) {
                    QueryHandler qh = (QueryHandler)iter.next();
                    this.QUERIES.put(qh.getGUID(), qh);
                }
            }
            this.NEW_QUERIES.clear();
        }
        LinkedList expiredQueries = new LinkedList();
        Map map = this.QUERIES;
        synchronized (map) {
            Iterator iter = this.QUERIES.entrySet().iterator();
            while (iter.hasNext()) {
                QueryHandler handler = (QueryHandler)((Map.Entry)iter.next()).getValue();
                if (this.TO_REMOVE.contains(handler.getGUID())) {
                    this.TO_REMOVE.remove(handler.getGUID());
                    expiredQueries.add(handler);
                } else {
                    handler.sendQuery();
                }
                if (!handler.hasEnoughResults()) continue;
                expiredQueries.add(handler);
            }
            iter = expiredQueries.iterator();
            while (iter.hasNext()) {
                QueryHandler qh = (QueryHandler)iter.next();
                this.QUERIES.remove(qh.getGUID());
            }
        }
        _done = true;
    }

    public void addToRemove(GUID g) {
        this.TO_REMOVE.add(g);
    }
}

