/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import java.util.Hashtable;
import java.util.Properties;

public abstract class Setting {
    protected final Properties DEFAULT_PROPS;
    protected final Properties PROPS;
    protected final String KEY;
    protected final String DEFAULT_VALUE;
    private boolean _alwaysSave = false;

    protected Setting(Properties defaultProps, Properties props, String key, String defaultValue) {
        this.DEFAULT_PROPS = defaultProps;
        this.PROPS = props;
        this.KEY = key;
        this.DEFAULT_VALUE = defaultValue;
        if (((Hashtable)this.DEFAULT_PROPS).containsKey(key)) {
            throw new IllegalArgumentException("duplicate setting key");
        }
        ((Hashtable)this.DEFAULT_PROPS).put(this.KEY, defaultValue);
        this.loadValue(defaultValue);
    }

    public void reload() {
        String value = this.PROPS.getProperty(this.KEY);
        if (value == null) {
            value = this.DEFAULT_VALUE;
        }
        this.loadValue(value);
    }

    public void revertToDefault() {
        this.setValue(this.DEFAULT_VALUE);
    }

    public boolean shouldAlwaysSave() {
        return this._alwaysSave;
    }

    public Setting setAlwaysSave(boolean save) {
        this._alwaysSave = save;
        return this;
    }

    public boolean isDefault() {
        String value = this.PROPS.getProperty(this.KEY);
        if (value == null) {
            return false;
        }
        return value.equals(this.DEFAULT_PROPS.getProperty(this.KEY));
    }

    public String getKey() {
        return this.KEY;
    }

    public String getValueAsString() {
        return this.PROPS.getProperty(this.KEY);
    }

    protected void setValue(String value) {
        ((Hashtable)this.PROPS).put(this.KEY, value);
        this.loadValue(value);
    }

    protected abstract void loadValue(String var1);
}

