/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TigerTreeCache
implements Serializable {
    private static TigerTreeCache instance = null;
    private static final ProcessingQueue QUEUE = new ProcessingQueue("TreeHashTread");
    private static final transient Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$tigertree$TigerTreeCache == null ? (class$com$limegroup$gnutella$tigertree$TigerTreeCache = TigerTreeCache.class$("com.limegroup.gnutella.tigertree.TigerTreeCache")) : class$com$limegroup$gnutella$tigertree$TigerTreeCache);
    private static Map TREE_MAP;
    private static final File CACHE_FILE;
    static /* synthetic */ Class class$com$limegroup$gnutella$tigertree$TigerTreeCache;

    public static synchronized TigerTreeCache instance() {
        if (instance == null) {
            instance = new TigerTreeCache();
        }
        return instance;
    }

    public synchronized HashTree getHashTree(FileDesc fd) {
        HashTree tree = (HashTree)TREE_MAP.get(fd.getSHA1Urn());
        if (tree == null) {
            QUEUE.add(new HashRunner(fd));
        }
        return tree;
    }

    public synchronized HashTree getHashTree(URN sha1) {
        HashTree tree = (HashTree)TREE_MAP.get(sha1);
        return tree;
    }

    public synchronized void purgeTree(URN sha1) {
        TREE_MAP.remove(sha1);
    }

    public static synchronized void addHashTree(URN sha1, HashTree tree) {
        if (tree.isGoodDepth()) {
            TREE_MAP.put(sha1, tree);
            if (LOG.isDebugEnabled()) {
                LOG.debug("added hashtree for urn " + sha1 + ";" + tree.getRootHash());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("hashtree for urn " + sha1 + " had bad depth");
        }
    }

    private TigerTreeCache() {
        TREE_MAP = TigerTreeCache.createMap();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map createMap() {
        ois = null;
        try {
            try {
                ois = new ObjectInputStream(new FileInputStream(TigerTreeCache.CACHE_FILE));
                var1_1 = (Map)ois.readObject();
                var11_3 = null;
                if (ois == null) return var1_1;
            }
            catch (IOException e) {
                var2_23 = new HashMap();
                var11_4 = null;
                if (ois == null) return var2_23;
                try {
                    ois.close();
                    return var2_23;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return var2_23;
            }
            catch (ClassCastException e) {
                var3_25 = new HashMap();
                var11_5 = null;
                if (ois == null) return var3_25;
                ** try [egrp 2[TRYBLOCK] [9 : 176->183)] { 
lbl27:
                // 1 sources

                ois.close();
                return var3_25;
lbl29:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var3_25;
            }
            catch (ClassNotFoundException e) {
                var4_27 = new HashMap();
                var11_6 = null;
                if (ois == null) return var4_27;
                ** try [egrp 2[TRYBLOCK] [9 : 176->183)] { 
lbl38:
                // 1 sources

                ois.close();
                return var4_27;
lbl40:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var4_27;
            }
            catch (ArrayStoreException e) {
                var5_29 = new HashMap();
                var11_7 = null;
                if (ois == null) return var5_29;
                ** try [egrp 2[TRYBLOCK] [9 : 176->183)] { 
lbl49:
                // 1 sources

                ois.close();
                return var5_29;
lbl51:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var5_29;
            }
            catch (IndexOutOfBoundsException e) {
                var6_31 = new HashMap();
                var11_8 = null;
                if (ois == null) return var6_31;
                ** try [egrp 2[TRYBLOCK] [9 : 176->183)] { 
lbl60:
                // 1 sources

                ois.close();
                return var6_31;
lbl62:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var6_31;
            }
            catch (NegativeArraySizeException e) {
                var7_33 = new HashMap();
                var11_9 = null;
                if (ois == null) return var7_33;
                ** try [egrp 2[TRYBLOCK] [9 : 176->183)] { 
lbl71:
                // 1 sources

                ois.close();
                return var7_33;
lbl73:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var7_33;
            }
            catch (IllegalStateException e) {
                var8_35 = new HashMap();
                var11_10 = null;
                if (ois == null) return var8_35;
                ** try [egrp 2[TRYBLOCK] [9 : 176->183)] { 
lbl82:
                // 1 sources

                ois.close();
                return var8_35;
lbl84:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var8_35;
            }
            catch (SecurityException e) {
                var9_37 = new HashMap();
                var11_11 = null;
                if (ois == null) return var9_37;
                ** try [egrp 2[TRYBLOCK] [9 : 176->183)] { 
lbl93:
                // 1 sources

                ois.close();
                return var9_37;
lbl95:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var9_37;
            }
        }
        catch (Throwable var10_38) {
            var11_12 = null;
            if (ois == null) throw var10_38;
            try {}
            catch (IOException e) {
                throw var10_38;
            }
            ois.close();
            throw var10_38;
        }
        ** try [egrp 2[TRYBLOCK] [9 : 176->183)] { 
lbl109:
        // 1 sources

        ois.close();
        return var1_1;
lbl111:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var1_1;
    }

    private static void removeOldEntries(Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            URN sha1 = (URN)iter.next();
            if (RouterService.getFileManager().getFileDescForUrn(sha1) != null || RouterService.getDownloadManager().getIncompleteFileManager().getFileForUrn(sha1) != null || Math.random() > (double)(map.size() / 200)) continue;
            map.remove(sha1);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void persistCache() {
        TigerTreeCache.removeOldEntries(TREE_MAP);
        ObjectOutputStream oos = null;
        oos = new ObjectOutputStream(new FileOutputStream(CACHE_FILE));
        oos.writeObject(TREE_MAP);
        Object var4_2 = null;
        if (oos == null) return;
        try {
            oos.close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (Exception e) {
                ErrorService.error(e);
                Object var4_3 = null;
                if (oos == null) return;
                try {
                    oos.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttree.cache");
    }

    private static class HashRunner
    implements Runnable {
        private final FileDesc FD;

        HashRunner(FileDesc fd) {
            this.FD = fd;
        }

        public void run() {
            try {
                URN sha1 = this.FD.getSHA1Urn();
                if (TigerTreeCache.instance().getHashTree(sha1) == null) {
                    HashTree tree = HashTree.createHashTree(this.FD);
                    TigerTreeCache.addHashTree(sha1, tree);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

