/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.update.AbstractRemoteUpdateInfo;
import com.limegroup.gnutella.update.DisplayMessageUpdator;
import com.limegroup.gnutella.update.MultipleFileUpdator;
import com.limegroup.gnutella.update.NoUpdateUpdator;
import com.limegroup.gnutella.update.Updator;
import com.limegroup.gnutella.update.WebPageUpdator;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.IOException;
import java.util.StringTokenizer;

public final class ClientRemoteUpdateInfo
extends AbstractRemoteUpdateInfo {
    private Updator _updator = new NoUpdateUpdator();

    final void addRemoteInfo(String infoLine) {
        StringTokenizer st = new StringTokenizer(infoLine, "&");
        while (st.hasMoreTokens()) {
            this.handleKeyValuePair(st.nextToken());
        }
    }

    final Updator getUpdator() {
        return this._updator;
    }

    private final void handleKeyValuePair(String line) {
        if (line.startsWith("DIRECTIVE")) {
            this.setUpdator(line);
        } else if (line.startsWith("MESSAGE_TO_DISPLAY")) {
            String value = this.getUpdateValue(line);
            this._updator.setMessageToDisplay(value);
        } else if (line.startsWith("UPDATE_URL")) {
            String value = this.getUpdateValue(line);
            this._updator.setUpdateURL(value);
        } else if (line.startsWith("UPDATE_CLASSPATH")) {
            String value = this.getUpdateValue(line);
            this._updator.setClassPath(value);
        } else if (line.startsWith("UPDATE_MAIN_CLASS")) {
            String value = this.getUpdateValue(line);
            this._updator.setMainClass(value);
        }
    }

    private final String getUpdateValue(String line) {
        int index = line.lastIndexOf("=") + 1;
        try {
            line = URLDecoder.decode(line.substring(index));
        }
        catch (IOException e) {
            ErrorService.error(e);
            return line;
        }
        return line.trim();
    }

    private final void setUpdator(String str) {
        int index = str.lastIndexOf("=") + 1;
        String directiveValue = "";
        try {
            directiveValue = URLDecoder.decode(str.substring(index));
        }
        catch (IOException e) {
            this._updator = new NoUpdateUpdator();
            return;
        }
        if (directiveValue.startsWith("NO_UPDATE")) {
            this._updator = new NoUpdateUpdator();
        } else if (directiveValue.startsWith("UPDATE_JAR")) {
            this._updator = new MultipleFileUpdator();
        } else if (directiveValue.startsWith("OPEN_WEB_PAGE")) {
            this._updator = new WebPageUpdator();
        } else if (directiveValue.startsWith("DISPLAY_MESSAGE")) {
            this._updator = new DisplayMessageUpdator();
        }
    }

    public String toString() {
        return "ClientRemoteUpdateInfo::Updator: " + this._updator.toString();
    }
}

