/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.update.AbstractUpdator;
import com.limegroup.gnutella.update.FileDownloadException;
import com.limegroup.gnutella.update.FileDownloader;
import com.limegroup.gnutella.update.LaxFileUpdateException;
import com.limegroup.gnutella.update.gui.UpdateCallback;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

final class MultipleFileUpdator
extends AbstractUpdator
implements Runnable {
    private final String LAX_FILE_NAME = "LimeWire.lax";
    private volatile boolean _updateCancelled = false;
    private FileDownloader _fileDownloader;

    MultipleFileUpdator() {
        this._updateType = "MultipleFileUpdator";
        this._fileDownloader = new FileDownloader();
    }

    public synchronized void cancelUpdate() {
        this._updateCancelled = true;
        this._fileDownloader.stopDownload();
        UpdateCallback.hideProgressWindow();
        this.notifyAll();
    }

    public void doUpdate() {
        boolean update = UpdateCallback.showUpdatePrompt(this._message);
        if (!update) {
            return;
        }
        MultipleFileUpdator multipleFileUpdator = this;
        synchronized (multipleFileUpdator) {
            ManagedThread jarUpdateThread = new ManagedThread(this, "FileUpdater");
            jarUpdateThread.setDaemon(true);
            jarUpdateThread.start();
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    public void run() {
        StringTokenizer st = new StringTokenizer(this._url, ";");
        String curUrl = "";
        String curFile = "";
        UpdateCallback.showProgressWindow();
        while (st.hasMoreTokens() && !this._updateCancelled) {
            curUrl = st.nextToken();
            curFile = this.getNewFileName(curUrl);
            try {
                String newFileName = this.getNewFileName(curUrl);
                String newFilePath = this.getNewFilePath(newFileName);
                this._fileDownloader.downloadFile(curUrl, newFilePath);
            }
            catch (FileDownloadException fde) {
                this.displayErrorAndExit(fde.getMessage());
            }
        }
        if (!this._updateCancelled) {
            this.applyUpdateSettings();
            this.displayUpdateSucceededMessage();
            GUIMediator.shutdown();
        }
    }

    private void displayUpdateSucceededMessage() {
        UpdateCallback.hideProgressWindow();
        String msg = "UPDATE_SUCCEEDED_MESSAGE";
        UpdateCallback.displayMessage(msg);
    }

    private void applyUpdateSettings() {
        if (CommonUtils.isMacClassic()) {
            try {
                this.applyLaxSettings();
            }
            catch (LaxFileUpdateException lfue) {
                this.displayErrorAndExit(lfue.getMessage());
            }
        } else {
            this.applyStandardSettings();
        }
    }

    private void applyStandardSettings() {
        ApplicationSettings.JAR_NAME.setValue(this._classpath);
        SettingsHandler.save();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyLaxSettings() throws LaxFileUpdateException {
        Properties props = new Properties();
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            try {
                File laxFile = new File("LimeWire.lax");
                fis = new FileInputStream(laxFile);
                props.load(fis);
                ((Hashtable)props).put("lax.class.path", this._classpath);
                ((Hashtable)props).put("lax.main.class", this._mainClass);
                fis.close();
                fos = new FileOutputStream(laxFile);
                props.save(fos, "");
                fos.close();
            }
            catch (FileNotFoundException fnfe) {
                String msg = "UPDATE_ERROR_LAX_FILE_NOT_FOUND";
                throw new LaxFileUpdateException(msg);
            }
            catch (SecurityException se) {
                String msg = "UPDATE_ERROR_LAX_SECURITY";
                throw new LaxFileUpdateException(msg);
            }
            catch (IOException ioe) {
                String msg = "UPDATE_ERROR_LAX_IO";
                throw new LaxFileUpdateException(msg);
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (fis != null) {
            fis.close();
        }
        if (fos == null) return;
        fos.close();
        return;
    }

    private void displayErrorAndExit(String msg) {
        UpdateCallback.displayErrorMessage(msg);
        GUIMediator.shutdown();
    }

    private String getNewFileName(String url) {
        int index = url.lastIndexOf("/") + 1;
        return url.substring(index);
    }

    private String getNewFilePath(String newFileName) {
        return new File(newFileName).getAbsolutePath();
    }
}

