/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update;

import com.limegroup.gnutella.update.AbstractRemoteUpdateInfo;
import com.limegroup.gnutella.update.ServletLocalUpdateInfo;
import java.io.IOException;
import java.net.URLEncoder;

public final class ServletRemoteUpdateInfo
extends AbstractRemoteUpdateInfo {
    private final String AD_URL = "http://version.limewire.com/updates/ads.war";
    private String _directive = "NO_UPDATE";
    private String _url = "";
    private String _message = "";
    private String _classpath = "";
    private String _mainClass = "";
    private final String[] IGNORE_LIST = new String[]{"@version@"};
    private static final String MAJOR_VERSION = "3";
    private static final String MINOR_VERSION = "6";
    private static final String BUILD_VERSION = "14";
    static final String LIMEWIRE_VERSION_ON_SERVER = "3.6.14";
    private static final String LIMEWIRE_VERSION_ON_SERVER_TO_COMPARE = "3.6";
    private static final String UPDATE_JAR_NAME = "LimeWire3614.jar";
    private final String AD_VERSION_ON_SERVER = "1.1";
    private static final String FREE_UPDATE_NOW_MESSAGE = "Upgrade to LimeWire 3.6.14!  This version provides faster search results, turbo-charged searches/downloads in the pro version, Panther support, and much, much more.  Would you like to update now?";
    private static final String STRONG_FREE_UPDATE_NOW_MESSAGE = "Upgrade to LimeWire 3.6.14!  ALL USERS OF LIMEWIRE VERSIONS PRIOR TO 2.6 MUST UPGRADE NOW!  THE NEW VERSIONS INCLUDE GWEBCACHE SUPPORT, WHICH IS REQUIRED TO CONNECT TO THE NETWORK!  This version also includes better search results and faster downloads.  Update now?";
    private static final String PRO_UPDATE_NOW_MESSAGE = "Upgrade to LimeWire 3.6.14 Pro!  This version provides faster search results, turbo-charged searches/downloads in the pro version, Panther support, and much, much more.  Would you like to update now?";
    private static final String STRONG_PRO_UPDATE_NOW_MESSAGE = "Upgrade to LimeWire 3.6.14 Pro!  ALL USERS OF LIMEWIRE VERSIONS PRIOR TO 2.6 MUST UPGRADE NOW!  THE NEW VERSIONS INCLUDE GWEBCACHE SUPPORT, WHICH IS REQUIRED TO CONNECT TO THE NETWORK!  This version also includes better search results and faster downloads.  Update now?";
    private final String FREE_DISPLAY_MESSAGE_UPDATE_MESSAGE = "Version 3.6.14 of LimeWire is available from www.limewire.com. Would you like to start your old version now?";
    private final String PRO_DISPLAY_MESSAGE_UPDATE_MESSAGE = "Version 3.6.14 of LimeWire Pro is available, and you can access it from the web page that we sent you when you first purchased LimeWire Pro.  Would you like to start your old version now?";
    private final String MAIN_CLASS = "com.limegroup.gnutella.gui.Main";
    private static final String COLLECTIONS = "collections.jar";
    private static final String XERCES = "xerces.jar";
    private static final String PLAYER = "jl011.jar";
    private static final String MESSAGES = "MessagesBundles.jar";
    private static final String OLD_MESSAGES = "MessagesBundle.properties";
    private final String NON_WINDOWS_CLASSPATH = "LimeWire3614.jar";
    private final String WINDOWS_CLASSPATH = "LimeWire3614.jar";
    private final String WEB_FREE_UPDATE_URL = "http://www.limewire.com/index.jsp/download";
    private final String WEB_PRO_UPDATE_URL = "http://www.limewire.com/index.jsp/update";
    private static final String BASE_UPDATE_URL = "http://version.limewire.com/updates/";
    private static final String PRO_UPDATE_URL = "http://version.limewire.com/updates/pro/";
    private static final String FREE_UPDATE_URL = "http://version.limewire.com/updates/free/";
    private static final String MESSAGES_BUNDLE_URL = "http://version.limewire.com/updates/MessagesBundles.jar";
    private static final String OLD_MESSAGES_BUNDLE_URL = "http://version.limewire.com/updates/MessagesBundle.properties";
    private static final String XML_URL = "http://version.limewire.com/updates/xml.war";
    private static final String ADS_URL = "http://version.limewire.com/updates/ads.war";
    private final String PRO_JAR_UPDATE_URL = "http://version.limewire.com/updates/pro/LimeWire3614.jar;http://version.limewire.com/updates/MessagesBundles.jar;http://version.limewire.com/updates/xml.war;http://version.limewire.com/updates/MessagesBundle.properties";
    private final String FREE_JAR_UPDATE_URL = "http://version.limewire.com/updates/free/LimeWire3614.jar;http://version.limewire.com/updates/ads.war;http://version.limewire.com/updates/MessagesBundles.jar;http://version.limewire.com/updates/xml.war;http://version.limewire.com/updates/MessagesBundle.properties";

    private ServletRemoteUpdateInfo() {
    }

    public ServletRemoteUpdateInfo(ServletLocalUpdateInfo localInfo) throws IOException {
        String version = localInfo.getLimeWireVersion();
        String os = localInfo.getOS();
        String javaVersion = localInfo.getJavaVersion();
        if (version == null || version.equals("")) {
            throw new IOException("invalid version");
        }
        if (os == null || os.equals("")) {
            throw new IOException("invalid operating system");
        }
        int i = 0;
        while (i < this.IGNORE_LIST.length) {
            if (version.endsWith(this.IGNORE_LIST[i])) {
                return;
            }
            ++i;
        }
        boolean isPro = false;
        if (version.endsWith("Pro")) {
            isPro = true;
        }
        if ((version = version.substring(0, 3)).equals("2.9")) {
            return;
        }
        if (version.equals("2.8") && javaVersion.startsWith("1.4")) {
            return;
        }
        String majorVersion = version.substring(0, 1);
        int mv = Integer.parseInt(majorVersion);
        if (mv >= 3) {
            return;
        }
        if (!isPro && !version.equals(LIMEWIRE_VERSION_ON_SERVER_TO_COMPARE)) {
            this.setValuesForFreeVersionUpdate(version, os);
        } else if (isPro && !version.equals(LIMEWIRE_VERSION_ON_SERVER_TO_COMPARE)) {
            this.setValuesForProVersionUpdate(version, os);
        }
    }

    private void setValuesForAdUpdate(String lwVersion, String os) {
        if (lwVersion.startsWith("1.")) {
            return;
        }
        this._directive = "UPDATE_ADS_STRING";
        this._url = ADS_URL;
    }

    private void setValuesForFreeVersionUpdate(String version, String os) {
        if (os.indexOf("Win") != -1) {
            this.setValuesForFreeWindowsUpdate(version);
        } else if (os.indexOf("Sol") != -1) {
            this.setValuesForFreeOtherUpdate(version);
        } else if (os.indexOf("Lin") != -1) {
            this.setValuesForFreeOtherUpdate(version);
        } else if (os.startsWith("Mac")) {
            if (os.endsWith("X")) {
                this.setValuesForFreeOSXUpdate(version);
            } else {
                this.setValuesForFreeMacUpdate(version);
            }
        } else {
            this.setValuesForFreeOtherUpdate(version);
        }
    }

    private void setValuesForProVersionUpdate(String version, String os) {
        if (os.indexOf("Win") != -1) {
            this.setValuesForProWindowsUpdate(version);
        } else if (os.indexOf("Sol") != -1) {
            this.setValuesForProOtherUpdate(version);
        } else if (os.indexOf("Lin") != -1) {
            this.setValuesForProOtherUpdate(version);
        } else if (os.startsWith("Mac")) {
            if (os.endsWith("X")) {
                this.setValuesForProOSXUpdate(version);
            } else {
                this.setValuesForProMacUpdate(version);
            }
        } else {
            this.setValuesForProOtherUpdate(version);
        }
    }

    public String getURLEncodedString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DIRECTIVE");
        sb.append("=");
        sb.append(URLEncoder.encode(this._directive));
        sb.append("&");
        sb.append("UPDATE_URL");
        sb.append("=");
        sb.append(URLEncoder.encode(this._url));
        sb.append("&");
        sb.append("MESSAGE_TO_DISPLAY");
        sb.append("=");
        sb.append(URLEncoder.encode(this._message));
        sb.append("&");
        sb.append("UPDATE_CLASSPATH");
        sb.append("=");
        sb.append(URLEncoder.encode(this._classpath));
        sb.append("&");
        sb.append("UPDATE_MAIN_CLASS");
        sb.append("=");
        sb.append(URLEncoder.encode(this._mainClass));
        return sb.toString();
    }

    private void setValuesForProWindowsUpdate(String lwVersion) {
        this._directive = "OPEN_WEB_PAGE";
        this._url = "http://www.limewire.com/index.jsp/update";
        this._message = !lwVersion.startsWith("2.6") && !lwVersion.startsWith("2.7") && !lwVersion.startsWith("2.8") ? STRONG_PRO_UPDATE_NOW_MESSAGE : PRO_UPDATE_NOW_MESSAGE;
    }

    private void setValuesForProMacUpdate(String lwVersion) {
        this.setValuesForProWindowsUpdate(lwVersion);
    }

    private void setValuesForProOSXUpdate(String lwVersion) {
        this.setValuesForProWindowsUpdate(lwVersion);
    }

    private void setValuesForProOtherUpdate(String lwVersion) {
        this._directive = "DISPLAY_MESSAGE";
        this._message = "Version 3.6.14 of LimeWire Pro is available, and you can access it from the web page that we sent you when you first purchased LimeWire Pro.  Would you like to start your old version now?";
    }

    private void setValuesForFreeWindowsUpdate(String lwVersion) {
        this._directive = "OPEN_WEB_PAGE";
        this._url = "http://www.limewire.com/index.jsp/download";
        this._message = !lwVersion.startsWith("2.6") && !lwVersion.startsWith("2.7") ? STRONG_FREE_UPDATE_NOW_MESSAGE : FREE_UPDATE_NOW_MESSAGE;
    }

    private void setValuesForFreeMacUpdate(String lwVersion) {
        this.setValuesForFreeWindowsUpdate(lwVersion);
    }

    private void setValuesForFreeOSXUpdate(String lwVersion) {
        this.setValuesForFreeWindowsUpdate(lwVersion);
    }

    private void setValuesForFreeOtherUpdate(String lwVersion) {
        this._directive = "DISPLAY_MESSAGE";
        this._message = "Version 3.6.14 of LimeWire is available from www.limewire.com. Would you like to start your old version now?";
    }

    public String toString() {
        return "ServletRemoteUpdateInfo\r\ndirective:  " + this._directive + "\r\n" + "url:        " + this._url + "\r\n" + "message:    " + this._message + "\r\n" + "classpath:  " + this._classpath + "\r\n" + "main class: " + this._mainClass;
    }

    public static void main(String[] args) {
        String version = args[0];
        if ((version = version.substring(0, 3)).equals("2.8")) {
            System.out.println("2.8...returning...");
            return;
        }
        if (version.equals("2.9")) {
            System.out.println("2.9...returning...");
            return;
        }
        String majorVersion = version.substring(0, 1);
        int mv = Integer.parseInt(majorVersion);
        if (mv >= 3) {
            System.out.println("3.0 or above...returning...");
            return;
        }
        ServletRemoteUpdateInfo updator = new ServletRemoteUpdateInfo();
        String os = "Windows";
        String[] versions = new String[]{"2.7.13 Pro", "2.7.13", "2.6.5"};
        int i = 0;
        while (i < versions.length) {
            version = versions[i];
            boolean isPro = false;
            if (version.endsWith("Pro")) {
                isPro = true;
            }
            version = version.substring(0, 3);
            System.out.println("version: " + version);
            if (!isPro && !version.equals(LIMEWIRE_VERSION_ON_SERVER_TO_COMPARE)) {
                System.out.println("about to set free update");
                updator.setValuesForFreeVersionUpdate(version, os);
            } else if (isPro && !version.equals(LIMEWIRE_VERSION_ON_SERVER_TO_COMPARE)) {
                System.out.println("about to set pro update");
                updator.setValuesForProVersionUpdate(version, os);
            }
            ++i;
        }
    }
}

