/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.update.gui.ProgressWindow;
import com.limegroup.gnutella.update.gui.UpdatePanel;
import java.awt.Component;
import javax.swing.SwingUtilities;

public final class UpdateCallback {
    private static ProgressWindow _progressWindow = new ProgressWindow();

    public static final boolean showUpdatePrompt(String message) {
        UpdatePanel panel = UpdatePanel.createFloatingUpdatePanel(message);
        int response = panel.showDialog();
        return response == 11;
    }

    public static final boolean showUpdatePromptWithParentFrame(String message) {
        UpdatePanel panel = UpdatePanel.createUpdatePanelWithParentFrame(message);
        int response = panel.showDialog();
        return response == 11;
    }

    public static final void showProgressWindow() {
        ((Component)_progressWindow).setVisible(true);
    }

    public static final void setDownloadFile(String text) {
        _progressWindow.setDownloadFile(text);
    }

    public static final void setDownloadSize(int size) {
        _progressWindow.setDownloadSize(size);
    }

    public static final void hideProgressWindow() {
        ((Component)_progressWindow).setVisible(false);
        _progressWindow.dispose();
    }

    public static final void updateProgressWindow(int amountRead) {
        _progressWindow.setAmountRead(amountRead);
        SwingUtilities.invokeLater(_progressWindow);
    }

    public static final void displayErrorMessage(String error) {
        String msgStart = "UPDATE_ERROR_MESSAGE_START";
        String msgEnd = "UPDATE_ERROR_MESSAGE_END";
        GUIMediator.showError(msgStart, (Object)error, msgEnd);
    }

    public static final void displayMessage(String message) {
        GUIMediator.showMessage(message);
    }
}

