/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update.gui;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;

final class UpdatePanel {
    private final JDialog DIALOG;
    private int _responseCode;
    static final int UPDATE_LATER = 10;
    static final int UPDATE_NOW = 11;

    static UpdatePanel createUpdatePanelWithParentFrame(String msg) {
        return new UpdatePanel(msg, true);
    }

    static UpdatePanel createFloatingUpdatePanel(String msg) {
        return new UpdatePanel(msg, false);
    }

    private UpdatePanel(String msg, boolean useMainFrame) {
        int WIDTH = 360;
        this.DIALOG = useMainFrame ? new JDialog(GUIMediator.getAppFrame()) : new JDialog();
        this.DIALOG.setModal(true);
        this.DIALOG.setTitle(GUIMediator.getStringResource("UPDATE_DIALOG_CAPTION"));
        MultiLineLabel label = new MultiLineLabel(msg, 320);
        String[] buttonLabels = new String[]{"YES", "NO"};
        String[] buttonTips = new String[]{"UPDATE_NOW_TIP", "UPDATE_LATER_TIP"};
        ActionListener[] buttonListeners = new ActionListener[]{new UpdateNowListener(), new UpdateLaterListener()};
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        mainPanel.add(label);
        ButtonRow buttonRow = new ButtonRow(buttonLabels, buttonTips, buttonListeners);
        Container contentPane = this.DIALOG.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(mainPanel);
        contentPane.add(Box.createVerticalGlue());
        contentPane.add(buttonRow);
        this.DIALOG.pack();
    }

    int showDialog() {
        ((Component)this.DIALOG).setLocation(GUIMediator.getScreenCenterPoint(this.DIALOG));
        ((Component)this.DIALOG).setVisible(true);
        return this._responseCode;
    }

    private final class UpdateLaterListener
    implements ActionListener {
        private UpdateLaterListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UpdatePanel.this._responseCode = 10;
                ((Component)UpdatePanel.this.DIALOG).setVisible(false);
                UpdatePanel.this.DIALOG.dispose();
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private final class UpdateNowListener
    implements ActionListener {
        private UpdateNowListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UpdatePanel.this._responseCode = 11;
                ((Component)UpdatePanel.this.DIALOG).setVisible(false);
                UpdatePanel.this.DIALOG.dispose();
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

