/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.OutputStream;

public class QueuedUploadState
implements HTTPMessage {
    private final FileDesc FILE_DESC;
    private final HTTPUploader UPLOADER;
    private final int POSITION;

    public QueuedUploadState(int pos, HTTPUploader uploader) {
        this.POSITION = pos;
        this.UPLOADER = uploader;
        this.FILE_DESC = uploader.getFileDesc();
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        URN sha1;
        Assert.that(this.POSITION != -1);
        String str = "HTTP/1.1 503 Service Unavailable\r\n";
        ostream.write(str.getBytes());
        HTTPUtils.writeHeader(HTTPHeaderName.SERVER, ConstantHTTPHeaderValue.SERVER_VALUE, ostream);
        str = "X-Queue: position=" + (this.POSITION + 1) + ", pollMin=" + 45 + ", pollMax=" + 120 + "\r\n";
        ostream.write(str.getBytes());
        if (this.FILE_DESC != null && (sha1 = this.FILE_DESC.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)this.FILE_DESC.getSHA1Urn(), ostream);
            Set alts = this.UPLOADER.getNextSetOfAltsToSend();
            if (alts.size() > 0) {
                HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(alts), ostream);
            }
            if (this.FILE_DESC instanceof IncompleteFileDesc) {
                HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)((IncompleteFileDesc)this.FILE_DESC), ostream);
            }
        }
        if (this.UPLOADER.isFirstReply()) {
            HTTPUtils.writeFeatures(ostream);
        }
        if (this.FILE_DESC.getHashTree() != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.THEX_URI, (HTTPHeaderValue)this.FILE_DESC.getHashTree(), ostream);
        }
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
    }

    public boolean getCloseConnection() {
        return false;
    }
}

