/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.ThrottledOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

public class THEXUploadState
implements HTTPMessage {
    private final FileDesc FILE_DESC;
    private final HTTPUploader UPLOADER;
    private final HashTree TREE;
    private final StalledUploadWatchdog WATCHDOG;
    private static final BandwidthThrottle THROTTLE = new BandwidthThrottle(512.0f);

    public THEXUploadState(HTTPUploader uploader, StalledUploadWatchdog dog) {
        this.UPLOADER = uploader;
        this.FILE_DESC = uploader.getFileDesc();
        this.TREE = this.FILE_DESC.getHashTree();
        if (this.TREE == null) {
            throw new NullPointerException("null TREE in THEXUploadState");
        }
        this.WATCHDOG = dog;
    }

    public void writeMessageHeaders(OutputStream network) throws IOException {
        StringWriter os = new StringWriter();
        os.write("HTTP/1.1 200 OK\r\n");
        HTTPUtils.writeHeader(HTTPHeaderName.SERVER, ConstantHTTPHeaderValue.SERVER_VALUE, (Writer)os);
        HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)this.FILE_DESC.getSHA1Urn(), (Writer)os);
        HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_LENGTH, this.TREE.getOutputLength(), (Writer)os);
        HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_TYPE, this.TREE.getOutputType(), (Writer)os);
        os.write("\r\n");
        this.WATCHDOG.activate(network);
        try {
            network.write(os.toString().getBytes());
            Object var4_3 = null;
            this.WATCHDOG.deactivate();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.WATCHDOG.deactivate();
            throw throwable;
        }
    }

    public void writeMessageBody(OutputStream os) throws IOException {
        ThrottledOutputStream slowStream = new ThrottledOutputStream(os, THROTTLE);
        this.WATCHDOG.activate(os);
        try {
            this.TREE.write(slowStream);
            Object var4_3 = null;
            this.WATCHDOG.deactivate();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.WATCHDOG.deactivate();
            throw throwable;
        }
    }

    public boolean getCloseConnection() {
        return false;
    }
}

