/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;

public class BucketQueue
implements Cloneable {
    private Buffer[] buckets;
    private int size = 0;

    public BucketQueue(int priorities, int capacityPerPriority) throws IllegalArgumentException {
        if (priorities <= 0) {
            throw new IllegalArgumentException("Bad priorities: " + priorities);
        }
        if (capacityPerPriority <= 0) {
            throw new IllegalArgumentException("Bad capacity: " + capacityPerPriority);
        }
        this.buckets = new Buffer[priorities];
        int i = 0;
        while (i < this.buckets.length) {
            this.buckets[i] = new Buffer(capacityPerPriority);
            ++i;
        }
    }

    public BucketQueue(int[] capacities) throws IllegalArgumentException {
        if (capacities.length <= 0) {
            throw new IllegalArgumentException();
        }
        this.buckets = new Buffer[capacities.length];
        int i = 0;
        while (i < this.buckets.length) {
            if (capacities[i] <= 0) {
                throw new IllegalArgumentException("Non-positive capacity: " + capacities[i]);
            }
            this.buckets[i] = new Buffer(capacities[i]);
            ++i;
        }
    }

    public BucketQueue(BucketQueue other) {
        this.buckets = new Buffer[other.buckets.length];
        int i = 0;
        while (i < this.buckets.length) {
            this.buckets[i] = new Buffer(other.buckets[i]);
            ++i;
        }
        this.size = other.size;
    }

    public void clear() {
        this.repOk();
        int i = 0;
        while (i < this.buckets.length) {
            this.buckets[i].clear();
            ++i;
        }
        this.size = 0;
        this.repOk();
    }

    public Object insert(Object o, int priority) {
        this.repOk();
        if (priority < 0 || priority >= this.buckets.length) {
            throw new IllegalArgumentException("Bad priority: " + priority);
        }
        Object ret = this.buckets[priority].addFirst(o);
        if (ret == null) {
            ++this.size;
        }
        this.repOk();
        return ret;
    }

    public boolean removeAll(Object o) {
        this.repOk();
        boolean ret = false;
        int i = 0;
        while (i < this.buckets.length) {
            ret |= this.buckets[i].removeAll(o);
            ++i;
        }
        if (ret) {
            this.size = 0;
            int i2 = 0;
            while (i2 < this.buckets.length) {
                this.size += this.buckets[i2].getSize();
                ++i2;
            }
        }
        this.repOk();
        return ret;
    }

    public Object extractMax() throws NoSuchElementException {
        this.repOk();
        try {
            int i = this.buckets.length - 1;
            while (i >= 0) {
                if (!this.buckets[i].isEmpty()) {
                    --this.size;
                    Object object = this.buckets[i].removeFirst();
                    Object var4_3 = null;
                    this.repOk();
                    return object;
                }
                --i;
            }
            throw new NoSuchElementException();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.repOk();
            throw throwable;
        }
    }

    public Object getMax() throws NoSuchElementException {
        int i = this.buckets.length - 1;
        while (i >= 0) {
            if (!this.buckets[i].isEmpty()) {
                return this.buckets[i].first();
            }
            --i;
        }
        throw new NoSuchElementException();
    }

    public int size() {
        return this.size;
    }

    public int size(int priority) throws IllegalArgumentException {
        if (priority < 0 || priority >= this.buckets.length) {
            throw new IllegalArgumentException("Bad priority: " + priority);
        }
        return this.buckets[priority].getSize();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new BucketQueueIterator(this.buckets.length - 1, this.size());
    }

    public Iterator iterator(int startPriority, int n) throws IllegalArgumentException {
        if (startPriority < 0 || startPriority >= this.buckets.length) {
            throw new IllegalArgumentException("Bad priority: " + startPriority);
        }
        return new BucketQueueIterator(startPriority, n);
    }

    public Object clone() {
        return new BucketQueue(this);
    }

    private void repOk() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int i = this.buckets.length - 1;
        while (i >= 0) {
            if (i != this.buckets.length - 1) {
                buf.append(", ");
            }
            buf.append(this.buckets[i].toString());
            --i;
        }
        buf.append("]");
        return buf.toString();
    }

    private class BucketQueueIterator
    extends UnmodifiableIterator {
        private Iterator currentIterator;
        private int currentBucket;
        private int left;

        public BucketQueueIterator(int startPriority, int n) {
            this.currentBucket = startPriority;
            this.currentIterator = BucketQueue.this.buckets[this.currentBucket].iterator();
            this.left = n;
        }

        public synchronized boolean hasNext() {
            if (this.left <= 0) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (this.currentBucket < 0) {
                return false;
            }
            --this.currentBucket;
            while (this.currentBucket >= 0) {
                this.currentIterator = BucketQueue.this.buckets[this.currentBucket].iterator();
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                --this.currentBucket;
            }
            return false;
        }

        public synchronized Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.left;
            return this.currentIterator.next();
        }
    }
}

