/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ByteOrder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class COBSUtil {
    public static byte[] cobsEncode(byte[] src) throws IOException {
        int srcLen = src.length;
        int code = 1;
        int currIndex = 0;
        int maxEncodingLen = src.length + (src.length + 1) / 254 + 1;
        ByteArrayOutputStream sink = new ByteArrayOutputStream(maxEncodingLen);
        int writeStartIndex = -1;
        while (currIndex < srcLen) {
            if (src[currIndex] == 0) {
                code = COBSUtil.finishBlock(code, sink, src, writeStartIndex, currIndex - 1);
                writeStartIndex = -1;
            } else {
                if (writeStartIndex < 0) {
                    writeStartIndex = currIndex;
                }
                if (++code == 255) {
                    code = COBSUtil.finishBlock(code, sink, src, writeStartIndex, currIndex);
                    writeStartIndex = -1;
                }
            }
            ++currIndex;
        }
        COBSUtil.finishBlock(code, sink, src, writeStartIndex, currIndex - 1);
        return sink.toByteArray();
    }

    private static int finishBlock(int code, ByteArrayOutputStream sink, byte[] src, int begin, int end) throws IOException {
        sink.write(code);
        if (begin > -1) {
            sink.write(src, begin, end - begin + 1);
        }
        return 1;
    }

    public static byte[] cobsDecode(byte[] src) throws IOException {
        int srcLen = src.length;
        int currIndex = 0;
        int code = 0;
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        while (currIndex < srcLen) {
            if (currIndex + ((code = ByteOrder.ubyte2int(src[currIndex++])) - 2) >= srcLen) {
                throw new IOException();
            }
            int i = 1;
            while (i < code) {
                sink.write(src[currIndex++]);
                ++i;
            }
            if (currIndex >= srcLen || code >= 255) continue;
            sink.write(0);
        }
        return sink.toByteArray();
    }
}

