/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CountingInputStream
extends FilterInputStream {
    private int _count = 0;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int read = super.read();
        ++this._count;
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this._count += read;
        return read;
    }

    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        this._count += (int)skipped;
        return skipped;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int getAmountRead() {
        return this._count;
    }
}

