/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.DoublyLinkedList;
import com.sun.java.util.collections.AbstractSet;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.UnsupportedOperationException;

public class FixedsizeForgetfulHashMap
implements Map {
    private Map map;
    private DoublyLinkedList removeList = new DoublyLinkedList();
    private int maxSize;
    private int currentSize;

    public FixedsizeForgetfulHashMap(int size) {
        this.map = new HashMap(size * 4 / 3 + 10, 0.75f);
        if (size < 1) {
            throw new IllegalArgumentException();
        }
        this.currentSize = 0;
        this.maxSize = size;
    }

    public Object get(Object key) {
        ValueElement pair = (ValueElement)this.map.get(key);
        return pair == null ? null : pair.getValue();
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            return null;
        }
        Object oldValue = this.addMapping(key, value);
        return oldValue;
    }

    private Object addMapping(Object key, Object value) {
        DoublyLinkedList.ListElement listElement = this.removeList.addLast(key);
        ValueElement ret = (ValueElement)this.map.put(key, new ValueElement(value, listElement));
        if (ret != null) {
            this.removeList.remove(ret.getListElement());
        } else {
            ++this.currentSize;
        }
        if (this.currentSize > this.maxSize) {
            DoublyLinkedList.ListElement toRemove = this.removeList.removeFirst();
            this.map.remove(toRemove.getKey());
            --this.currentSize;
        }
        if (ret == null) {
            return null;
        }
        return ret.getValue();
    }

    public boolean isFull() {
        return this.currentSize >= this.maxSize;
    }

    public Object removeLRUEntry() {
        if (this.isEmpty()) {
            return null;
        }
        DoublyLinkedList.ListElement toRemove = this.removeList.removeFirst();
        ValueElement removed = (ValueElement)this.map.remove(toRemove.getKey());
        --this.currentSize;
        return removed.getValue();
    }

    public void putAll(Map t) {
        Iterator iter = t.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            this.put(key, t.get(key));
        }
    }

    public Object clone() {
        HashMap clone = new HashMap(this.map.size() * 4 / 3 + 10, 0.75f);
        Set entrySet = this.map.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            clone.put(entry.getKey(), ((ValueElement)entry.getValue()).getValue());
        }
        return clone;
    }

    public Object remove(Object key) {
        ValueElement ret = (ValueElement)this.map.remove(key);
        if (ret != null) {
            --this.currentSize;
            this.removeList.remove(ret.getListElement());
            return ret.getValue();
        }
        return null;
    }

    public void clear() {
        this.map.clear();
        this.currentSize = 0;
        this.removeList.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedsizeForgetfulHashMap)) {
            return false;
        }
        FixedsizeForgetfulHashMap other = (FixedsizeForgetfulHashMap)o;
        return this.map.equals(other.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public Set keySet() {
        return new KeySet(this.map.keySet());
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public void repOk() {
        Iterator iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            Object k = iter.next();
            Assert.that(k != null, "Null key (1)");
            ValueElement ve = (ValueElement)this.map.get(k);
            Assert.that(ve != null, "Null value element (1)");
            Assert.that(ve.getValue() != null, "Null real value (1)");
            Assert.that(this.removeList.contains(ve.getListElement()), "Invariant 1a failed");
            Assert.that(ve.getListElement().getKey().equals(k), "Invariant 1b failed");
        }
        Iterator iter2 = this.removeList.iterator();
        while (iter2.hasNext()) {
            DoublyLinkedList.ListElement l = (DoublyLinkedList.ListElement)iter2.next();
            Object k = l.getKey();
            Assert.that(k != null, "Null key (2)");
            ValueElement ve = (ValueElement)this.map.get(k);
            Assert.that(ve != null, "Null value element (2)");
            Assert.that(ve.getListElement().equals(l), "Invariant 2b failed");
        }
    }

    class KeyIterator
    implements Iterator {
        Iterator real;
        Object lastYielded = null;

        KeyIterator(Iterator real) {
            this.real = real;
        }

        public Object next() {
            Object ret;
            this.lastYielded = ret = this.real.next();
            return ret;
        }

        public boolean hasNext() {
            return this.real.hasNext();
        }

        public void remove() {
            if (this.lastYielded == null) {
                return;
            }
            ValueElement ve = (ValueElement)FixedsizeForgetfulHashMap.this.map.get(this.lastYielded);
            if (ve != null) {
                FixedsizeForgetfulHashMap.this.currentSize--;
                FixedsizeForgetfulHashMap.this.removeList.remove(ve.getListElement());
            }
            this.real.remove();
        }
    }

    class KeySet
    extends AbstractSet {
        Set real;

        KeySet(Set real) {
            this.real = real;
        }

        public Iterator iterator() {
            return new KeyIterator(this.real.iterator());
        }

        public int size() {
            return FixedsizeForgetfulHashMap.this.size();
        }
    }

    private static class ValueElement {
        DoublyLinkedList.ListElement listElement;
        Object value;

        public ValueElement(Object value, DoublyLinkedList.ListElement listElement) {
            this.value = value;
            this.listElement = listElement;
        }

        public DoublyLinkedList.ListElement getListElement() {
            return this.listElement;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueElement)) {
                return false;
            }
            ValueElement other = (ValueElement)o;
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

