/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;

public class IOUtils {
    public static boolean handleException(IOException ioe, String friendly) {
        String msg = ioe.getMessage();
        if (msg == null) {
            return false;
        }
        if (friendly == null) {
            friendly = "GENERIC";
        }
        if (StringUtils.contains(msg = msg.toLowerCase(), "no space left") || StringUtils.contains(msg, "not enough space")) {
            MessageService.showError("ERROR_DISK_FULL_" + friendly);
            return true;
        }
        if (StringUtils.contains(msg, "being used by another process")) {
            MessageService.showError("ERROR_LOCKED_BY_PROCESS_" + friendly);
            return true;
        }
        if (StringUtils.contains(msg, "access is denied")) {
            MessageService.showError("ERROR_ACCESS_DENIED_" + friendly);
            return true;
        }
        return false;
    }

    public static String readWord(InputStream in, int maxSize) throws IOException {
        char[] buf = new char[maxSize];
        int i = 0;
        try {
            int got;
            while ((got = in.read()) >= 0) {
                if ((char)got != ' ') {
                    if (i < maxSize) {
                        buf[i++] = (char)got;
                        continue;
                    }
                    throw new IOException("could not read word");
                }
                return new String(buf, 0, i);
            }
            throw new IOException("unexpected end of file");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IOException("unexpected aioobe");
        }
    }
}

