/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.filters.IP;
import com.limegroup.gnutella.filters.IPList;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.sun.java.util.collections.Arrays;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class NetworkUtils {
    private static final IPList INVALID_ADDRESSES = new IPList();
    private static final IPList PRIVATE_ADDRESSES = new IPList();
    private static final IPList LOCAL_ADDRESSES = new IPList();

    private NetworkUtils() {
    }

    public static boolean isValidPort(int port) {
        if ((port & 0xFFFF0000) != 0) {
            return false;
        }
        return port != 0;
    }

    public static boolean isValidAddress(byte[] addr) {
        return !INVALID_ADDRESSES.contains(new IP(addr));
    }

    public static boolean isValidAddress(InetAddress addr) {
        return NetworkUtils.isValidAddress(addr.getAddress());
    }

    public static boolean isValidAddress(String host) {
        try {
            return NetworkUtils.isValidAddress(InetAddress.getByName(host));
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public static boolean isLocalAddress(InetAddress addr) {
        try {
            if (LOCAL_ADDRESSES.contains(new IP(addr.getAddress()))) {
                return true;
            }
            InetAddress address = InetAddress.getLocalHost();
            return Arrays.equals(address.getAddress(), addr.getAddress());
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isCloseIP(byte[] addr0, byte[] addr1) {
        return addr0[0] == addr1[0];
    }

    public static boolean isVeryCloseIP(byte[] addr0, byte[] addr1) {
        if (NetworkUtils.isPrivateAddress(addr0)) {
            return false;
        }
        return addr0[0] == addr1[0] && addr0[1] == addr1[1];
    }

    public static boolean isVeryCloseIP(byte[] addr) {
        return NetworkUtils.isVeryCloseIP(RouterService.getAddress(), addr);
    }

    public static boolean isPrivate() {
        return NetworkUtils.isPrivateAddress(RouterService.getAddress());
    }

    public static boolean isPrivateAddress(byte[] address) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return false;
        }
        return PRIVATE_ADDRESSES.contains(new IP(address));
    }

    public static boolean isPrivateAddress(InetAddress address) {
        return NetworkUtils.isPrivateAddress(address.getAddress());
    }

    public static boolean isPrivateAddress(String address) {
        try {
            return NetworkUtils.isPrivateAddress(InetAddress.getByName(address));
        }
        catch (UnknownHostException uhe) {
            return true;
        }
    }

    public static final String ip2string(byte[] ip) {
        return NetworkUtils.ip2string(ip, 0);
    }

    public static final String ip2string(byte[] ip, int offset) {
        StringBuffer sbuf = new StringBuffer(16);
        sbuf.append(ByteOrder.ubyte2int(ip[offset]));
        sbuf.append('.');
        sbuf.append(ByteOrder.ubyte2int(ip[offset + 1]));
        sbuf.append('.');
        sbuf.append(ByteOrder.ubyte2int(ip[offset + 2]));
        sbuf.append('.');
        sbuf.append(ByteOrder.ubyte2int(ip[offset + 3]));
        return sbuf.toString();
    }

    public static boolean isMe(String host, int port) {
        byte[] cIP;
        try {
            cIP = InetAddress.getByName(host).getAddress();
        }
        catch (IOException e) {
            return false;
        }
        return NetworkUtils.isMe(cIP, port);
    }

    public static boolean isMe(byte[] cIP, int port) {
        if (cIP[0] == 127) {
            return port == RouterService.getPort();
        }
        byte[] managerIP = RouterService.getAddress();
        return port == RouterService.getPort() && Arrays.equals(cIP, managerIP);
    }

    static {
        INVALID_ADDRESSES.add("0.*/8");
        INVALID_ADDRESSES.add("255.*/8");
        PRIVATE_ADDRESSES.add("0.*/8");
        PRIVATE_ADDRESSES.add("127.*/8");
        PRIVATE_ADDRESSES.add("255.*/8");
        PRIVATE_ADDRESSES.add("10.*/8");
        PRIVATE_ADDRESSES.add("172.16.*/12");
        PRIVATE_ADDRESSES.add("169.254.*/16");
        PRIVATE_ADDRESSES.add("192.168.*/16");
        LOCAL_ADDRESSES.add("127.*/8");
    }
}

