/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.mp3.ID3Reader;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.XMLStringUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLDocument
implements Serializable {
    public static final String XML_ID_ATTRIBUTE_STRING = "identifier";
    public static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    private static DOMParser parser = new DOMParser();
    private volatile transient int hashCode = 0;
    static final long serialVersionUID = 7396170507085078485L;
    private final Map fieldToValue = new TreeMap(Comparators.stringComparator());
    private String schemaUri;
    private String xmlString;
    private String identifier;
    private String action = "";
    private boolean supportsID3v2 = true;
    private transient List CACHED_KEYWORDS = null;

    public boolean supportsID3v2() {
        return this.supportsID3v2;
    }

    public void setIdentifier(String id) {
        this.identifier = id;
    }

    public void setSchemaURI(String uri) {
        this.schemaUri = uri;
    }

    public LimeXMLDocument(String XMLStr) throws SAXException, SchemaNotFoundException, IOException {
        if (XMLStr == null || XMLStr.equals("")) {
            throw new SAXException("null or empty string");
        }
        InputSource doc = new InputSource(new StringReader(XMLStr));
        this.initialize(doc);
        this.xmlString = LimeXMLDocument.ripIdentifier(XMLStr.trim());
        if (this.xmlString.equals("")) {
            throw new SAXException("empty after identifier ripped");
        }
    }

    public LimeXMLDocument(Node node, Node rootElement) throws SchemaNotFoundException, IOException {
        this.grabDocInfo(rootElement, true);
        this.grabDocInfo(node, false);
        this.createMap(node, rootElement.getNodeName());
        if (this.fieldToValue.isEmpty()) {
            throw new IOException("no elements.");
        }
        if (this.getXMLString().equals("")) {
            throw new IOException("invalid elements.");
        }
    }

    public LimeXMLDocument(Collection nameValueList, String schemaURI) {
        this.schemaUri = schemaURI;
        if (nameValueList.isEmpty()) {
            throw new IllegalArgumentException("empty list");
        }
        Iterator i = nameValueList.iterator();
        while (i.hasNext()) {
            Object value;
            String name;
            Object next = i.next();
            if (next instanceof NameValue) {
                name = ((NameValue)next).getName();
                value = ((NameValue)next).getValue();
            } else if (next instanceof Map.Entry) {
                name = (String)((Map.Entry)next).getKey();
                value = ((Map.Entry)next).getValue();
            } else {
                throw new IllegalArgumentException("Invalid Collection");
            }
            this.fieldToValue.put(name.trim(), value);
        }
        try {
            if (this.getXMLString().equals("")) {
                throw new IllegalArgumentException("invalid collection data.");
            }
        }
        catch (SchemaNotFoundException snfe) {
            throw new IllegalArgumentException(snfe.getMessage());
        }
    }

    boolean isValid() {
        try {
            return !this.getXMLString().equals("") && !this.fieldToValue.isEmpty();
        }
        catch (SchemaNotFoundException snfe) {
            return false;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.xmlString != null) {
            this.xmlString = this.xmlString.trim();
        }
    }

    private static String ripIdentifier(String xmlWithID) {
        String retString = xmlWithID;
        int indexOfID = xmlWithID.indexOf(XML_ID_ATTRIBUTE_STRING);
        if (indexOfID > -1) {
            String quote = "\"";
            int indexOfEndQuote = xmlWithID.indexOf("\"", indexOfID + 1);
            indexOfEndQuote = xmlWithID.indexOf("\"", indexOfEndQuote + 1);
            String begin = xmlWithID.substring(0, indexOfID);
            String end = xmlWithID.substring(indexOfEndQuote + 1);
            retString = begin + end;
        }
        if (retString.indexOf(XML_HEADER) < 0) {
            retString = XML_HEADER + retString;
        }
        return retString;
    }

    private void initialize(InputSource doc) throws SchemaNotFoundException, IOException, SAXException {
        Document document = null;
        DOMParser dOMParser = parser;
        synchronized (dOMParser) {
            parser.parse(doc);
            document = parser.getDocument();
        }
        Element docElement = document.getDocumentElement();
        this.grabDocInfo(docElement, true);
        Node child = docElement.getFirstChild();
        this.grabDocInfo(child, false);
        this.createMap(docElement);
    }

    private void grabDocInfo(Node docElement, boolean root) throws SchemaNotFoundException, IOException {
        if (docElement == null) {
            throw new IOException("null doc element");
        }
        NamedNodeMap nnm = docElement.getAttributes();
        if (nnm == null) {
            throw new IOException("invalid doc element -- null namednodemap");
        }
        List attributes = LimeXMLUtils.getAttributes(nnm);
        int size = attributes.size();
        int i = 0;
        while (i < size) {
            Element e;
            Node att = (Node)attributes.get(i);
            String attName = att.getNodeName();
            String lowerAttName = attName.toLowerCase(Locale.US);
            if (lowerAttName.indexOf("schemalocation") >= 0) {
                this.schemaUri = att.getNodeValue();
            } else if (lowerAttName.indexOf(XML_ID_ATTRIBUTE_STRING) >= 0) {
                this.identifier = att.getNodeValue();
                e = (Element)docElement;
                e.removeAttribute(attName);
            } else if (lowerAttName.indexOf("action") >= 0) {
                this.action = att.getNodeValue();
            } else if (lowerAttName.indexOf("index") >= 0) {
                e = (Element)docElement;
                e.removeAttribute(attName);
            } else if (root) {
                String canonicalizedAttName = docElement.getNodeName() + "__" + att.getNodeName() + "__";
                this.fieldToValue.put(canonicalizedAttName.trim(), att.getNodeValue().trim());
            }
            ++i;
        }
        if (this.schemaUri == null) {
            throw new SchemaNotFoundException();
        }
    }

    public int getNumFields() {
        return this.fieldToValue.size();
    }

    public List getKeyWords() {
        if (this.CACHED_KEYWORDS != null) {
            return this.CACHED_KEYWORDS;
        }
        ArrayList retList = new ArrayList();
        Iterator iter = this.fieldToValue.values().iterator();
        while (iter.hasNext()) {
            boolean number = true;
            String val = (String)iter.next();
            try {
                new Double(val);
            }
            catch (NumberFormatException e) {
                number = false;
            }
            if (number || val == null || val.equals("")) continue;
            retList.add(val);
        }
        this.CACHED_KEYWORDS = retList;
        return retList;
    }

    private void createMap(Node docElement) {
        this.doAllChildren(docElement, "");
    }

    private void createMap(Node docElement, String parent) {
        this.doAllChildren(docElement, parent);
    }

    private void doAllChildren(Node currNode, String parentName) {
        if (!currNode.hasChildNodes()) {
            this.doEntry(currNode, parentName);
            return;
        }
        String currString = this.doEntry(currNode, parentName);
        List children = LimeXMLUtils.getElements(currNode.getChildNodes());
        int size = children.size();
        int i = 0;
        while (i < size) {
            Node child = (Node)children.get(i);
            this.doAllChildren(child, currString);
            ++i;
        }
    }

    private String doEntry(Node currNode, String parentName) {
        String currTag = !parentName.equals("") ? parentName + "__" + currNode.getNodeName() : currNode.getNodeName();
        Element currElement = (Element)currNode;
        String nodeValue = LimeXMLUtils.getText(currElement.getChildNodes());
        if (nodeValue != null && !nodeValue.equals("")) {
            this.fieldToValue.put(currTag.trim(), nodeValue.trim());
        }
        if (!parentName.equals("")) {
            List attribs = LimeXMLUtils.getAttributes(currNode.getAttributes());
            int size = attribs.size();
            int i = 0;
            while (i < size) {
                Node att = (Node)attribs.get(i);
                String attName = att.getNodeName();
                String attString = currTag + "__" + attName + "__";
                String attValue = att.getNodeValue();
                this.fieldToValue.put(attString.trim(), attValue.trim());
                ++i;
            }
        }
        return currTag;
    }

    public String getSchemaURI() {
        return this.schemaUri;
    }

    public LimeXMLSchema getSchema() {
        return LimeXMLSchemaRepository.instance().getSchema(this.schemaUri);
    }

    public String getSchemaDescription() {
        LimeXMLSchema schema = this.getSchema();
        if (schema != null) {
            return schema.getDescription();
        }
        return LimeXMLSchema.getDisplayString(this.schemaUri);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getAction() {
        return this.action;
    }

    public Set getNameValueSet() {
        return this.fieldToValue.entrySet();
    }

    public Set getNameSet() {
        return this.fieldToValue.keySet();
    }

    public Collection getValueList() {
        return this.fieldToValue.values();
    }

    public List getOrderedNameValueList() throws SchemaNotFoundException {
        LinkedList retList = new LinkedList();
        if (this.schemaUri == null) {
            throw new SchemaNotFoundException("no schema given.");
        }
        LimeXMLSchema schema = LimeXMLSchemaRepository.instance().getSchema(this.schemaUri);
        if (schema == null) {
            throw new SchemaNotFoundException("invalid schema: " + this.schemaUri);
        }
        String[] fNames = schema.getCanonicalizedFieldNames();
        int i = 0;
        while (i < fNames.length) {
            Object retObj = this.fieldToValue.get(fNames[i].trim());
            if (retObj != null) {
                retList.add(new NameValue(fNames[i].trim(), retObj));
            }
            ++i;
        }
        return retList;
    }

    public String getValueFast(String field) {
        return (String)this.fieldToValue.get(field);
    }

    public String getValue(String fieldName) {
        String retValue = null;
        fieldName = fieldName.trim();
        retValue = (String)this.fieldToValue.get(fieldName);
        if (fieldName.equals("audios__audio__genre__") && retValue != null) {
            try {
                short index = Short.parseShort(retValue);
                retValue = ID3Reader.getGenreString(index);
                this.fieldToValue.put(fieldName, retValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retValue;
    }

    public String getXMLString() throws SchemaNotFoundException {
        if (this.xmlString == null || this.xmlString.equals("")) {
            this.xmlString = LimeXMLDocument.constructXML(this.getOrderedNameValueList(), this.schemaUri);
            this.xmlString = this.xmlString.trim();
        }
        return this.xmlString;
    }

    public String getXMLStringWithIdentifier() throws SchemaNotFoundException {
        String ret = this.getXMLString();
        int index = ret.indexOf(">");
        if (index < 0) {
            return ret;
        }
        ++index;
        index = ret.indexOf(">", index);
        ++index;
        index = ret.indexOf(">", index);
        String first = ret.substring(0, index);
        String last = ret.substring(index);
        String middle = " identifier=\"" + this.identifier + "\"";
        ret = first + middle + last;
        return ret;
    }

    public static String constructXML(List namValList, String uri) {
        if (namValList.size() == 0) {
            return "";
        }
        uri = LimeXMLUtils.encodeXML(uri);
        int size = namValList.size();
        StringBuffer first = new StringBuffer();
        StringBuffer last = new StringBuffer();
        String prevString = "";
        ArrayList tagsToClose = new ArrayList();
        boolean prevAtt = false;
        NameValue nv = (NameValue)namValList.get(0);
        String n = nv.getName();
        boolean end = n.endsWith("__");
        StringTokenizer tok = new StringTokenizer(n, "__");
        int c = tok.countTokens();
        boolean rootAtts = end && c == 2;
        int i = 0;
        Iterator iter = namValList.iterator();
        while (iter.hasNext()) {
            NameValue namevalue = (NameValue)iter.next();
            String currString = namevalue.getName();
            String value = LimeXMLUtils.encodeXML((String)namevalue.getValue());
            List currFields = XMLStringUtils.split(currString);
            int commonCount = 0;
            List prevFields = null;
            boolean attribute = false;
            if (currString.endsWith("__")) {
                attribute = true;
            }
            if (prevAtt && !attribute) {
                first.append(">");
            }
            if (i > 0) {
                prevFields = XMLStringUtils.split(prevString);
                commonCount = LimeXMLDocument.getCommonCount(currFields, prevFields);
            }
            int z = currFields.size();
            int numPending = tagsToClose.size();
            if (commonCount < numPending) {
                int closeCount = numPending - commonCount;
                int currClose = numPending - 1;
                int k = 0;
                while (k < closeCount) {
                    String closeStr = (String)tagsToClose.remove(currClose);
                    --currClose;
                    last.append("</" + closeStr + ">");
                    ++k;
                }
            }
            if (last.length() != 0) {
                first.append((Object)last);
                last.setLength(0);
            }
            int j = commonCount;
            while (j < z - 1) {
                String str = (String)currFields.get(j);
                first.append("<" + str);
                if (i == 0 && j == 0) {
                    first.append(" xsi:noNamespaceSchemaLocation=\"" + uri + "\"");
                    if (!rootAtts) {
                        first.append(">");
                    }
                } else if (!attribute) {
                    first.append(">");
                }
                tagsToClose.add(str);
                ++j;
            }
            String curr = (String)currFields.get(z - 1);
            if (!attribute) {
                first.append("<" + curr + ">" + value + "</" + curr + ">");
            } else {
                first.append(" " + curr + "=\"" + value + "\"");
                if (i == size - 1) {
                    first.append(">");
                }
            }
            prevString = currString;
            prevAtt = attribute;
            ++i;
        }
        int stillPending = tagsToClose.size();
        int l = stillPending - 1;
        while (l >= 0) {
            String tag = (String)tagsToClose.remove(l);
            first.append("</" + tag + ">");
            --l;
        }
        first.insert(0, XML_HEADER);
        return first.toString();
    }

    private static int getCommonCount(List currFields, List prevFields) {
        int retValue = 0;
        int smaller = currFields.size() < prevFields.size() ? currFields.size() : prevFields.size();
        int i = 0;
        while (i < smaller) {
            if (!currFields.get(i).equals(prevFields.get(i))) break;
            ++retValue;
            ++i;
        }
        return retValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof LimeXMLDocument)) {
            return false;
        }
        LimeXMLDocument xmlDoc = (LimeXMLDocument)o;
        if (this.schemaUri == null) {
            if (xmlDoc.schemaUri != null) return false;
            bl3 = true;
        } else {
            bl3 = this.schemaUri.equals(xmlDoc.schemaUri);
        }
        if (!bl3) return false;
        if (this.identifier == null) {
            if (xmlDoc.identifier != null) return false;
            bl2 = true;
        } else {
            bl2 = this.identifier.equals(xmlDoc.identifier);
        }
        if (!bl2) return false;
        if (this.action == null) {
            if (xmlDoc.action != null) return false;
            bl = true;
        } else {
            bl = this.action.equals(xmlDoc.action);
        }
        if (!bl) return false;
        if (this.fieldToValue == null) {
            if (xmlDoc.fieldToValue != null) return false;
            return true;
        }
        boolean bl4 = this.fieldToValue.equals(xmlDoc.fieldToValue);
        if (!bl4) return false;
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (this.fieldToValue != null) {
                result = 37 * result + this.fieldToValue.hashCode();
            }
            if (this.schemaUri != null) {
                result = 37 * result + this.schemaUri.hashCode();
            }
            if (this.identifier != null) {
                result = 37 * result + this.identifier.hashCode();
            }
            if (this.action != null) {
                result = 37 * result + this.action.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        try {
            return this.getXMLString();
        }
        catch (SchemaNotFoundException snfe) {
            return "no schema.";
        }
    }
}

