/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.mp3.ID3Editor;
import com.limegroup.gnutella.mp3.ID3Reader;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.Trie;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class LimeXMLReplyCollection {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$xml$LimeXMLReplyCollection == null ? (class$com$limegroup$gnutella$xml$LimeXMLReplyCollection = LimeXMLReplyCollection.class$("com.limegroup.gnutella.xml.LimeXMLReplyCollection")) : class$com$limegroup$gnutella$xml$LimeXMLReplyCollection);
    private final String schemaURI;
    private final HashMap mainMap;
    private final Map trieMap;
    private final boolean audio;
    private File dataFile = null;
    private final Object WRITE_LOCK = new Object();
    public static final int NORMAL = 0;
    public static final int FILE_DEFECTIVE = 1;
    public static final int RW_ERROR = 2;
    public static final int BAD_ID3 = 3;
    public static final int FAILED_TITLE = 4;
    public static final int FAILED_ARTIST = 5;
    public static final int FAILED_ALBUM = 6;
    public static final int FAILED_YEAR = 7;
    public static final int FAILED_COMMENT = 8;
    public static final int FAILED_TRACK = 9;
    public static final int FAILED_GENRE = 10;
    public static final int HASH_FAILED = 11;
    public static final int INCORRECT_FILETYPE = 12;
    static /* synthetic */ Class class$com$limegroup$gnutella$xml$LimeXMLReplyCollection;

    public LimeXMLReplyCollection(FileDesc[] fds, String URI2, boolean audio) {
        this.schemaURI = URI2;
        this.audio = audio;
        if (LOG.isTraceEnabled()) {
            LOG.trace("LimeXMLReplyCollection(): entered with audio = " + audio);
        }
        this.mainMap = new HashMap();
        this.trieMap = new HashMap();
        MapSerializer ms = this.initializeMapSerializer(URI2);
        Map hashToXML = ms == null ? new HashMap() : ms.getMap();
        boolean requiresConversion = false;
        Iterator iter = hashToXML.keySet().iterator();
        if (iter.hasNext()) {
            requiresConversion = iter.next() instanceof String;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("requiresConversion: " + requiresConversion);
        }
        int i = 0;
        while (i < fds.length) {
            block16: {
                FileDesc fd = fds[i];
                if (!(fd instanceof IncompleteFileDesc)) {
                    File file = fd.getFile();
                    URN hash = fd.getSHA1Urn();
                    Object xml = null;
                    LimeXMLDocument doc = null;
                    if (requiresConversion) {
                        String miniHash = null;
                        try {
                            miniHash = new String(LimeXMLUtils.hashFile(file));
                        }
                        catch (IOException e) {
                            break block16;
                        }
                        xml = hashToXML.get(miniHash);
                        doc = xml != null && xml instanceof LimeXMLDocument ? (LimeXMLDocument)xml : this.constructDocument((String)xml, file);
                    } else {
                        xml = hashToXML.get(hash);
                        doc = xml == null ? this.constructDocument(null, file) : (LimeXMLDocument)xml;
                    }
                    if (doc != null) {
                        if (!doc.supportsID3v2() && LimeXMLUtils.isMP3File(file)) {
                            LimeXMLDocument tempDoc;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("reconstructing document for id3v2: " + file);
                            }
                            if ((tempDoc = this.constructDocument(null, file)) != null) {
                                doc = tempDoc;
                            }
                        }
                        if (doc.isValid() || (doc = this.constructDocument(null, file)) != null && doc.isValid()) {
                            if (ID3Reader.isCorrupted(doc)) {
                                doc = ID3Reader.fixCorruption(doc);
                                this.addReplyWithCommit(file, fd, doc, false);
                            } else {
                                this.addReply(fd, doc);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        LOG.trace("LimeXMLReplyCollection(): returning.");
        this.write();
    }

    private LimeXMLDocument constructDocument(String xmlStr, File file) {
        if (this.audio && LimeXMLUtils.isMP3File(file)) {
            boolean onlyID3 = xmlStr == null || xmlStr.equals("");
            try {
                String id3XML;
                String joinedXML;
                if (!onlyID3 && (joinedXML = this.joinAudioXMLStrings(id3XML = ID3Reader.readDocument(file, onlyID3), xmlStr)) != null) {
                    return new LimeXMLDocument(joinedXML);
                }
                return ID3Reader.readDocument(file);
            }
            catch (SAXException ignored) {
            }
            catch (IOException ignored) {
            }
            catch (SchemaNotFoundException ignored) {}
        } else {
            try {
                if (xmlStr != null && !xmlStr.equals("")) {
                    return new LimeXMLDocument(xmlStr);
                }
            }
            catch (SAXException ignored) {
            }
            catch (IOException ignored) {
            }
            catch (SchemaNotFoundException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    protected List getKeyWords() {
        ArrayList retList = new ArrayList();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator docs = this.mainMap.values().iterator();
            while (docs.hasNext()) {
                LimeXMLDocument d = (LimeXMLDocument)docs.next();
                retList.addAll(d.getKeyWords());
            }
        }
        return retList;
    }

    private MapSerializer initializeMapSerializer(String URI2) {
        String fname = LimeXMLSchema.getDisplayString(URI2) + ".sxml";
        LimeXMLProperties props = LimeXMLProperties.instance();
        String path = props.getXMLDocsDir();
        this.dataFile = new File(path, fname);
        if (this.dataFile.isDirectory()) {
            return null;
        }
        try {
            return new MapSerializer(this.dataFile);
        }
        catch (IOException e) {
            LOG.debug("exception initializing", e);
            return null;
        }
    }

    private String joinAudioXMLStrings(String mp3Str, String fileStr) {
        int p = fileStr.lastIndexOf("></audio>");
        if (p == -1) {
            return null;
        }
        String a = fileStr.substring(0, p);
        String b = fileStr.substring(p);
        return a + mp3Str + b;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    private void addKeywords(LimeXMLDocument doc) {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator i = doc.getNameValueSet().iterator();
            while (i.hasNext()) {
                List allDocs;
                Map.Entry entry = (Map.Entry)i.next();
                String name = (String)entry.getKey();
                String value = I18NConvert.instance().getNorm((String)entry.getValue());
                Trie trie = (Trie)this.trieMap.get(name);
                if (trie == null) {
                    trie = new Trie(true);
                    this.trieMap.put(name, trie);
                }
                if ((allDocs = (List)trie.get(value)) == null) {
                    allDocs = new LinkedList();
                    trie.add(value, allDocs);
                }
                allDocs.add(doc);
            }
        }
    }

    private void removeKeywords(LimeXMLDocument doc) {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator i = doc.getNameValueSet().iterator();
            while (i.hasNext()) {
                String value;
                List allDocs;
                Map.Entry entry = (Map.Entry)i.next();
                String name = (String)entry.getKey();
                Trie trie = (Trie)this.trieMap.get(name);
                if (trie == null || (allDocs = (List)trie.get(value = I18NConvert.instance().getNorm((String)entry.getValue()))) == null) continue;
                allDocs.remove(doc);
                if (allDocs.size() != 0) continue;
                trie.remove(value);
            }
        }
    }

    public void addReply(FileDesc fd, LimeXMLDocument replyDoc) {
        URN hash = fd.getSHA1Urn();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            this.mainMap.put(hash, replyDoc);
            this.addKeywords(replyDoc);
        }
        fd.addLimeXMLDocument(replyDoc);
        try {
            String identifier = fd.getFile().getCanonicalPath();
            replyDoc.setIdentifier(identifier);
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    void addReplyWithCommit(File f, FileDesc fd, LimeXMLDocument replyDoc, boolean checkBetter) {
        this.addReply(fd, replyDoc);
        if (this.audio) {
            try {
                this.mp3ToDisk(fd, f.getCanonicalPath(), replyDoc, checkBetter);
            }
            catch (IOException ignored) {}
        } else {
            this.write();
        }
    }

    public int getCount() {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            int n = this.mainMap.size();
            return n;
        }
    }

    public boolean isAudio() {
        return this.audio;
    }

    public LimeXMLDocument getDocForHash(URN hash) {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            LimeXMLDocument limeXMLDocument = (LimeXMLDocument)this.mainMap.get(hash);
            return limeXMLDocument;
        }
    }

    public List getMatchingReplies(LimeXMLDocument query) {
        Set matching = null;
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator i = query.getNameValueSet().iterator();
            while (i.hasNext()) {
                String value;
                Iterator iter;
                Map.Entry entry = (Map.Entry)i.next();
                String name = (String)entry.getKey();
                Trie trie = (Trie)this.trieMap.get(name);
                if (trie == null || !(iter = trie.getPrefixedBy(value = (String)entry.getValue())).hasNext()) continue;
                if (matching == null) {
                    matching = new HashSet();
                }
                while (iter.hasNext()) {
                    List matchesVal = (List)iter.next();
                    matching.addAll(matchesVal);
                }
            }
        }
        if (matching == null || matching.size() == 0) {
            return DataUtils.EMPTY_LIST;
        }
        List actualMatches = null;
        Iterator i = matching.iterator();
        while (i.hasNext()) {
            LimeXMLDocument currReplyDoc = (LimeXMLDocument)i.next();
            if (!LimeXMLUtils.match(currReplyDoc, query)) continue;
            if (actualMatches == null) {
                actualMatches = new LinkedList();
            }
            actualMatches.add(currReplyDoc);
        }
        if (actualMatches == null || actualMatches.size() == 0) {
            return DataUtils.EMPTY_LIST;
        }
        return actualMatches;
    }

    public LimeXMLDocument replaceDoc(FileDesc fd, LimeXMLDocument newDoc) {
        LimeXMLDocument oldDoc = null;
        URN hash = fd.getSHA1Urn();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            oldDoc = (LimeXMLDocument)this.mainMap.put(hash, newDoc);
            if (oldDoc == null) {
                Assert.that(false, "attempted to replace doc that did not exist!!");
            }
            this.removeKeywords(oldDoc);
            this.addKeywords(newDoc);
        }
        fd.replaceLimeXMLDocument(oldDoc, newDoc);
        return oldDoc;
    }

    public boolean removeDoc(FileDesc fd) {
        boolean found;
        LimeXMLDocument val;
        URN hash = fd.getSHA1Urn();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            val = (LimeXMLDocument)this.mainMap.remove(hash);
            found = val != null;
        }
        boolean written = false;
        if (found) {
            written = this.write();
            if (written) {
                fd.removeLimeXMLDocument(val);
                this.removeKeywords(val);
            } else {
                HashMap hashMap2 = this.mainMap;
                synchronized (hashMap2) {
                    this.mainMap.put(hash, val);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("found: " + found + ", written: " + written);
        }
        return found && written;
    }

    public boolean write() {
        if (this.dataFile == null) {
            String fname = LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml";
            LimeXMLProperties props = LimeXMLProperties.instance();
            String path = props.getXMLDocsDir();
            this.dataFile = new File(path, fname);
        }
        if (this.dataFile.isDirectory()) {
            return false;
        }
        try {
            MapSerializer ms = new MapSerializer(this.dataFile, this.mainMap);
            Object object = this.WRITE_LOCK;
            synchronized (object) {
                ms.commit();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public int mp3ToDisk(FileDesc fd, String mp3FileName, LimeXMLDocument doc, boolean checkBetter) {
        ID3Editor commitWith;
        boolean wrote = false;
        int mp3WriteState = -1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing: " + mp3FileName + " to disk.");
        }
        if ((commitWith = this.ripMP3XML(mp3FileName, doc, checkBetter)) != null) {
            if (commitWith.getCorrectDocument() == null) {
                mp3WriteState = this.commitID3Data(mp3FileName, commitWith);
            } else {
                this.removeDoc(fd);
                this.addReply(fd, commitWith.getCorrectDocument());
                mp3WriteState = 0;
            }
        }
        Assert.that(mp3WriteState != 12, "trying to write id3 to non mp3 file");
        wrote = this.write();
        if (!wrote) {
            return 2;
        }
        return mp3WriteState;
    }

    private ID3Editor ripMP3XML(String mp3File, LimeXMLDocument doc, boolean checkBetter) {
        if (!LimeXMLUtils.isMP3File(mp3File)) {
            return null;
        }
        ID3Editor newValues = new ID3Editor();
        String newXML = null;
        try {
            newXML = doc.getXMLStringWithIdentifier();
        }
        catch (SchemaNotFoundException snfe) {
            return null;
        }
        newValues.removeID3Tags(newXML);
        ID3Editor existing = new ID3Editor();
        LimeXMLDocument existingDoc = null;
        try {
            existingDoc = ID3Reader.readDocument(new File(mp3File));
        }
        catch (IOException e) {
            return null;
        }
        String existingXML = null;
        try {
            existingXML = existingDoc.getXMLStringWithIdentifier();
        }
        catch (SchemaNotFoundException snfe) {
            return null;
        }
        existing.removeID3Tags(existingXML);
        if (!checkBetter) {
            if (newValues.equals(existing)) {
                return null;
            }
            return newValues;
        }
        if (newValues.equals(existing)) {
            LOG.debug("tag read from disk is same as XML doc.");
            return null;
        }
        if (existing.betterThan(newValues)) {
            existing.setCorrectDocument(existingDoc);
            return existing;
        }
        newValues.pickBetterFields(existing);
        return newValues;
    }

    private int commitID3Data(String mp3FileName, ID3Editor editor) {
        int retVal = editor.writeID3DataToDisk(mp3FileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("wrote data: " + retVal);
        }
        if (retVal == 1 || retVal == 2 || retVal == 3 || retVal == 12) {
            return retVal;
        }
        RouterService.getFileManager().fileChanged(new File(mp3FileName));
        return retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class MapSerializer {
        private File _backingStoreFile;
        private Map _hashMap;

        MapSerializer(File whereToStore) throws IOException {
            this._backingStoreFile = whereToStore;
            if (this._backingStoreFile.exists()) {
                this.deserializeFromFile();
            } else {
                this._hashMap = new HashMap();
            }
        }

        MapSerializer(File whereToStore, Map storage) {
            this._backingStoreFile = whereToStore;
            this._hashMap = storage;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void deserializeFromFile() throws IOException {
            FileInputStream istream = null;
            ObjectInputStream objStream = null;
            try {
                try {
                    istream = new FileInputStream(this._backingStoreFile);
                    objStream = new ObjectInputStream(istream);
                    this._hashMap = (Map)objStream.readObject();
                    if (LOG.isDebugEnabled()) {
                        Iterator it = this._hashMap.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry ent = (Map.Entry)it.next();
                            LOG.debug("read " + ent.getKey() + ", " + ent.getValue());
                        }
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IOException("class not found");
                }
                catch (ClassCastException cce) {
                    throw new IOException("class cast");
                }
                Object var6_7 = null;
                if (istream == null) return;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (istream == null) throw throwable;
                try {
                    istream.close();
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignored) {}
            istream.close();
            return;
        }

        public void commit() throws IOException {
            this.serializeToFile();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void serializeToFile() throws IOException {
            FileOutputStream ostream = null;
            ObjectOutputStream objStream = null;
            try {
                ostream = new FileOutputStream(this._backingStoreFile);
                objStream = new ObjectOutputStream(ostream);
                Map map = this._hashMap;
                synchronized (map) {
                    objStream.writeObject(this._hashMap);
                }
                Object var6_5 = null;
                if (ostream == null) return;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (ostream == null) throw throwable;
                try {
                    ostream.close();
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ostream.close();
                return;
            }
            catch (IOException ignored) {}
        }

        public Map getMap() {
            return this._hashMap;
        }
    }
}

