/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class LimeXMLSchemaFieldExtractor {
    private Map _nameSchemaFieldInfoListMap = new HashMap();
    private static final String DUMMY = "DUMMY";
    private static final String DUMMY_SIMPLETYPE = "DUMMY_SIMPLETYPE";
    private static final Set PRIMITIVE_TYPES = new HashSet();
    private int _uniqueCount = 1;
    private String _lastUniqueComplexTypeName = "";
    private SchemaFieldInfo _lastFieldInfoObject = null;
    private Set _referencedNames = new HashSet();

    LimeXMLSchemaFieldExtractor() {
    }

    public List getFields(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element root = document.getDocumentElement();
        this.traverse(root);
        String rootElementName = this.getRootElementName();
        LinkedList fieldNames = new LinkedList();
        this.fillWithFieldNames(fieldNames, (SchemaFieldInfoList)this._nameSchemaFieldInfoListMap.get(rootElementName), rootElementName);
        return fieldNames;
    }

    private void fillWithFieldNames(List fieldNames, SchemaFieldInfoList fieldInfoList, String prefix) {
        Iterator iterator = fieldInfoList.iterator();
        while (iterator.hasNext()) {
            SchemaFieldInfoPair fieldInfoPair = (SchemaFieldInfoPair)iterator.next();
            SchemaFieldInfoList newSchemaFieldInfoList = (SchemaFieldInfoList)this._nameSchemaFieldInfoListMap.get(fieldInfoPair.getSchemaFieldInfo().getType());
            String field = fieldInfoPair.getField();
            SchemaFieldInfo fieldInfo = fieldInfoPair.getSchemaFieldInfo();
            if (newSchemaFieldInfoList == null) {
                if (!this.isDummy(field)) {
                    fieldInfo.setCanonicalizedFieldName(prefix + "__" + field);
                } else {
                    fieldInfo.setCanonicalizedFieldName(prefix);
                }
                fieldNames.add(fieldInfo);
                continue;
            }
            if (!this.isDummy(field)) {
                this.fillWithFieldNames(fieldNames, newSchemaFieldInfoList, prefix + "__" + field);
                continue;
            }
            this.fillWithFieldNames(fieldNames, newSchemaFieldInfoList, prefix);
        }
    }

    private boolean isDummy(String field) {
        return field.trim().equals(DUMMY);
    }

    private String getRootElementName() {
        Set possibleRoots = ((HashMap)((HashMap)this._nameSchemaFieldInfoListMap).clone()).keySet();
        Iterator iterator = this._referencedNames.iterator();
        while (iterator.hasNext()) {
            possibleRoots.remove(iterator.next());
        }
        Iterator possibleRootsIterator = possibleRoots.iterator();
        return (String)possibleRootsIterator.next();
    }

    private void traverse(Node n) {
        String name = n.getNodeName();
        if (LimeXMLSchemaFieldExtractor.isElementTag(name)) {
            this.processElementTag(n);
            NodeList children = n.getChildNodes();
            int numChildren = children.getLength();
            int i = 0;
            while (i < numChildren) {
                Node child = children.item(i);
                this.traverse(child);
                ++i;
            }
        } else if (this.isComplexTypeTag(name)) {
            this.processComplexTypeTag(n);
        } else if (this.isSimpleTypeTag(name)) {
            LimeXMLSchemaFieldExtractor.processSimpleTypeForEnumeration(n, this._lastFieldInfoObject);
        } else {
            this.traverseChildren(n);
        }
    }

    private void processComplexTypeTag(Node n) {
        String name = this._lastUniqueComplexTypeName;
        NamedNodeMap attributes = n.getAttributes();
        Node nameAttribute = attributes.getNamedItem("name");
        if (nameAttribute != null) {
            name = nameAttribute.getNodeValue();
        }
        SchemaFieldInfoList fieldInfoList = new SchemaFieldInfoList();
        NodeList children = n.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node child = children.item(i);
            this.processChildOfComplexType(child, fieldInfoList);
            ++i;
        }
        this._nameSchemaFieldInfoListMap.put(name, fieldInfoList);
        this._referencedNames.add(name);
    }

    private void processChildOfComplexType(Node n, SchemaFieldInfoList fieldInfoList) {
        String nodeName = n.getNodeName();
        if (LimeXMLSchemaFieldExtractor.isElementTag(nodeName)) {
            this.processChildElementTag(n, fieldInfoList);
        } else if (this.isAttributeTag(nodeName)) {
            this.processChildAttributeTag(n, fieldInfoList);
        } else {
            NodeList children = n.getChildNodes();
            int numChildren = children.getLength();
            int i = 0;
            while (i < numChildren) {
                Node child = children.item(i);
                this.processChildOfComplexType(child, fieldInfoList);
                ++i;
            }
        }
    }

    private void processChildElementTag(Node n, SchemaFieldInfoList fieldInfoList) {
        NamedNodeMap attributes = n.getAttributes();
        SchemaFieldInfo schemaFieldInfo = null;
        Node nameAttribute = attributes.getNamedItem("name");
        if (nameAttribute == null) {
            Node refAttribute = attributes.getNamedItem("ref");
            if (refAttribute == null) {
                return;
            }
            String refName = refAttribute.getNodeValue();
            schemaFieldInfo = new SchemaFieldInfo(refName);
            fieldInfoList.add(new SchemaFieldInfoPair(refName, schemaFieldInfo));
            this._referencedNames.add(refName);
        } else {
            String typeName;
            String name = nameAttribute.getNodeValue();
            Node typeAttribute = attributes.getNamedItem("type");
            if (typeAttribute != null) {
                typeName = typeAttribute.getNodeValue();
            } else {
                this._lastUniqueComplexTypeName = typeName = this.getUniqueComplexTypeName();
            }
            schemaFieldInfo = new SchemaFieldInfo(this.removeNameSpace(typeName));
            fieldInfoList.add(new SchemaFieldInfoPair(name, schemaFieldInfo));
            this._lastFieldInfoObject = schemaFieldInfo;
            this.traverseChildren(n);
        }
    }

    private String removeNameSpace(String typeName) {
        if (typeName.indexOf(58) == -1) {
            return typeName;
        }
        return typeName.substring(typeName.indexOf(58) + 1);
    }

    private void processChildAttributeTag(Node n, SchemaFieldInfoList fieldInfoList) {
        NamedNodeMap attributes = n.getAttributes();
        Node nameAttribute = attributes.getNamedItem("name");
        if (nameAttribute == null) {
            return;
        }
        String name = nameAttribute.getNodeValue() + "__";
        Node typeAttribute = attributes.getNamedItem("type");
        String typeName = typeAttribute == null ? DUMMY_SIMPLETYPE : typeAttribute.getNodeValue();
        SchemaFieldInfo fieldInfo = new SchemaFieldInfo(this.removeNameSpace(typeName));
        LimeXMLSchemaFieldExtractor.processSimpleTypeForEnumeration(n, fieldInfo);
        this.addAttributeSchemaFieldInfoPair(new SchemaFieldInfoPair(name, fieldInfo), fieldInfoList);
    }

    private void addAttributeSchemaFieldInfoPair(SchemaFieldInfoPair schemaFieldInfoPair, SchemaFieldInfoList fieldInfoList) {
        int attributeCount = 0;
        Iterator iterator = fieldInfoList.iterator();
        while (iterator.hasNext()) {
            SchemaFieldInfoPair nextElement = (SchemaFieldInfoPair)iterator.next();
            if (!this.isAttribute(nextElement.getField())) break;
            ++attributeCount;
        }
        fieldInfoList.add(attributeCount, schemaFieldInfoPair);
    }

    private static void processSimpleTypeForEnumeration(Node n, SchemaFieldInfo fieldInfo) {
        NodeList children = n.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (!LimeXMLSchemaFieldExtractor.isEnumerationTag(nodeName)) {
                LimeXMLSchemaFieldExtractor.processSimpleTypeForEnumeration(child, fieldInfo);
            } else {
                Node valueAttribute = child.getAttributes().getNamedItem("value");
                if (valueAttribute != null) {
                    fieldInfo.addEnumerationValue(valueAttribute.getNodeValue());
                }
            }
            ++i;
        }
    }

    private void traverseChildren(Node n) {
        NodeList children = n.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node child = children.item(i);
            this.traverse(child);
            ++i;
        }
    }

    private boolean isComplexTypeTag(String tag) {
        return tag.trim().equals("complexType") || tag.trim().equals("xsd:complexType");
    }

    private boolean isSimpleTypeTag(String tag) {
        return tag.trim().equals("simpleType") || tag.trim().equals("xsd:simpleType");
    }

    private boolean isAttributeTag(String tag) {
        return tag.trim().equals("attribute") || tag.trim().equals("xsd:attribute");
    }

    private void processElementTag(Node n) {
        String typeName;
        NamedNodeMap attributes = n.getAttributes();
        Node nameAttribute = attributes.getNamedItem("name");
        if (nameAttribute == null) {
            return;
        }
        String name = nameAttribute.getNodeValue();
        Node typeAttribute = attributes.getNamedItem("type");
        if (typeAttribute != null) {
            typeName = typeAttribute.getNodeValue();
        } else {
            this._lastUniqueComplexTypeName = typeName = this.getUniqueComplexTypeName();
        }
        this.addToSchemaFieldInfoListMap(name, typeName);
    }

    private String getUniqueComplexTypeName() {
        return "COMPLEXTYPE___" + this._uniqueCount++;
    }

    private void addToSchemaFieldInfoListMap(String field, String typeName) {
        SchemaFieldInfoList fieldInfoList = new SchemaFieldInfoList();
        fieldInfoList.add(new SchemaFieldInfoPair(DUMMY, new SchemaFieldInfo(this.removeNameSpace(typeName))));
        this._nameSchemaFieldInfoListMap.put(field, fieldInfoList);
        this._referencedNames.add(this.removeNameSpace(typeName));
    }

    private static boolean isElementTag(String tag) {
        return tag.trim().equals("element") || tag.trim().equals("xsd:element");
    }

    private static boolean isEnumerationTag(String tag) {
        return tag.trim().equals("enumeration") || tag.trim().equals("xsd:enumeration");
    }

    public boolean isAttribute(String field) {
        return field.endsWith("__");
    }

    static {
        PRIMITIVE_TYPES.add("xsi:string");
        PRIMITIVE_TYPES.add("string");
        PRIMITIVE_TYPES.add("xsi:boolean");
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("xsi:float");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("xsi:double");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("xsi:decimal");
        PRIMITIVE_TYPES.add("decimal");
        PRIMITIVE_TYPES.add("xsi:timeDuration");
        PRIMITIVE_TYPES.add("timeDuration");
        PRIMITIVE_TYPES.add("xsi:recurringDuration");
        PRIMITIVE_TYPES.add("recurringDuration");
        PRIMITIVE_TYPES.add("xsi:binary");
        PRIMITIVE_TYPES.add("binary");
        PRIMITIVE_TYPES.add("xsi:uriReference");
        PRIMITIVE_TYPES.add("uriReference");
        PRIMITIVE_TYPES.add("xsi:ID");
        PRIMITIVE_TYPES.add("ID");
        PRIMITIVE_TYPES.add("xsi:IDREF");
        PRIMITIVE_TYPES.add("IDREF");
        PRIMITIVE_TYPES.add("xsi:ENTITY");
        PRIMITIVE_TYPES.add("ENTITY");
        PRIMITIVE_TYPES.add("xsi:NUMTOKEN");
        PRIMITIVE_TYPES.add("NUMTOKEN");
        PRIMITIVE_TYPES.add("xsi:Qname");
        PRIMITIVE_TYPES.add("Qname");
    }

    private static class SchemaFieldInfoPair {
        private String _field;
        private SchemaFieldInfo _fieldInfo;

        public SchemaFieldInfoPair(String field, SchemaFieldInfo fieldInfo) {
            this._field = field;
            this._fieldInfo = fieldInfo;
        }

        public String getField() {
            return this._field;
        }

        public SchemaFieldInfo getSchemaFieldInfo() {
            return this._fieldInfo;
        }

        public String toString() {
            return "[" + this._field + ":" + this._fieldInfo + "]";
        }
    }

    private static class SchemaFieldInfoList {
        private LinkedList _elements = new LinkedList();

        private SchemaFieldInfoList() {
        }

        public void add(SchemaFieldInfoPair fieldInfoPair) {
            this._elements.add(fieldInfoPair);
        }

        public void add(int index, SchemaFieldInfoPair fieldInfoPair) {
            this._elements.add(index, fieldInfoPair);
        }

        public Iterator iterator() {
            return this._elements.iterator();
        }

        public String toString() {
            return this._elements.toString();
        }
    }
}

