/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.File;

public class RichQueryHandler {
    private static RichQueryHandler instance;
    private final boolean debugOn = false;

    public static synchronized RichQueryHandler instance() {
        if (instance != null) {
            return instance;
        }
        instance = new RichQueryHandler();
        return instance;
    }

    public synchronized Response[] query(LimeXMLDocument queryDoc) {
        String schema = queryDoc.getSchemaURI();
        SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection replyCol = mapper.getReplyCollection(schema);
        if (replyCol == null) {
            return null;
        }
        List matchingReplies = replyCol.getMatchingReplies(queryDoc);
        int s = matchingReplies.size();
        if (s == 0) {
            return null;
        }
        Response[] retResponses = new Response[s];
        long index = -1L;
        long size = -1L;
        String name = "";
        int z = 0;
        Iterator i = matchingReplies.iterator();
        while (i.hasNext()) {
            LimeXMLDocument currDoc = (LimeXMLDocument)i.next();
            String subjectFile = currDoc.getIdentifier();
            FileDesc fd = null;
            Response res = null;
            if (subjectFile == null) {
                index = 0xFFFFFFFFL;
                size = 0L;
                name = " ";
                res = new Response(index, size, name);
            } else {
                fd = RouterService.getFileManager().getFileDescForFile(new File(subjectFile));
                if (fd == null) continue;
                index = fd.getIndex();
                name = fd.getName();
                size = fd.getSize();
                res = new Response(fd);
                fd.incrementHitCount();
                RouterService.getCallback().handleSharedFileUpdate(fd.getFile());
            }
            res.setDocument(currDoc);
            retResponses[z] = res;
            ++z;
        }
        if (z == 0) {
            return null;
        }
        if (z < s) {
            Response[] temp = new Response[z];
            System.arraycopy(retResponses, 0, temp, 0, z);
            retResponses = temp;
        }
        this.debug("RQH: num Response = " + retResponses.length);
        return retResponses;
    }

    private void debug(String out) {
    }
}

