/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.sun.java.util.collections.ArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.StringTokenizer;

public class XMLHostCache {
    private final String XML_HOSTS_DIR = "xml" + File.separator + "misc" + File.separator;
    private final String XML_HOSTS_FILE = "server.props";
    private final String HOSTS_DELIM = ",";
    private Properties _props;
    private String _dbFile;
    private static final boolean debugOn = false;

    public XMLHostCache() throws Exception {
        String limeHome = LimeXMLProperties.instance().getPath();
        this._dbFile = limeHome + File.separator + this.XML_HOSTS_DIR + File.separator + "server.props";
        FileInputStream toLoadProps = new FileInputStream(this._dbFile);
        this._props = new Properties();
        this._props.load(toLoadProps);
        XMLHostCache.debug("" + this._props);
    }

    private String getHostsForSchema(String schemaURI) {
        String retString = null;
        String displayString = LimeXMLSchema.getDisplayString(schemaURI);
        if (displayString != null) {
            retString = this._props.getProperty(displayString);
        }
        return retString;
    }

    public String[] getCachedHostsForURI(String schemaURI) {
        String[] retHosts = null;
        String hosts = this.getHostsForSchema(schemaURI);
        if (hosts != null) {
            StringTokenizer st = new StringTokenizer(hosts, ",");
            ArrayList ipAddresses = new ArrayList();
            while (st.hasMoreTokens()) {
                String currHost = st.nextToken();
                try {
                    InetAddress currIA = InetAddress.getByName(currHost);
                    ipAddresses.add(currIA.getHostAddress());
                }
                catch (UnknownHostException ignored) {
                    // empty catch block
                }
            }
            retHosts = new String[ipAddresses.size()];
            int i = 0;
            while (i < retHosts.length) {
                retHosts[i] = (String)ipAddresses.get(i);
                ++i;
            }
        }
        return retHosts;
    }

    public static void main(String[] argv) throws Exception {
        XMLHostCache xmlhc = new XMLHostCache();
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        if (rep != null) {
            String[] uris = rep.getAvailableSchemaURIs();
            int i = 0;
            while (i < uris.length) {
                XMLHostCache.debug("curr uri = " + uris[i]);
                String[] hosts = xmlhc.getCachedHostsForURI(uris[i]);
                int j = 0;
                while (hosts != null && j < hosts.length) {
                    XMLHostCache.debug(hosts[j]);
                    ++j;
                }
                XMLHostCache.debug("--------------------");
                ++i;
            }
        }
    }

    public static final void debug(String out) {
    }
}

