/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;

public class XMLStringUtils {
    public static final String DELIMITER = "__";
    public static final String MAX_ENDING = "_MAX";
    public static final String MIN_ENDING = "_MIN";
    public static final String XML_DOC_START_IDENTIFIER = "<?xml";
    public static final String XML_VERSION_DELIM = "<?xml version=\"1.0\"?>";
    public static final String AUDIO_SCHEMA_TAG = "audio";
    public static final String VIDEO_SCHEMA_TAG = "video";
    private static final char URI_PATH_SEPARATOR = '/';

    public static List split(String canonicalizedField) {
        ArrayList returnList = new ArrayList();
        int lastIndex = 0;
        int index = 0;
        while ((index = canonicalizedField.indexOf(DELIMITER, lastIndex)) != -1) {
            returnList.add(canonicalizedField.substring(lastIndex, index));
            lastIndex = index + DELIMITER.length();
        }
        if (!canonicalizedField.endsWith(DELIMITER)) {
            returnList.add(canonicalizedField.substring(lastIndex));
        }
        return returnList;
    }

    public static List tokenize(String content, String delimiter) {
        LinkedList choppedElements = new LinkedList();
        int startIndex = content.indexOf(delimiter);
        while (startIndex != -1) {
            int endIndex = content.indexOf(delimiter, startIndex + 1);
            if (endIndex == -1) {
                choppedElements.add(content.substring(startIndex).trim());
                break;
            }
            choppedElements.add(content.substring(startIndex, endIndex).trim());
            startIndex = endIndex;
        }
        return choppedElements;
    }

    public static String getDomainName(String schemaURI) {
        int lastSeparatorIndex = schemaURI.lastIndexOf(47);
        String lastPart = lastSeparatorIndex != -1 ? schemaURI.substring(lastSeparatorIndex + 1) : schemaURI;
        int extensionIndex = lastPart.lastIndexOf(46);
        if (extensionIndex != -1) {
            return lastPart.substring(0, extensionIndex);
        }
        return lastPart;
    }
}

