/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.DisplayManager;
import com.limegroup.gnutella.gui.search.SearchField;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.limegroup.gnutella.xml.XMLStringUtils;
import com.limegroup.gnutella.xml.gui.MoreOptionsHandler;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public abstract class IndentingPanel
extends JPanel
implements Scrollable {
    public static final String CHECKBOX_STRING = GUIMediator.getStringResource("XML_SEARCH_MORE_OPTIONS_LABEL");
    public static final String MINI_VIEW = "Mini-View";
    public static final String MAX_VIEW = "Max-View";
    protected HashMap nameToField;
    private static final int PIXEL_OFFSET = 6;
    private JPanel expandablePanel;
    private final MoreOptionsHandler MORE_OPTIONS_HANDLER = new MoreOptionsHandler();
    private CardLayout advancedCards;
    private int defaultFields = 4;
    private String ancestorCanonicalized = "";
    private JCheckBox _moreOptions;
    private Component focusRequestor;
    private List textFields = new ArrayList();

    public IndentingPanel(LimeXMLSchema schema, ActionListener listener, boolean expand, boolean indent) {
        this(schema, listener, null, expand, indent);
    }

    public IndentingPanel(LimeXMLSchema schema, ActionListener listener, Document document, boolean expand, boolean indent) {
        DisplayManager dispMan = DisplayManager.instance();
        if (expand) {
            int s;
            this.defaultFields = s = schema.getCanonicalizedFields().size();
        }
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.nameToField = new HashMap();
        List fields = schema.getCanonicalizedFields();
        int indentsToClose = 0;
        int common = 0;
        int z = fields.size();
        Component filler = null;
        boolean firstTextFieldAdded = false;
        int i = 0;
        while (i < z) {
            String backupFieldName;
            JPanel fieldPanel;
            SchemaFieldInfo infoField = (SchemaFieldInfo)fields.get(i);
            String currField = infoField.getCanonicalizedFieldName();
            List currFieldList = XMLStringUtils.split(currField);
            this.ancestorCanonicalized = (String)currFieldList.remove(0);
            int numParents = currFieldList.size() - 1;
            if (i > 0) {
                SchemaFieldInfo p = (SchemaFieldInfo)fields.get(i - 1);
                String prev = p.getCanonicalizedFieldName();
                SchemaFieldInfo n = (SchemaFieldInfo)fields.get(i);
                String now = n.getCanonicalizedFieldName();
                List currFields = XMLStringUtils.split(prev);
                currFields.remove(0);
                List prevField = XMLStringUtils.split(now);
                prevField.remove(0);
                common = this.getCommonCount(currFields, prevField);
            }
            indentsToClose = common;
            JPanel outerField = new JPanel(new FlowLayout(0, 0, 0));
            outerField.setOpaque(false);
            int k = 0;
            while (k < common) {
                this.ancestorCanonicalized = this.ancestorCanonicalized + "__" + (String)currFieldList.get(k);
                ++k;
            }
            int j = common;
            while (j < numParents) {
                fieldPanel = new JPanel(new FlowLayout(0, 0, 0));
                fieldPanel.setOpaque(false);
                backupFieldName = (String)currFieldList.get(j);
                String key = this.ancestorCanonicalized + "__" + backupFieldName;
                String fieldName = dispMan.getDisplayName(key, schema.getDescription());
                JLabel label = new JLabel(LimeXMLUtils.capitalizeFirst(fieldName));
                if (indent) {
                    int k2 = 0;
                    while (k2 < indentsToClose) {
                        filler = Box.createHorizontalStrut(6);
                        outerField.add(filler);
                        ++k2;
                    }
                }
                outerField.add(fieldPanel);
                if (i < this.defaultFields) {
                    this.add(outerField);
                }
                ++indentsToClose;
                ++j;
            }
            outerField = new JPanel(new FlowLayout(0, 0, 0));
            fieldPanel = new BoxPanel(1);
            fieldPanel.setOpaque(false);
            outerField.setOpaque(false);
            if (indent) {
                int l = 0;
                while (l < indentsToClose) {
                    filler = Box.createHorizontalStrut(6);
                    outerField.add(filler);
                    ++l;
                }
            }
            backupFieldName = (String)currFieldList.get(numParents);
            String fieldName = dispMan.getDisplayName(currField, schema.getDescription());
            fieldName = DisplayManager.stripPreferredSize(fieldName);
            int type = infoField.getFieldType();
            String title = LimeXMLUtils.capitalizeFirst(fieldName);
            if (type == 1) {
                SearchField textField = new SearchField(14);
                if (!firstTextFieldAdded) {
                    firstTextFieldAdded = true;
                    this.focusRequestor = textField;
                    if (document != null) {
                        ((JTextComponent)textField).setDocument(document);
                    }
                }
                textField.setMargin(new Insets(0, 0, 0, 0));
                this.nameToField.put(currField.toLowerCase(Locale.US), textField);
                if (i >= this.defaultFields) {
                    this.MORE_OPTIONS_HANDLER.addTextField(textField, title);
                } else {
                    fieldPanel.add(IndentingPanel.createLabel(title));
                    fieldPanel.add(Box.createVerticalStrut(3));
                    fieldPanel.add(textField);
                }
                this.addTextFieldToList(textField);
                if (listener != null) {
                    textField.addActionListener(listener);
                }
            } else if (type == 2) {
                List values = infoField.getEnumerationList();
                int d = values.size();
                String[] vals = new String[d + 1];
                vals[0] = "";
                int m = 0;
                while (m < d) {
                    vals[m + 1] = (String)values.get(m);
                    ++m;
                }
                JComboBox<String> comboBox = new JComboBox<String>(vals);
                comboBox.setOpaque(false);
                this.nameToField.put(currField.toLowerCase(Locale.US), comboBox);
                fieldPanel.add(IndentingPanel.createLabel(title));
                fieldPanel.add(Box.createVerticalStrut(3));
                fieldPanel.add(comboBox);
                this.addComboBoxToList(comboBox);
                if (i >= this.defaultFields) {
                    this.MORE_OPTIONS_HANDLER.addComboBox(comboBox, title);
                }
            }
            outerField.add(fieldPanel);
            if (i < this.defaultFields) {
                this.add(outerField);
            }
            if (i == this.defaultFields) {
                this.advancedCards = new CardLayout(0, 0);
                this.expandablePanel = new JPanel(this.advancedCards);
                this.expandablePanel.setOpaque(false);
                JPanel tempPanel = new JPanel(new FlowLayout(0, 0, 0));
                tempPanel.setOpaque(false);
                final JCheckBox moreOptions = new JCheckBox(CHECKBOX_STRING);
                moreOptions.setPreferredSize(new Dimension(600, 20));
                moreOptions.setOpaque(false);
                moreOptions.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            if (moreOptions.isSelected()) {
                                IndentingPanel.this.expandablePanel.add(IndentingPanel.this.MORE_OPTIONS_HANDLER.createPanel(), IndentingPanel.MAX_VIEW);
                                IndentingPanel.this.advancedCards.show(IndentingPanel.this.expandablePanel, IndentingPanel.MAX_VIEW);
                                IndentingPanel.this.expandablePanel.revalidate();
                            } else {
                                IndentingPanel.this.expandablePanel.remove(IndentingPanel.this.MORE_OPTIONS_HANDLER.getPanel());
                                IndentingPanel.this.advancedCards.show(IndentingPanel.this.expandablePanel, IndentingPanel.MINI_VIEW);
                                IndentingPanel.this.expandablePanel.revalidate();
                            }
                        }
                        catch (Throwable t) {
                            ErrorService.error(t);
                        }
                    }
                });
                this._moreOptions = moreOptions;
                tempPanel.add(moreOptions);
                this.add(tempPanel);
                JPanel dummyPanel = new JPanel();
                dummyPanel.setOpaque(false);
                this.expandablePanel.add((Component)dummyPanel, MINI_VIEW);
                this.advancedCards.show(this.expandablePanel, MINI_VIEW);
                this.add(this.expandablePanel);
            }
            ++i;
        }
    }

    public void addMoreOptionsListener(ActionListener l) {
        if (this._moreOptions != null) {
            this._moreOptions.addActionListener(l);
        }
    }

    public void requestFirstFocus() {
        if (this.focusRequestor != null) {
            this.focusRequestor.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    static JPanel createLabel(String text) {
        BoxPanel labelPanel = new BoxPanel(0);
        labelPanel.setOpaque(false);
        JLabel inner = new JLabel(text);
        inner.setPreferredSize(new Dimension(100, 20));
        labelPanel.add(inner);
        labelPanel.add(Box.createHorizontalGlue());
        return labelPanel;
    }

    private int getCommonCount(List currField, List prevField) {
        int commonCount = 0;
        int smaller = currField.size() < prevField.size() ? currField.size() : prevField.size();
        boolean common = true;
        while (common && commonCount < smaller) {
            if (currField.get(commonCount).equals(prevField.get(commonCount))) {
                ++commonCount;
                continue;
            }
            common = false;
        }
        return commonCount;
    }

    public JComponent getField(String fieldName) {
        return (JComponent)this.nameToField.get(fieldName.toLowerCase(Locale.US));
    }

    private final void addTextFieldToList(JTextField tf) {
        this.textFields.add(tf);
    }

    private final void addComboBoxToList(JComboBox cb) {
        this.textFields.add(cb);
    }

    public void clear() {
        Iterator iter = this.textFields.iterator();
        while (iter.hasNext()) {
            Object currObject = iter.next();
            this.clearField(currObject);
        }
    }

    public void clearField(Object field) {
        if (field instanceof JTextField) {
            ((JTextField)field).setText(null);
        } else if (field instanceof JComboBox) {
            ((JComboBox)field).setSelectedIndex(0);
        } else {
            Assert.that(false, "Unknown Object!");
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 0: {
                return visibleRect.width / 10;
            }
            case 1: {
                return visibleRect.height / 10;
            }
        }
        throw new IllegalArgumentException("Unknown orientation " + orientation);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 0: {
                return visibleRect.width;
            }
            case 1: {
                return visibleRect.height;
            }
        }
        throw new IllegalArgumentException("Unknown orientation " + orientation);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

