/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml.gui;

import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.limegroup.gnutella.xml.gui.IndentingPanel;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.List;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class InputPanel
extends IndentingPanel {
    private LimeXMLSchema _schema;

    public InputPanel(LimeXMLSchema schema) {
        this(schema, null, null, false, false);
    }

    public InputPanel(LimeXMLSchema schema, ActionListener listener, Document document) {
        this(schema, listener, document, false, false);
    }

    public InputPanel(LimeXMLSchema schema, ActionListener listener, boolean expand, boolean indent) {
        this(schema, listener, null, expand, indent);
    }

    public InputPanel(LimeXMLSchema schema, ActionListener listener, Document document, boolean expand, boolean indent) {
        super(schema, listener, document, expand, indent);
        this._schema = schema;
    }

    public String getSchemaURI() {
        return this._schema.getSchemaURI();
    }

    public String getInput() {
        return this.getInput(false);
    }

    public String getInput(boolean normalize) {
        ArrayList namValList = new ArrayList();
        List list = this._schema.getCanonicalizedFields();
        int t = list.size();
        String[] fields = new String[t];
        int i = 0;
        while (i < t) {
            SchemaFieldInfo info = (SchemaFieldInfo)list.get(i);
            fields[i] = info.getCanonicalizedFieldName();
            ++i;
        }
        int size = fields.length;
        int i2 = 0;
        while (i2 < size) {
            String currField = fields[i2];
            JComponent comp = (JComponent)this.nameToField.get(currField.toLowerCase(Locale.US));
            String value = "";
            if (comp instanceof JTextField) {
                JTextField theField = (JTextField)comp;
                value = theField.getText();
            } else if (comp instanceof JComboBox) {
                JComboBox theBox = (JComboBox)comp;
                value = (String)theBox.getSelectedItem();
            }
            if (value != null && !value.equals("")) {
                NameValue namValue = new NameValue(currField, normalize ? I18NConvert.instance().getNorm(value) : value);
                namValList.add(namValue);
            }
            ++i2;
        }
        String schemaURI = this._schema.getSchemaURI();
        String str = InputPanel.constructXML(namValList, schemaURI);
        return str;
    }

    public void storeInput() {
        List list = this._schema.getCanonicalizedFields();
        int listLength = list.size();
        String[] fields = new String[listLength];
        int i = 0;
        while (i < listLength) {
            SchemaFieldInfo info = (SchemaFieldInfo)list.get(i);
            fields[i] = info.getCanonicalizedFieldName();
            ++i;
        }
        int size = fields.length;
        int i2 = 0;
        while (i2 < size) {
            AutoCompleteTextField theField;
            JComponent comp = (JComponent)this.nameToField.get(fields[i2].toLowerCase(Locale.US));
            if (comp instanceof AutoCompleteTextField && !(theField = (AutoCompleteTextField)comp).getText().equals("")) {
                theField.addToDictionary();
            }
            ++i2;
        }
    }

    public String getStandardQuery() {
        List list = this._schema.getCanonicalizedFields();
        int size = list.size();
        String[] fields = new String[size];
        int i = 0;
        while (i < size) {
            SchemaFieldInfo info = (SchemaFieldInfo)list.get(i);
            fields[i] = info.getCanonicalizedFieldName();
            ++i;
        }
        StringBuffer retString = new StringBuffer();
        int numWords = 0;
        int i2 = 0;
        while (i2 < size && numWords < 3) {
            String currField = fields[i2];
            JComponent comp = (JComponent)this.nameToField.get(currField.toLowerCase(Locale.US));
            String value = "";
            if (comp instanceof JTextField) {
                JTextField theField = (JTextField)comp;
                value = theField.getText();
            } else if (comp instanceof JComboBox) {
                JComboBox theBox = (JComboBox)comp;
                value = (String)theBox.getSelectedItem();
            }
            if (value != null && value.trim().length() > 1) {
                StringTokenizer st = new StringTokenizer(value);
                numWords += st.countTokens();
                retString.append(value + " ");
            }
            ++i2;
        }
        if (retString.length() > SearchSettings.MAX_QUERY_LENGTH.getValue()) {
            retString.setLength(SearchSettings.MAX_QUERY_LENGTH.getValue());
        }
        return retString.toString();
    }

    public static String constructXML(ArrayList namValList, String uri) {
        return LimeXMLDocument.constructXML(namValList, uri);
    }

    public static void main(String[] args) {
        LimeXMLSchema schema = null;
        try {
            File f = new File("c:\\home\\etc\\schemas", "personal.xsd");
            schema = new LimeXMLSchema(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ((Component)frame).setSize(600, 600);
        InputPanel panel = new InputPanel(schema, null, false, true);
        frame.getContentPane().add(panel);
        frame.show();
    }
}

