/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.DisplayManager;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import com.limegroup.gnutella.xml.gui.EditingPanel;
import com.limegroup.gnutella.xml.gui.InputPanel;
import com.limegroup.gnutella.xml.gui.OuterEditingPanel;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.List;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.xml.sax.SAXException;

public class MetaEditorFrame
extends JDialog
implements ActionListener {
    private static final String FILE_LABEL = GUIMediator.getStringResource("META_EDITOR_ANNOTATING_FILE");
    private static final int DIALOG_WIDTH = 500;
    private static final int DIALOG_HEIGHT = 500;
    private static final int INIT_X = 100;
    private static final int INIT_Y = 100;
    private JPanel filePanel;
    private JLabel fileLabel;
    private JTextField fileField;
    private JPanel buttonPanel;
    private JButton saveButton;
    private JButton cancelButton;
    private JButton deleteButton;
    private JSplitPane splitPane;
    private JPanel upperLeftPanel;
    private JPanel lowerLeftPanel;
    private JList docSchemaList;
    private JLabel editLabel;
    private JLabel addLabel;
    private JList unDocSchemaList;
    private InputPanel innerEditPanel;
    private OuterEditingPanel outerEditPanel;
    private JScrollPane upperLeftScroller;
    private JScrollPane lowerLeftScroller;
    private List noDocSchemas;
    private List docsOfFile;
    private String fileName;
    private String selectedSchemaURI;
    private LimeXMLDocument editedDoc;
    private JSplitPane splitter;
    private JPanel grandPanel;
    private URN editFileHashValue;
    private FileDesc fd;

    public MetaEditorFrame(FileDesc fd, String fullName, Frame owner) {
        super(owner, GUIMediator.getStringResource("META_EDITOR_ANNOTATING_FILE") + "\"" + fullName + "\"", true);
        this.fileName = fullName;
        this.fd = fd;
        this.editFileHashValue = fd.getSHA1Urn();
        this.noDocSchemas = new ArrayList();
        this.docsOfFile = this.getDocs();
        this.filePanel = new JPanel(new FlowLayout(0));
        this.fileLabel = new JLabel(FILE_LABEL);
        this.fileField = new JTextField();
        this.fileField.setText(fullName);
        this.fileField.setEditable(false);
        this.filePanel.add(this.fileLabel);
        this.filePanel.add(this.fileField);
        this.buttonPanel = new JPanel();
        this.saveButton = new JButton(GUIMediator.getStringResource("META_EDITOR_SAVE_LABEL"));
        this.cancelButton = new JButton(GUIMediator.getStringResource("META_EDITOR_CANCEL_LABEL"));
        this.deleteButton = new JButton(GUIMediator.getStringResource("META_EDITOR_DELETE_LABEL"));
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.cancelButton);
        this.upperLeftPanel = new JPanel();
        this.upperLeftPanel.setLayout(new BorderLayout());
        this.lowerLeftPanel = new JPanel();
        this.lowerLeftPanel.setLayout(new BorderLayout());
        this.editLabel = new JLabel(GUIMediator.getStringResource("META_EDITOR_EDITING_LABEL"));
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(this.editLabel);
        this.upperLeftPanel.add((Component)p1, "North");
        int used = this.docsOfFile.size();
        String[] usedSchemas = new String[used];
        DisplayManager dispMan = DisplayManager.instance();
        int i = 0;
        while (i < used) {
            LimeXMLDocument d = (LimeXMLDocument)this.docsOfFile.get(i);
            usedSchemas[i] = dispMan.getDisplayTitleForSchema(d.getSchemaURI());
            ++i;
        }
        this.docSchemaList = new JList<String>(usedSchemas);
        this.docSchemaList.setSelectionMode(0);
        this.docSchemaList.addListSelectionListener(new DocListListener());
        this.upperLeftScroller = new JScrollPane(this.docSchemaList);
        this.upperLeftPanel.add((Component)this.upperLeftScroller, "Center");
        this.addLabel = new JLabel(GUIMediator.getStringResource("META_EDITOR_ADDING_LABEL"));
        JPanel p2 = new JPanel(new FlowLayout(0));
        p2.add(this.addLabel);
        this.lowerLeftPanel.add((Component)p2, "North");
        int unused = this.noDocSchemas.size();
        String[] unusedSchemas = new String[unused];
        int j = 0;
        while (j < unused) {
            String uri = (String)this.noDocSchemas.get(j);
            unusedSchemas[j] = dispMan.getDisplayTitleForSchema(uri);
            ++j;
        }
        this.unDocSchemaList = new JList<String>(unusedSchemas);
        this.unDocSchemaList.setSelectionMode(0);
        this.unDocSchemaList.addListSelectionListener(new UnDocListListener());
        this.lowerLeftScroller = new JScrollPane(this.unDocSchemaList);
        this.lowerLeftPanel.add((Component)this.lowerLeftScroller, "Center");
        this.splitPane = new JSplitPane(0, this.upperLeftPanel, this.lowerLeftPanel);
        this.splitPane.setDividerLocation(this.splitPane.getMinimumDividerLocation() + 99);
        int index = this.docSchemaList.getSelectedIndex();
        if (index > -1) {
            LimeXMLDocument doc = (LimeXMLDocument)this.docsOfFile.get(index);
            String schemaURI = doc.getSchemaURI();
            LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
            LimeXMLSchema schema = rep.getSchema(schemaURI);
            this.innerEditPanel = new EditingPanel(schema, doc);
        } else {
            index = this.unDocSchemaList.getSelectedIndex();
            if (index > -1) {
                String schemaURI = (String)this.noDocSchemas.get(index);
                LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
                LimeXMLSchema schema = rep.getSchema(schemaURI);
                this.innerEditPanel = new InputPanel(schema, null, true, true);
            }
        }
        this.outerEditPanel = new OuterEditingPanel(this.innerEditPanel);
        ((Component)this).setSize(500, 500);
        ((Component)this).setLocation(100, 100);
        this.splitter = new JSplitPane(1, this.splitPane, this.outerEditPanel);
        this.splitter.setDividerLocation(this.splitter.getMinimumDividerLocation());
        this.grandPanel = new JPanel();
        this.grandPanel.setLayout(new BorderLayout());
        this.grandPanel.add((Component)this.filePanel, "North");
        this.grandPanel.add((Component)this.splitter, "Center");
        this.grandPanel.add((Component)this.buttonPanel, "South");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.grandPanel, "Center");
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.saveButton)) {
                boolean close = this.saveMeta();
                if (close) {
                    this.dispose();
                }
            } else if (event.getSource().equals(this.deleteButton)) {
                this.removeMeta();
                this.dispose();
            } else if (event.getSource().equals(this.cancelButton)) {
                this.dispose();
            }
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    private void removeMeta() {
        InputPanel removePanel = this.outerEditPanel.getContentPanel();
        if (!(removePanel instanceof EditingPanel)) {
            GUIMediator.showError("ERROR_DEL_META_USER");
            return;
        }
        String uri = this.editedDoc.getSchemaURI();
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection collection = map.getReplyCollection(uri);
        Assert.that(collection != null, "Trying to remove data from a non-existent collection");
        boolean removed = collection.removeDoc(this.fd);
        if (removed) {
            this.editedDoc = null;
        } else {
            GUIMediator.showError("ERROR_DEL_META_SYSTEM");
        }
    }

    private boolean saveMeta() {
        InputPanel inputPanel = this.outerEditPanel.getContentPanel();
        if (inputPanel == null) {
            return true;
        }
        String XMLString = inputPanel.getInput();
        LimeXMLDocument newDoc = null;
        LimeXMLDocument oldDoc = null;
        try {
            newDoc = new LimeXMLDocument(XMLString);
        }
        catch (SAXException e) {
            GUIMediator.showError("ERROR_SAVE_META_DOC");
            return true;
        }
        catch (SchemaNotFoundException e) {
            GUIMediator.showError("ERROR_SAVE_META_DOC");
            return true;
        }
        catch (IOException e) {
            GUIMediator.showError("ERROR_SAVE_META_DOC");
            return true;
        }
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        String uri = newDoc.getSchemaURI();
        LimeXMLReplyCollection collection = map.getReplyCollection(uri);
        Assert.that(collection != null, "Can't add document. No Collection exists for uri:" + uri + "\nDocument created with string: " + XMLString);
        if (inputPanel instanceof EditingPanel) {
            oldDoc = collection.replaceDoc(this.fd, newDoc);
        } else if (inputPanel instanceof InputPanel) {
            collection.addReply(this.fd, newDoc);
        } else {
            GUIMediator.showError("ERROR_SAVE_META_ILLEGAL");
        }
        int committed = -1;
        boolean committed2 = true;
        if (collection.isAudio()) {
            committed = collection.mp3ToDisk(this.fd, this.fileName, newDoc, false);
        } else {
            committed2 = collection.write();
        }
        if (!committed2) {
            GUIMediator.showError("ERROR_SAVE_META_DISK");
            return true;
        }
        switch (committed) {
            case 1: {
                GUIMediator.showError("ERROR_SAVE_META_FILE");
                return true;
            }
            case 2: {
                GUIMediator.showError("ERROR_SAVE_META_RW");
                return true;
            }
            case 3: {
                GUIMediator.showError("ERROR_SAVE_META_ID3");
                return true;
            }
            case 4: {
                GUIMediator.showError("ERROR_SAVE_META_ID3");
                return false;
            }
            case 5: {
                this.cleanUpChanges("audios__audio__artist__", collection, oldDoc);
                return false;
            }
            case 6: {
                this.cleanUpChanges("audios__audio__album__", collection, oldDoc);
                return false;
            }
            case 7: {
                this.cleanUpChanges("audios__audio__year__", collection, oldDoc);
                return false;
            }
            case 8: {
                this.cleanUpChanges("audios__audio__comment__", collection, oldDoc);
                return false;
            }
            case 9: {
                this.cleanUpChanges("audios__audio__track__", collection, oldDoc);
                return false;
            }
            case 10: {
                this.cleanUpChanges("audios__audio__genre__", collection, oldDoc);
                return false;
            }
            case 11: {
                GUIMediator.showError("ERROR_SAVE_META_DISK");
                return true;
            }
        }
        return true;
    }

    private void cleanUpChanges(String canonicalFieldName, LimeXMLReplyCollection collection, LimeXMLDocument oldDoc) {
        GUIMediator.showError("ERROR_SAVE_META_BAD");
        JComponent comp = this.innerEditPanel.getField(canonicalFieldName);
        this.innerEditPanel.clearField(comp);
        if (oldDoc == null) {
            collection.removeDoc(this.fd);
        } else {
            collection.replaceDoc(this.fd, oldDoc);
        }
    }

    private List getDocs() {
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        String[] schemas = rep.getAvailableSchemaURIs();
        int len = schemas.length;
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        ArrayList xmlDocs = new ArrayList();
        int i = 0;
        while (i < len) {
            LimeXMLReplyCollection coll = map.getReplyCollection(schemas[i]);
            if (coll == null || coll.getCount() < 1) {
                this.noDocSchemas.add(schemas[i]);
            } else {
                LimeXMLDocument currDoc = coll.getDocForHash(this.editFileHashValue);
                if (currDoc == null) {
                    this.noDocSchemas.add(schemas[i]);
                } else {
                    xmlDocs.add(currDoc);
                }
            }
            ++i;
        }
        return xmlDocs;
    }

    private class UnDocListListener
    implements ListSelectionListener {
        private UnDocListListener() {
        }

        public void valueChanged(ListSelectionEvent event) {
            int sIndex = MetaEditorFrame.this.docSchemaList.getSelectedIndex();
            MetaEditorFrame.this.docSchemaList.removeSelectionInterval(sIndex, sIndex);
            int index = MetaEditorFrame.this.unDocSchemaList.getSelectedIndex();
            if (index > -1) {
                String schemaURI = (String)MetaEditorFrame.this.noDocSchemas.get(index);
                MetaEditorFrame.this.selectedSchemaURI = schemaURI;
                MetaEditorFrame.this.editedDoc = null;
                LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
                LimeXMLSchema schema = rep.getSchema(schemaURI);
                MetaEditorFrame.this.innerEditPanel = new InputPanel(schema, null, true, true);
                MetaEditorFrame.this.outerEditPanel.setContent(MetaEditorFrame.this.innerEditPanel);
                MetaEditorFrame.this.outerEditPanel.revalidate();
            }
        }
    }

    private class DocListListener
    implements ListSelectionListener {
        private DocListListener() {
        }

        public void valueChanged(ListSelectionEvent event) {
            int sIndex = MetaEditorFrame.this.unDocSchemaList.getSelectedIndex();
            MetaEditorFrame.this.unDocSchemaList.removeSelectionInterval(sIndex, sIndex);
            int index = MetaEditorFrame.this.docSchemaList.getSelectedIndex();
            if (index > -1) {
                LimeXMLDocument doc = (LimeXMLDocument)MetaEditorFrame.this.docsOfFile.get(index);
                MetaEditorFrame.this.editedDoc = doc;
                MetaEditorFrame.this.selectedSchemaURI = doc.getSchemaURI();
                LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
                LimeXMLSchema schema = rep.getSchema(MetaEditorFrame.this.selectedSchemaURI);
                MetaEditorFrame.this.innerEditPanel = new EditingPanel(schema, doc);
                MetaEditorFrame.this.outerEditPanel.setContent(MetaEditorFrame.this.innerEditPanel);
                MetaEditorFrame.this.outerEditPanel.revalidate();
            }
        }
    }
}

