/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.util;

import de.kapsi.util.AEDesc;
import de.kapsi.util.OSAException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class OSAScript {
    private int ptr = 0;

    public OSAScript(String source) throws UnsatisfiedLinkError, OSAException {
        int[] tmp = new int[1];
        int errorCode = OSAScript.NewOSAScriptWithSrc(tmp, source);
        this.ptr = tmp[0];
        if (this.ptr == 0) {
            throw new IllegalStateException();
        }
        if (errorCode < 0) {
            String msg = OSAScript.GetErrorMessage(this.ptr);
            int errorNum = OSAScript.GetErrorNumber(this.ptr);
            throw new OSAException(msg, errorNum, errorCode);
        }
        this.compile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OSAScript(File file) throws UnsatisfiedLinkError, IOException, OSAException {
        BufferedInputStream in = null;
        try {
            byte[] buf = new byte[(int)file.length()];
            in = new BufferedInputStream(new FileInputStream(file));
            if (in.read(buf, 0, buf.length) != buf.length) {
                throw new IOException();
            }
            int[] tmp = new int[1];
            int errorCode = OSAScript.NewOSAScriptWithBin(tmp, buf);
            this.ptr = tmp[0];
            if (this.ptr == 0) {
                throw new IllegalStateException();
            }
            if (errorCode < 0) {
                String msg = OSAScript.GetErrorMessage(this.ptr);
                int errorNum = OSAScript.GetErrorNumber(this.ptr);
                throw new OSAException(msg, errorNum, errorCode);
            }
            Object var9_8 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (in == null) throw throwable;
            in.close();
            in = null;
            throw throwable;
        }
        in.close();
    }

    public OSAScript(byte[] script) throws UnsatisfiedLinkError, OSAException {
        int[] tmp = new int[1];
        int errorCode = OSAScript.NewOSAScriptWithBin(tmp, script);
        this.ptr = tmp[0];
        if (errorCode < 0) {
            String msg = OSAScript.GetErrorMessage(this.ptr);
            int errorNum = OSAScript.GetErrorNumber(this.ptr);
            throw new OSAException(msg, errorNum, errorCode);
        }
    }

    public byte[] getBytes() throws OSAException, IllegalStateException {
        if (this.ptr == 0) {
            throw new IllegalStateException();
        }
        int size = OSAScript.GetOSAScriptSize(this.ptr);
        if (size == 0) {
            return null;
        }
        byte[] dst = new byte[size];
        int errorCode = OSAScript.GetOSAScript(this.ptr, dst, 0, size);
        if (errorCode < 0) {
            String msg = OSAScript.GetErrorMessage(this.ptr);
            int errorNum = OSAScript.GetErrorNumber(this.ptr);
            throw new OSAException(msg, errorNum, errorCode);
        }
        return dst;
    }

    private void compile() throws OSAException, IllegalStateException {
        if (this.ptr == 0) {
            throw new IllegalStateException();
        }
        int errorCode = OSAScript.CompileOSAScript(this.ptr);
        if (errorCode < 0) {
            String msg = OSAScript.GetErrorMessage(this.ptr);
            int errorNum = OSAScript.GetErrorNumber(this.ptr);
            throw new OSAException(msg, errorNum, errorCode);
        }
    }

    public void execute() throws OSAException, IllegalStateException {
        if (this.ptr == 0) {
            throw new IllegalStateException();
        }
        int errorCode = OSAScript.ExecuteOSAScript(this.ptr);
        if (errorCode < 0) {
            String msg = OSAScript.GetErrorMessage(this.ptr);
            int errorNum = OSAScript.GetErrorNumber(this.ptr);
            throw new OSAException(msg, errorNum, errorCode);
        }
    }

    public void execute(String subroutine) throws OSAException, IllegalStateException {
        if (this.ptr == 0) {
            throw new IllegalStateException();
        }
        int errorCode = OSAScript.ExecuteOSAScriptEvent(this.ptr, subroutine, null);
        if (errorCode < 0) {
            String msg = OSAScript.GetErrorMessage(this.ptr);
            int errorNum = OSAScript.GetErrorNumber(this.ptr);
            throw new OSAException(msg, errorNum, errorCode);
        }
    }

    public void execute(String subroutine, String[] args) throws OSAException, IllegalStateException {
        if (this.ptr == 0) {
            throw new IllegalStateException();
        }
        int errorCode = OSAScript.ExecuteOSAScriptEvent(this.ptr, subroutine, args);
        if (errorCode < 0) {
            String msg = OSAScript.GetErrorMessage(this.ptr);
            int errorNum = OSAScript.GetErrorNumber(this.ptr);
            throw new OSAException(msg, errorNum, errorCode);
        }
    }

    public AEDesc getResult() throws OSAException, IllegalStateException {
        if (this.ptr == 0) {
            throw new IllegalStateException();
        }
        int size = OSAScript.GetResultDataSize(this.ptr);
        if (size > 0) {
            String type = OSAScript.GetResultType(this.ptr);
            byte[] data = new byte[size];
            OSAScript.GetResultData(this.ptr, data, 0, size);
            return new AEDesc(type, data);
        }
        return null;
    }

    public void close() {
        if (this.ptr > 0) {
            OSAScript.ReleaseOSAScript(this.ptr);
            this.ptr = 0;
        }
    }

    protected void finalize() throws Throwable {
        if (this.ptr > 0) {
            OSAScript.ReleaseOSAScript(this.ptr);
        }
    }

    private static synchronized native int NewOSAScriptWithSrc(int[] var0, String var1);

    private static synchronized native int NewOSAScriptWithBin(int[] var0, byte[] var1);

    private static synchronized native int CompileOSAScript(int var0);

    private static synchronized native int ReleaseOSAScript(int var0);

    private static synchronized native int ExecuteOSAScript(int var0);

    private static synchronized native int ExecuteOSAScriptEvent(int var0, String var1, String[] var2);

    private static synchronized native int GetOSAScriptSize(int var0);

    private static synchronized native int GetOSAScript(int var0, byte[] var1, int var2, int var3);

    private static synchronized native String GetResultType(int var0);

    private static synchronized native int GetResultDataSize(int var0);

    private static synchronized native int GetResultData(int var0, byte[] var1, int var2, int var3);

    private static synchronized native String GetErrorMessage(int var0);

    private static synchronized native int GetErrorNumber(int var0);

    static {
        System.loadLibrary("OpenScripting");
    }
}

