/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.LimeButton;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class LimeButtonUI
extends BasicButtonUI {
    private static final LimeButtonUI limeButtonUI = new LimeButtonUI();
    private static Rectangle iconRect = new Rectangle();
    private static final ImageIcon _default0;
    private static final ImageIcon _default1;
    private static final ImageIcon _default2;
    private static final ImageIcon _default3;
    private static final ImageIcon _pressed0;
    private static final ImageIcon _pressed1;
    private static final ImageIcon _pressed2;
    private static final ImageIcon _pressed3;
    private Icon _currentIcon;
    private Icon _currentPressedIcon;
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return limeButtonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (!(jComponent instanceof LimeButton) && !(jComponent.getParent() instanceof JComboBox) && abstractButton.getIcon() == null) {
            abstractButton.setBorderPainted(false);
            abstractButton.setContentAreaFilled(false);
            abstractButton.setHorizontalTextPosition(0);
            abstractButton.setFocusPainted(false);
            this.setIcon(graphics, abstractButton, abstractButton.getModel(), abstractButton.getText());
            abstractButton.setIcon(this._currentIcon);
            abstractButton.setPressedIcon(this._currentPressedIcon);
            abstractButton.setPreferredSize(new Dimension(this._currentIcon.getIconWidth(), this._currentIcon.getIconHeight()));
        }
        super.paint(graphics, jComponent);
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    private void setIcon(Graphics graphics, AbstractButton abstractButton, ButtonModel buttonModel, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics(abstractButton.getFont());
        int n2 = fontMetrics.stringWidth(string);
        if (n2 < 30) {
            this._currentIcon = _default0;
            this._currentPressedIcon = _pressed0;
        } else if (n2 < 53) {
            this._currentIcon = _default1;
            this._currentPressedIcon = _pressed1;
        } else if (n2 < 72) {
            this._currentIcon = _default2;
            this._currentPressedIcon = _pressed2;
        } else {
            this._currentIcon = _default3;
            this._currentPressedIcon = _pressed3;
        }
    }

    static {
        URL uRL = ClassLoader.getSystemResource("com/limegroup/gnutella/gui/images/button1.gif");
        URL uRL2 = ClassLoader.getSystemResource("com/limegroup/gnutella/gui/images/button2.gif");
        URL uRL3 = ClassLoader.getSystemResource("com/limegroup/gnutella/gui/images/button3.gif");
        URL uRL4 = ClassLoader.getSystemResource("com/limegroup/gnutella/gui/images/button4.gif");
        URL uRL5 = ClassLoader.getSystemResource("com/limegroup/gnutella/gui/images/button1_press.gif");
        URL uRL6 = ClassLoader.getSystemResource("com/limegroup/gnutella/gui/images/button2_press.gif");
        URL uRL7 = ClassLoader.getSystemResource("com/limegroup/gnutella/gui/images/button3_press.gif");
        URL uRL8 = ClassLoader.getSystemResource("com/limegroup/gnutella/gui/images/button4_press.gif");
        _default0 = new ImageIcon(uRL);
        _default1 = new ImageIcon(uRL2);
        _default2 = new ImageIcon(uRL3);
        _default3 = new ImageIcon(uRL4);
        _pressed0 = new ImageIcon(uRL5);
        _pressed1 = new ImageIcon(uRL6);
        _pressed2 = new ImageIcon(uRL7);
        _pressed3 = new ImageIcon(uRL8);
    }
}

