/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.lax;

import com.zerog.awt.ZGStandardDialog;
import com.zerog.common.io.NullInputStream;
import com.zerog.common.io.NullOutputStream;
import com.zerog.common.java.lang.StringUtil;
import com.zerog.common.java.util.PropertiesUtil;
import com.zerog.lax.LAXQuotedStreamTokenizer;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class LAX {
    public static final String LAX_VERSION = "4.0";
    public static final String PROPERTYPREFIX = "lax.";
    public static final String VERSION = "lax.version";
    public static final String APP_NAME = "lax.application.name";
    public static final String MAIN_CLASS = "lax.main.class";
    public static final String MAIN_METHOD = "lax.main.method";
    public static final String CMD_LINE_ARGS = "lax.command.line.args";
    public static final String USER_DIR = "lax.user.dir";
    public static final String INSTALL_DIRECTORY = "lax.root.install.dir";
    public static final String NATIVE_LAUNCHER_INSTALL_DIRECTORY = "lax.dir";
    public static final String LAX_MAIN_CLASS = "lax.nl.java.launcher.main.class";
    public static final String LAX_MAIN_METHOD = "lax.nl.java.launcher.main.method";
    public static final String CLASS_PATH = "lax.class.path";
    public static final String CURRENT_VM = "lax.nl.current.vm";
    public static final String STDIN = "lax.stdin.redirect";
    public static final String STDOUT = "lax.stdout.redirect";
    public static final String STDERR = "lax.stderr.redirect";
    public String[] nativeArgs;
    public PrintStream originalSTDOUT = System.out;
    public PrintStream originalSTDERR = System.err;
    public Throwable theException;
    public static final String generalAppErrorString = "Unable to Launch Java Application";
    public static final String generalAppFailureString = "This Application has Unexpectedly Quit";
    public static final String alertDialogTitle = "Fatal Application Error";

    public void addProperties(String[] stringArray) throws IOException {
        if (stringArray[0].toUpperCase().endsWith(".LAX")) {
            File file = new File(stringArray[0]);
            if (!file.exists()) {
                file = new File(file.getName());
            }
            Properties properties = file.exists() ? PropertiesUtil.loadProperties(file) : new Properties();
            PropertiesUtil.mergeIntoProps(System.getProperties(), properties);
        }
    }

    public LAX(String[] stringArray) throws Throwable {
        String string;
        Properties properties;
        if (stringArray != null) {
            this.nativeArgs = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                this.nativeArgs[n] = StringUtil.convertFromEscapedUnicode(stringArray[n]);
                ++n;
            }
        } else {
            this.nativeArgs = null;
        }
        if (this.nativeArgs != null && this.nativeArgs.length > 0) {
            File file;
            this.addProperties(this.nativeArgs);
            if (!this.verifyProperty(MAIN_CLASS, this.nativeArgs[0])) {
                return;
            }
            if (!this.verifyProperty(MAIN_METHOD, this.nativeArgs[0])) {
                return;
            }
            if (this.nativeArgs.length > 1 && !this.nativeArgs[1].equals("lax_no_temp_file") && (file = new File(this.nativeArgs[1])) != null && file.exists()) {
                properties = PropertiesUtil.loadProperties(new File(this.nativeArgs[1]));
                file.delete();
                PropertiesUtil.mergeIntoProps(System.getProperties(), properties);
            }
        } else {
            this.originalSTDOUT.println("Path not supplied to properties file");
        }
        if ((string = System.getProperty("os.name").toLowerCase()).indexOf("unix") != -1 || string.indexOf("irix") != -1 || string.indexOf("netbsd") != -1 || string.indexOf("freebsd") != -1 || string.indexOf("bsdi") != -1 || string.indexOf("bsd") != -1 || string.indexOf("unixware") != -1 || string.indexOf("aix") != -1 || string.indexOf("dg/ux") != -1 || string.indexOf("dgux") != -1 || string.indexOf("linux") != -1 || string.indexOf("machten") != -1 || string.indexOf("nextstep") != -1 || string.indexOf("rhapsody") != -1 || string.indexOf("mac os x") != -1 || string.indexOf("hp-ux") != -1 || string.indexOf("hpux") != -1 || string.indexOf("sunos") != -1 || string.indexOf("solaris") != -1 || string.indexOf("windows") != -1) {
            this.setStdOutStdErr();
        }
        if (System.getProperty("LISTPROPS") != null) {
            PropertiesUtil.listProperties(System.out, System.getProperties());
        }
        if (System.getProperty("lax.java.compiler") == "off" || System.getProperty("lax.nl.java.compiler") == "off") {
            Compiler.disable();
        }
        properties = System.getProperties();
        ((Hashtable)properties).put(VERSION, LAX_VERSION);
        System.setProperties(properties);
        String string2 = System.getProperty("lax.nl.env.LAX_DEBUG");
        if (string2 == null) {
            string2 = System.getProperty("lax.control-key");
        }
        if (string2 != null && !string2.equals("false") && !string2.trim().equals("")) {
            System.err.println("LAX Version = 4.0");
        }
    }

    private void setStdOutStdErr() {
        String string;
        String string2;
        String string3 = System.getProperty(STDIN);
        if (string3 != null) {
            if (string3.length() > 0) {
                if (!string3.toLowerCase().trim().equals("console") && !string3.toLowerCase().trim().equals("")) {
                    try {
                        System.setIn(new FileInputStream(string3));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.out.println("Error redirecting stdin from file.");
                        fileNotFoundException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            } else {
                System.setIn(new NullInputStream());
            }
        } else {
            System.setIn(new NullInputStream());
        }
        if ((string2 = System.getProperty(STDOUT)) != null) {
            if (string2.length() > 0) {
                if (!string2.toLowerCase().trim().equals("console") && !string2.toLowerCase().trim().equals("")) {
                    try {
                        System.setOut(new PrintStream(new FileOutputStream(string2)));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        try {
                            System.setOut(new PrintStream(new FileOutputStream("out.txt")));
                            System.out.println("Error redirecting stdout.  Output will be placed into 'out.txt' instead.");
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            } else {
                System.setOut(new PrintStream(new NullOutputStream()));
            }
        } else {
            System.setOut(new PrintStream(new NullOutputStream()));
        }
        if ((string = System.getProperty(STDERR)) != null) {
            if (string.length() > 0) {
                if (!string.toLowerCase().trim().equals("console") && !string.toLowerCase().trim().equals("")) {
                    if (string.equals(string2)) {
                        System.setErr(System.out);
                    } else {
                        try {
                            System.setErr(new PrintStream(new FileOutputStream(string)));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            try {
                                System.setOut(new PrintStream(new FileOutputStream("err.txt")));
                                System.out.println("Error redirecting stderr.  Output will be placed into 'err.txt' instead.");
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            } else {
                System.setErr(new PrintStream(new NullOutputStream()));
            }
        } else {
            System.setErr(new PrintStream(new NullOutputStream()));
        }
    }

    public void launch() {
        Properties properties = System.getProperties();
        Class<?> clazz = null;
        String string = properties.getProperty(MAIN_CLASS);
        Method method = null;
        String string2 = properties.getProperty(MAIN_METHOD);
        String string3 = properties.getProperty(CMD_LINE_ARGS);
        String string4 = "";
        try {
            Object[] objectArray;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.theException = classNotFoundException;
                string4 = "Unable to locate the application's 'main' class. The class '" + string + "' must be public and have a 'public static void " + string2 + "(String[])' method. (LAX)";
                this.originalSTDERR.println(string4);
                this.showExceptionDialog(generalAppErrorString, string4, true);
                System.exit(-1);
            }
            try {
                objectArray = new Class[]{new String[0].getClass()};
                method = clazz.getMethod(string2, (Class<?>[])objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.theException = noSuchMethodException;
                string4 = "The method to invoke is not accessible. The class '" + string + "' must be public and have a 'public static void " + string2 + "(String[])' method. (LAX)";
                this.originalSTDERR.println(string4);
                this.showExceptionDialog(generalAppErrorString, string4, true);
                System.exit(-1);
            }
            try {
                objectArray = new Object[]{this.parseArgs(string3)};
                method.invoke(null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.theException = illegalAccessException;
                string4 = "The method to invoke is not accessible. The class '" + string + "' must be public and have a 'public static void " + string2 + "(String[])' method. (LAX)";
                this.originalSTDERR.println(string4);
                this.showExceptionDialog(generalAppErrorString, string4, true);
                System.exit(-1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.theException = illegalArgumentException;
                string4 = "The method to invoke is not accessible. The class '" + string + "' must be public and have a 'public static void " + string2 + "(String[])' method. (LAX)";
                this.originalSTDERR.println(string4);
                this.showExceptionDialog(generalAppErrorString, string4, true);
                System.exit(-1);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.theException = invocationTargetException.getTargetException();
                string4 = "Invocation of this Java Application has caused an InvocationTargetException. This application will now exit. (LAX)";
                this.originalSTDERR.println(string4);
                this.originalSTDERR.println("\nStack Trace:");
                invocationTargetException.getTargetException().printStackTrace(this.originalSTDERR);
                this.showExceptionDialog(generalAppFailureString, string4, true);
                System.exit(-1);
            }
            catch (NullPointerException nullPointerException) {
                this.theException = nullPointerException;
                string4 = "This Java Application has encountered a NullPointerException and will now exit. (LAX)";
                this.originalSTDERR.println(string4);
                this.originalSTDERR.println("\nStack Trace:");
                nullPointerException.printStackTrace(this.originalSTDERR);
                this.showExceptionDialog(generalAppFailureString, string4, true);
                System.exit(-1);
            }
        }
        catch (ThreadDeath threadDeath) {
            System.exit(-1);
        }
        catch (Exception exception) {
            this.theException = exception;
            string4 = "This Java Application has encountered an unexpected exception and will now exit. (LAX)";
            this.originalSTDERR.println(string4);
            this.originalSTDERR.println("\nStack Trace:");
            exception.printStackTrace(this.originalSTDERR);
            this.showExceptionDialog(generalAppFailureString, string4, true);
            System.exit(-1);
        }
        catch (Throwable throwable) {
            this.theException = throwable;
            string4 = "This Java Application has encountered an unexpected error and will now exit. (LAX)";
            this.originalSTDERR.println(string4);
            this.originalSTDERR.println("\nStack Trace:");
            throwable.printStackTrace(this.originalSTDERR);
            this.showExceptionDialog(generalAppFailureString, string4, true);
            System.exit(-1);
        }
    }

    private boolean verifyProperty(String string, String string2) {
        if (System.getProperty(string) == null) {
            String string3 = "The properties files is missing an essential property: " + string + ". Please make sure it exists in the properties file: " + string2;
            this.originalSTDERR.println(string3);
            this.showExceptionDialog(generalAppErrorString, string3, false);
            return false;
        }
        return true;
    }

    private String[] parseArgs(String string) {
        int n;
        Object object;
        if (string == null || string.length() <= 0) {
            return new String[0];
        }
        LAXQuotedStreamTokenizer lAXQuotedStreamTokenizer = new LAXQuotedStreamTokenizer(new StringReader(string));
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            while ((string2 = lAXQuotedStreamTokenizer.getNextToken()) != null) {
                if (lAXQuotedStreamTokenizer.getType() == -10) {
                    vector.addElement(string2);
                    continue;
                }
                if (lAXQuotedStreamTokenizer.getType() == -11) {
                    vector.addElement(string2);
                    continue;
                }
                if (lAXQuotedStreamTokenizer.getType() != -12) continue;
                vector.addElement(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.originalSTDERR);
        }
        if (vector.size() <= 0) {
            return new String[0];
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            object = vector.elementAt(n2);
            if (((String)object).equals("$CMD_LINE_ARGUMENTS$")) {
                n = this.nativeArgs.length - 1;
                while (n > 1) {
                    vector.insertElementAt(this.nativeArgs[n], n2);
                    --n;
                }
                vector.removeElement(object);
            }
            ++n2;
        }
        object = new String[vector.size()];
        n = 0;
        while (n < vector.size()) {
            object[n] = (String)vector.elementAt(n);
            ++n;
        }
        return object;
    }

    private void showExceptionDialog(String string, String string2, boolean bl) {
        try {
            ZGStandardDialog zGStandardDialog = new ZGStandardDialog(alertDialogTitle, string, string2);
            zGStandardDialog.setDetailsButtonVisible(bl);
            zGStandardDialog.setCancelButtonVisible(false);
            ((Component)zGStandardDialog).setVisible(true);
            if (zGStandardDialog.getLastButtonPressed() == 3) {
                ei ei2 = new ei(this.theException);
                ((Component)ei2).setVisible(true);
            }
        }
        catch (Throwable throwable) {
            this.originalSTDERR.println("GUI-");
            System.err.println();
            throwable.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        Toolkit toolkit = null;
        try {
            toolkit = Toolkit.getDefaultToolkit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            LAX lAX = new LAX(stringArray);
            lAX.launch();
        }
        catch (Throwable throwable) {
            String string = "An internal LaunchAnywhere application error has occured and this application cannot proceed. (LAX)";
            System.err.println(string);
            System.err.println("\nStack Trace:");
            throwable.printStackTrace(System.err);
            System.exit(-1);
        }
    }
}

