/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.CenterLayout;

public class BasicColorChooserUI
extends ColorChooserUI {
    JColorChooser chooser;
    JTabbedPane tabbedPane;
    JPanel singlePanel;
    JPanel previewPanelHolder;
    JComponent previewPanel;
    boolean isMultiPanel = false;
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = ColorChooserComponentFactory.getDefaultChooserPanels();
        return abstractColorChooserPanelArray;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicColorChooserUI();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = new PreviewListener();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    protected void installPreviewPanel() {
        this.previewPanelHolder = new JPanel(new CenterLayout());
        String string = UIManager.getString("ColorChooser.previewText");
        this.previewPanelHolder.setBorder(new TitledBorder(string));
        this.previewPanel = this.chooser.getPreviewPanel();
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = ColorChooserComponentFactory.getPreviewPanel();
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.previewPanelHolder.add(this.previewPanel);
        this.chooser.add((Component)this.previewPanelHolder, "South");
    }

    public void installUI(JComponent jComponent) {
        this.chooser = (JColorChooser)jComponent;
        super.installUI(jComponent);
        this.installDefaults();
        this.installListeners();
        this.tabbedPane = new JTabbedPane();
        this.singlePanel = new JPanel(new CenterLayout());
        this.chooser.setLayout(new BorderLayout());
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.installPreviewPanel();
    }

    protected void uninstallDefaultChoosers() {
        int n = 0;
        while (n < this.defaultChoosers.length) {
            this.chooser.removeChooserPanel(this.defaultChoosers[n]);
            ++n;
        }
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaultChoosers();
        this.uninstallDefaults();
        this.defaultChoosers = null;
        this.chooser = null;
        this.tabbedPane = null;
    }

    class PreviewListener
    implements ChangeListener {
        PreviewListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ColorSelectionModel colorSelectionModel = (ColorSelectionModel)changeEvent.getSource();
            if (BasicColorChooserUI.this.previewPanel != null) {
                BasicColorChooserUI.this.previewPanel.setForeground(colorSelectionModel.getSelectedColor());
                BasicColorChooserUI.this.previewPanel.repaint();
            }
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            Object object2;
            if (propertyChangeEvent.getPropertyName().equals("chooserPanels")) {
                Container container;
                object2 = (AbstractColorChooserPanel[])propertyChangeEvent.getOldValue();
                object = (AbstractColorChooserPanel[])propertyChangeEvent.getNewValue();
                int n = 0;
                while (n < ((AbstractColorChooserPanel[])object2).length) {
                    Container container2 = object2[n].getParent();
                    if (container2 != null) {
                        container = container2.getParent();
                        if (container != null) {
                            container.remove(container2);
                        }
                        object2[n].uninstallChooserPanel(BasicColorChooserUI.this.chooser);
                    }
                    ++n;
                }
                int n2 = ((AbstractColorChooserPanel[])object).length;
                if (n2 == 0) {
                    BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.tabbedPane);
                    return;
                }
                if (n2 == 1) {
                    BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.tabbedPane);
                    container = new JPanel(new CenterLayout());
                    container.add(object[0]);
                    BasicColorChooserUI.this.singlePanel.add((Component)container, "Center");
                    BasicColorChooserUI.this.chooser.add(BasicColorChooserUI.this.singlePanel);
                } else {
                    if (((AbstractColorChooserPanel[])object2).length < 2) {
                        BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.singlePanel);
                        BasicColorChooserUI.this.tabbedPane = new JTabbedPane();
                        BasicColorChooserUI.this.chooser.add((Component)BasicColorChooserUI.this.tabbedPane, "Center");
                    }
                    int n3 = 0;
                    while (n3 < ((AbstractColorChooserPanel[])object).length) {
                        JPanel jPanel = new JPanel(new CenterLayout());
                        jPanel.add(object[n3]);
                        BasicColorChooserUI.this.tabbedPane.addTab(object[n3].getDisplayName(), jPanel);
                        ++n3;
                    }
                }
                int n4 = 0;
                while (n4 < ((AbstractColorChooserPanel[])object).length) {
                    object[n4].installChooserPanel(BasicColorChooserUI.this.chooser);
                    ++n4;
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("previewPanel")) {
                object2 = (JComponent)propertyChangeEvent.getOldValue();
                object = (JComponent)propertyChangeEvent.getNewValue();
                if (object2 != null) {
                    BasicColorChooserUI.this.chooser.remove((Component)object2);
                }
                BasicColorChooserUI.this.chooser.add((Component)object, "South");
            }
        }
    }
}

