/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.chat.ChatManager;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Vector;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class Acceptor
extends Thread {
    private volatile ServerSocket _socket = null;
    private int _port = 0;
    private Object _socketLock = new Object();
    private static byte[] _address = new byte[4];
    private Vector _badHosts = new Vector();
    private ConnectionManager _connectionManager;
    private DownloadManager _downloadManager;
    private UploadManager _uploadManager;
    private MessageRouter _router;
    private ActivityCallback _callback;
    private volatile boolean _acceptedIncoming = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$Acceptor;

    public static synchronized void setAddress(byte[] addr) {
        if (addr[0] == 127 && addr[1] == 0 && addr[2] == 0 && addr[3] == 1) {
            return;
        }
        _address = addr;
    }

    public Acceptor(int port, ActivityCallback callback) {
        this._port = port;
        this._callback = callback;
        String[] allHosts = SettingsManager.instance().getBannedIps();
        int i = 0;
        while (i < allHosts.length) {
            this._badHosts.add((Object)allHosts[i]);
            ++i;
        }
    }

    public void initialize(ConnectionManager connectionManager, MessageRouter router, DownloadManager downloadManager, UploadManager uploadManager) {
        this._connectionManager = connectionManager;
        this._router = router;
        this._downloadManager = downloadManager;
        this._uploadManager = uploadManager;
        this.setDaemon(true);
        this.start();
    }

    public byte[] getAddress() {
        if (SettingsManager.instance().getForceIPAddress()) {
            return SettingsManager.instance().getForcedIPAddress();
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            byte[] byArray = _address;
            return byArray;
        }
    }

    public int getPort() {
        if (SettingsManager.instance().getForceIPAddress()) {
            return SettingsManager.instance().getForcedPort();
        }
        return this._port;
    }

    public void setListeningPort(int port) throws IOException {
        if (this._socket != null && this._port == port) {
            return;
        }
        if (port == 0) {
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            Object e = this._socketLock;
            synchronized (e) {
                this._socket = null;
                this._port = 0;
                this._socketLock.notify();
            }
            return;
        }
        ServerSocket newSocket = null;
        try {
            newSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new IOException();
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object = this._socketLock;
        synchronized (object) {
            this._socket = newSocket;
            this._port = port;
            this._socketLock.notify();
        }
    }

    public boolean acceptedIncoming() {
        return this._acceptedIncoming;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block23: {
            try {
                Acceptor.setAddress(InetAddress.getLocalHost().getAddress());
            }
            catch (UnknownHostException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
            oldPort = this._port;
            try {
                this.setListeningPort(this._port);
                break block23;
            }
            catch (IOException e) {
                i = 0;
                ** while (i < 10)
            }
lbl-1000:
            // 1 sources

            {
                this._port = i + 6346;
                try {
                    this.setListeningPort(this._port);
                    break;
                }
                catch (IOException e2) {
                    ++i;
                }
                continue;
            }
lbl22:
            // 2 sources

            if (this._socket == null) {
                this._callback.error(0);
            }
        }
        if (this._port != oldPort) {
            SettingsManager.instance().setPort(this._port);
        }
        while (true) {
            try {
                while (true) {
                    client = null;
                    i = this._socketLock;
                    synchronized (i) {
                        if (this._socket != null) {
                            try {
                                client = this._socket.accept();
                            }
                            catch (IOException e) {
                                continue;
                            }
                        }
                        try {
                            this._socketLock.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                    if (!this.isBannedIP(client.getInetAddress().getHostAddress())) break;
                    client.close();
                }
                this._acceptedIncoming = true;
                SettingsManager.instance().setAcceptedIncoming(this._acceptedIncoming);
                new ConnectionDispatchRunner(client);
                continue;
            }
            catch (SecurityException e) {
                this._callback.error(1);
                return;
            }
            catch (Exception e) {
                this._callback.error(2, e);
                continue;
            }
            break;
        }
    }

    private static String readWord(InputStream sock) throws IOException {
        int N = 9;
        char[] buf = new char[9];
        int i = 0;
        while (i < 9) {
            int got = sock.read();
            if (got == -1) {
                throw new IOException();
            }
            if ((char)got == ' ') {
                return new String(buf, 0, i);
            }
            buf[i] = (char)got;
            ++i;
        }
        throw new IOException();
    }

    public void refreshBannedIPs() {
        int i;
        Vector vector = this._badHosts;
        synchronized (vector) {
            this._badHosts.removeAllElements();
            String[] allHosts = SettingsManager.instance().getBannedIps();
            i = 0;
            while (i < allHosts.length) {
                this._badHosts.add((Object)allHosts[i]);
                ++i;
            }
        }
        List connections = this._connectionManager.getConnections();
        i = 0;
        while (i < connections.size()) {
            ManagedConnection curr = (ManagedConnection)connections.get(i);
            if (this.isBannedIP(curr.getOrigHost())) {
                this._connectionManager.remove(curr);
            }
            ++i;
        }
    }

    public boolean isBannedIP(String ip) {
        return this._badHosts.contains((Object)ip);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConnectionDispatchRunner
    extends Thread {
        private Socket _socket;

        public ConnectionDispatchRunner(Socket socket) {
            super("ConnectionDispatchRunner");
            this._socket = socket;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            block11: {
                try {
                    InputStream in = null;
                    try {
                        in = this._socket.getInputStream();
                    }
                    catch (Exception e) {
                        throw new IOException();
                    }
                    this._socket.setSoTimeout(SettingsManager.instance().getTimeout());
                    String word = Acceptor.readWord(in);
                    this._socket.setSoTimeout(0);
                    boolean useDefaultConnect = SettingsManager.instance().getConnectString().equals("GNUTELLA CONNECT/0.4");
                    if (word.equals(SettingsManager.instance().getConnectStringFirstWord())) {
                        Acceptor.this._connectionManager.acceptConnection(this._socket);
                        break block11;
                    }
                    if (useDefaultConnect && word.equals("LIMEWIRE")) {
                        Acceptor.this._connectionManager.acceptConnection(this._socket);
                        break block11;
                    }
                    if (word.equals("GET")) {
                        Acceptor.this._uploadManager.acceptUpload(this._socket);
                        break block11;
                    }
                    if (word.equals("GIV")) {
                        Acceptor.this._downloadManager.acceptDownload(this._socket);
                        break block11;
                    }
                    if (word.equals("CHAT")) {
                        ChatManager.instance().accept(this._socket);
                        break block11;
                    }
                    throw new IOException();
                }
                catch (IOException e) {
                    try {
                        this._socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

