/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.HandshakeResponder;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.SettingsManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Connection {
    private String _host;
    private int _port;
    private Socket _socket;
    private InputStream _in;
    private OutputStream _out;
    private boolean _outgoing;
    private volatile boolean _closed = false;
    private Properties _propertiesRead;
    private Properties _propertiesWrittenP;
    private HandshakeResponder _propertiesWrittenR;
    private boolean _negotiate = false;
    public static final String GNUTELLA_CONNECT_04 = "GNUTELLA CONNECT/0.4";
    public static final String GNUTELLA_OK_04 = "GNUTELLA OK";
    public static final String GNUTELLA_CONNECT_06 = "GNUTELLA CONNECT/0.6";
    public static final String GNUTELLA_OK_06 = "GNUTELLA/0.6 200 OK";
    public static final String CONNECT = "CONNECT/";
    public static final String CRLF = "\r\n";
    public static final String LF = "\n";
    private byte[] HEADER_BUF = new byte[23];

    public Connection(String host, int port) {
        this(host, port, null, null, false);
    }

    public Connection(String host, int port, Properties properties1, HandshakeResponder properties2, boolean negotiate) {
        this._host = host;
        this._port = port;
        this._outgoing = true;
        this._negotiate = negotiate;
        this._propertiesWrittenP = properties1;
        this._propertiesWrittenR = properties2;
    }

    public Connection(Socket socket) {
        this(socket, null);
    }

    public Connection(Socket socket, HandshakeResponder properties) {
        this._host = socket.getInetAddress().getHostAddress();
        this._port = socket.getPort();
        this._socket = socket;
        this._outgoing = false;
        this._propertiesWrittenR = properties;
    }

    public void initialize() throws IOException {
        try {
            this.initializeWithoutRetry();
        }
        catch (BadHandshakeException e) {
            if (this._negotiate && this.isOutgoing() && this._propertiesWrittenP != null && this._propertiesWrittenR != null) {
                this._propertiesWrittenP = null;
                this._propertiesWrittenR = null;
                this.initializeWithoutRetry();
            }
            throw e;
        }
    }

    private void initializeWithoutRetry() throws IOException {
        SettingsManager settingsManager = SettingsManager.instance();
        if (this.isOutgoing()) {
            this._socket = new Socket(this._host, this._port);
        }
        if (this._closed) {
            this._socket.close();
            throw new IOException();
        }
        try {
            Acceptor.setAddress(this._socket.getLocalAddress().getAddress());
            this._in = new BufferedInputStream(this._socket.getInputStream());
            this._out = new BufferedOutputStream(this._socket.getOutputStream());
            if (this._in == null || this._out == null) {
                throw new IOException();
            }
        }
        catch (Exception e) {
            throw new IOException();
        }
        try {
            if (this.isOutgoing()) {
                this.initializeOutgoing();
            } else {
                this.initializeIncoming();
            }
        }
        catch (IOException e) {
            this._socket.close();
            throw new BadHandshakeException();
        }
    }

    private void initializeOutgoing() throws IOException {
        if (this._propertiesWrittenP == null || this._propertiesWrittenR == null) {
            this.sendString("GNUTELLA CONNECT/0.4\n\n");
            if (!this.readLine().equals(GNUTELLA_OK_04)) {
                throw new IOException("Bad connect string");
            }
            if (!this.readLine().equals("")) {
                throw new IOException("Bad connect string");
            }
        } else {
            this.sendString("GNUTELLA CONNECT/0.6\r\n");
            this.sendHeaders(this._propertiesWrittenP);
            if (!this.readLine().equals(GNUTELLA_OK_06)) {
                throw new IOException("Bad connect string");
            }
            this._propertiesRead = new Properties();
            this.readHeaders();
            this.sendString("GNUTELLA/0.6 200 OK\r\n");
            this.sendHeaders(this._propertiesWrittenR.respond(this._propertiesRead));
        }
    }

    private void initializeIncoming() throws IOException {
        String line = this.readLine();
        if (GNUTELLA_CONNECT_04.endsWith(line)) {
            if (!this.readLine().equals("")) {
                throw new IOException("Bad connect string");
            }
            this.sendString("GNUTELLA OK\n\n");
            this._propertiesWrittenP = null;
            this._propertiesWrittenR = null;
        } else if (Connection.notLessThan06(line)) {
            this._propertiesRead = new Properties();
            this.readHeaders();
            this.sendString("GNUTELLA/0.6 200 OK\r\n");
            if (this._propertiesWrittenR == null) {
                this.sendString(CRLF);
            } else {
                this.sendHeaders(this._propertiesWrittenR.respond(this._propertiesRead));
            }
            if (!this.readLine().equals(GNUTELLA_OK_06)) {
                throw new IOException("Bad connect string");
            }
            this.readHeaders();
        } else {
            throw new IOException("Unexpected connect string");
        }
    }

    private static boolean notLessThan06(String line) {
        int i = line.indexOf(CONNECT);
        if (i < 0) {
            return false;
        }
        try {
            Float F = new Float(line.substring(i + CONNECT.length()));
            float f = F.floatValue();
            return f >= 0.6f;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void sendHeaders(Properties props) throws IOException {
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = props.getProperty(key);
            if (value == null) {
                value = "";
            }
            this.sendString(key + ": " + value + CRLF);
        }
        this.sendString(CRLF);
    }

    private void readHeaders() throws IOException {
        while (true) {
            String line;
            if ((line = this.readLine()) == null) {
                throw new IOException();
            }
            if (line.equals("")) {
                return;
            }
            int i = line.indexOf(58);
            if (i < 0) continue;
            String key = line.substring(0, i);
            String value = line.substring(i + 1).trim();
            ((Hashtable)this._propertiesRead).put(key, value);
        }
    }

    private void sendString(String s) throws IOException {
        byte[] bytes = s.getBytes();
        this._out.write(bytes);
        this._out.flush();
    }

    private String readLine() throws IOException {
        String string;
        int oldTimeout = this._socket.getSoTimeout();
        try {
            this._socket.setSoTimeout(SettingsManager.instance().getTimeout());
            String line = new ByteReader(this._in).readLine();
            if (line == null) {
                throw new IOException();
            }
            string = line;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._socket.setSoTimeout(oldTimeout);
            throw throwable;
        }
        this._socket.setSoTimeout(oldTimeout);
        return string;
    }

    public boolean isOutgoing() {
        return this._outgoing;
    }

    public Message receive() throws IOException, BadPacketException {
        if (this._closed) {
            throw new IOException();
        }
        Message m = null;
        while (m == null) {
            m = Message.read(this._in, this.HEADER_BUF);
        }
        return m;
    }

    public Message receive(int timeout) throws IOException, BadPacketException, InterruptedIOException {
        Message message;
        if (this._closed) {
            throw new IOException();
        }
        int oldTimeout = this._socket.getSoTimeout();
        this._socket.setSoTimeout(timeout);
        try {
            Message m = Message.read(this._in);
            if (m == null) {
                throw new InterruptedIOException();
            }
            message = m;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._socket.setSoTimeout(oldTimeout);
            throw throwable;
        }
        this._socket.setSoTimeout(oldTimeout);
        return message;
    }

    public void send(Message m) throws IOException {
        m.write(this._out);
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    public String getOrigHost() {
        return this._host;
    }

    public int getOrigPort() {
        return this._port;
    }

    public int getPort() {
        return this._socket.getPort();
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this._socket.getLocalAddress();
    }

    public String getProperty(String name) {
        if (this._propertiesRead == null) {
            return null;
        }
        return this._propertiesRead.getProperty(name);
    }

    public boolean isOpen() {
        return !this._closed;
    }

    public void close() {
        this._closed = true;
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "host=" + this._host + " port=" + this._port;
    }

    private static class BadHandshakeException
    extends IOException {
        private BadHandshakeException() {
        }
    }
}

