/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionWatchdog;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GroupPingRequest;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.RejectConnection;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.net.Socket;

public class ConnectionManager {
    private volatile List _initializedConnections = new ArrayList();
    private volatile List _connections = new ArrayList();
    private volatile Set _endpoints = new HashSet();
    private List _fetchers = new ArrayList();
    private List _initializingFetchedConnections = new ArrayList();
    private volatile int _keepAlive = 0;
    private volatile int _incomingConnections = 0;
    private Object _incomingConnectionsLock = new Object();
    private MessageRouter _router;
    private HostCatcher _catcher;
    private ActivityCallback _callback;
    private SettingsManager _settings;
    private ConnectionWatchdog _watchdog;
    private Runnable _ultraFastCheck;

    public ConnectionManager(ActivityCallback callback) {
        this._callback = callback;
        this._settings = SettingsManager.instance();
    }

    public void initialize(MessageRouter router, HostCatcher catcher) {
        this._router = router;
        this._catcher = catcher;
        this._watchdog = new ConnectionWatchdog(this, this._router);
        Thread watchdog = new Thread(this._watchdog);
        watchdog.setDaemon(true);
        watchdog.start();
        this.setKeepAlive(this._settings.getKeepAlive());
    }

    public ManagedConnection createConnectionBlocking(String hostname, int portnum) throws IOException {
        ManagedConnection c = new ManagedConnection(hostname, portnum, this._router, this);
        this.initializeExternallyGeneratedConnection(c);
        new OutgoingConnectionThread(c, false);
        return c;
    }

    public void createConnectionAsynchronously(String hostname, int portnum) {
        new OutgoingConnectionThread(new ManagedConnection(hostname, portnum, this._router, this), true);
    }

    public ManagedConnection createRouterConnection(String hostname, int portnum) throws IOException {
        if (hostname.equals("router.limewire.com")) {
            hostname = SettingsManager.DEDICATED_LIMEWIRE_ROUTER;
        }
        ManagedConnection c = new ManagedConnection(hostname, portnum, this._router, this, true);
        this.initializeExternallyGeneratedConnection(c);
        new OutgoingConnectionThread(c, false);
        return c;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void acceptConnection(Socket socket) {
        boolean allowConnection = false;
        Object object = this._incomingConnectionsLock;
        // MONITORENTER : object
        if (this._incomingConnections < this._keepAlive) {
            ++this._incomingConnections;
            allowConnection = true;
        }
        // MONITOREXIT : object
        if (allowConnection) {
            ManagedConnection connection = new ManagedConnection(socket, this._router, this);
            try {
                try {
                    this.initializeExternallyGeneratedConnection(connection);
                    this.sendInitialPingRequest(connection);
                    connection.loopForMessages();
                }
                catch (IOException e) {
                    Object var8_7 = null;
                    Object object2 = this._incomingConnectionsLock;
                    // MONITORENTER : object2
                    --this._incomingConnections;
                    // MONITOREXIT : object2
                    return;
                }
                catch (Exception e) {
                    this._callback.error(2, e);
                    Object var8_8 = null;
                    Object object4 = this._incomingConnectionsLock;
                    // MONITORENTER : object4
                    --this._incomingConnections;
                    // MONITOREXIT : object4
                    return;
                }
                Object var8_6 = null;
                Object object2 = this._incomingConnectionsLock;
                // MONITORENTER : object2
                --this._incomingConnections;
                // MONITOREXIT : object2
                return;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                Object object5 = this._incomingConnectionsLock;
                // MONITORENTER : object5
                --this._incomingConnections;
                // MONITOREXIT : object5
                throw throwable;
            }
        }
        if (!CommonUtils.isMacClassic()) {
            new RejectConnection(socket, this._catcher);
            return;
        }
        try {
            socket.close();
            return;
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public synchronized void remove(ManagedConnection c) {
        this.removeInternal(c);
        this.adjustConnectionFetchers();
    }

    public int getKeepAlive() {
        return this._keepAlive;
    }

    public synchronized void reduceConnections() {
        int newKeepAlive = Math.min(this._keepAlive, 2);
        this.setKeepAlive(newKeepAlive);
    }

    public synchronized void setKeepAlive(int newKeep) {
        this._keepAlive = newKeep;
        this.adjustConnectionFetchers();
    }

    public boolean isConnected(Endpoint host) {
        return this._endpoints.contains((Object)host);
    }

    public int getNumConnections() {
        return this._connections.size();
    }

    public int getNumInitializedConnections() {
        return this._initializedConnections.size();
    }

    public boolean hasAvailableIncoming() {
        return this._incomingConnections < this._keepAlive;
    }

    public List getInitializedConnections() {
        ArrayList clone = new ArrayList();
        clone.addAll((Collection)this._initializedConnections);
        return clone;
    }

    List getInitializedConnections2() {
        return this._initializedConnections;
    }

    public List getConnections() {
        ArrayList clone = new ArrayList((Collection)this._connections);
        return clone;
    }

    private void connectionInitializing(Connection c) {
        ArrayList newConnections = new ArrayList((Collection)this._connections);
        newConnections.add((Object)c);
        this._connections = newConnections;
    }

    private void connectionInitialized(Connection c) {
        if (this._connections.contains((Object)c)) {
            ArrayList newConnections = new ArrayList((Collection)this._initializedConnections);
            newConnections.add((Object)c);
            this._initializedConnections = newConnections;
            HashSet newEndpoints = new HashSet((Collection)this._endpoints);
            newEndpoints.add((Object)new Endpoint(c.getInetAddress().getHostAddress(), c.getPort()));
            this._endpoints = newEndpoints;
        }
        if (this._ultraFastCheck != null) {
            this._ultraFastCheck.run();
        }
    }

    public void activateUltraFastConnectShutdown() {
        this._ultraFastCheck = new AllowUltraFastConnect();
    }

    public void deactivateUltraFastConnectShutdown() {
        this._ultraFastCheck = null;
    }

    private void sendInitialPingRequest(ManagedConnection connection) {
        PingRequest pr = this.getNumInitializedConnections() >= this._keepAlive ? new PingRequest(1) : new PingRequest(SettingsManager.instance().getTTL());
        connection.send(pr);
        try {
            connection.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void removeInternal(ManagedConnection c) {
        ArrayList newConnections;
        int i = this._initializedConnections.indexOf((Object)c);
        if (i != -1) {
            newConnections = new ArrayList();
            newConnections.addAll((Collection)this._initializedConnections);
            newConnections.remove((Object)c);
            this._initializedConnections = newConnections;
            HashSet newEndpoints = new HashSet();
            newEndpoints.addAll((Collection)this._endpoints);
            newEndpoints.remove((Object)new Endpoint(c.getInetAddress().getHostAddress(), c.getPort()));
            this._endpoints = newEndpoints;
        }
        if ((i = this._connections.indexOf((Object)c)) != -1) {
            newConnections = new ArrayList((Collection)this._connections);
            newConnections.remove((Object)c);
            this._connections = newConnections;
        }
        c.close();
        this._router.removeConnection(c);
        this._callback.connectionClosed(c);
    }

    private void adjustConnectionFetchers() {
        int need = this._keepAlive - this.getNumConnections() - this._fetchers.size();
        while (need > 0) {
            new ConnectionFetcher();
            --need;
        }
        int lastFetcherIndex = this._fetchers.size();
        while (need < 0 && lastFetcherIndex > 0) {
            ConnectionFetcher fetcher = (ConnectionFetcher)this._fetchers.remove(--lastFetcherIndex);
            fetcher.interrupt();
            ++need;
        }
        int lastInitializingConnectionIndex = this._initializingFetchedConnections.size();
        while (need < 0 && lastInitializingConnectionIndex > 0) {
            ManagedConnection connection = (ManagedConnection)this._initializingFetchedConnections.remove(--lastInitializingConnectionIndex);
            this.removeInternal(connection);
            ++need;
        }
    }

    private void initializeFetchedConnection(ManagedConnection c, ConnectionFetcher fetcher) throws IOException {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (fetcher.isInterrupted()) {
                throw new IOException();
            }
            this._initializingFetchedConnections.add((Object)c);
            this._fetchers.remove((Object)fetcher);
            this.connectionInitializing(c);
        }
        this._callback.connectionInitializing(c);
        try {
            c.initialize();
        }
        catch (IOException e) {
            ConnectionManager connectionManager2 = this;
            synchronized (connectionManager2) {
                this._initializingFetchedConnections.remove((Object)c);
                this.removeInternal(c);
                this.adjustConnectionFetchers();
            }
            throw e;
        }
        boolean connectionOpen = false;
        ConnectionManager connectionManager3 = this;
        synchronized (connectionManager3) {
            this._initializingFetchedConnections.remove((Object)c);
            if (this._connections.contains((Object)c)) {
                this.connectionInitialized(c);
                connectionOpen = true;
            }
        }
        if (connectionOpen) {
            this._callback.connectionInitialized(c);
        }
    }

    private void initializeExternallyGeneratedConnection(ManagedConnection c) throws IOException {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this.connectionInitializing(c);
            this.adjustConnectionFetchers();
        }
        this._callback.connectionInitializing(c);
        try {
            c.initialize();
        }
        catch (IOException e) {
            this.remove(c);
            throw e;
        }
        boolean connectionOpen = false;
        ConnectionManager connectionManager2 = this;
        synchronized (connectionManager2) {
            if (this._connections.contains((Object)c)) {
                this.connectionInitialized(c);
                connectionOpen = true;
            }
        }
        if (connectionOpen) {
            this._callback.connectionInitialized(c);
        }
    }

    public ManagedConnection createGroupConnectionBlocking(String hostname, int portnum, GroupPingRequest specialPing) throws IOException {
        ManagedConnection c = new ManagedConnection(hostname, portnum, this._router, this, true);
        this.initializeExternallyGeneratedConnection(c);
        new GroupOutgoingConnectionThread(c, specialPing);
        return c;
    }

    private class ConnectionFetcher
    extends Thread {
        public ConnectionFetcher() {
            ConnectionManager.this._fetchers.add((Object)this);
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            Endpoint endpoint = null;
            do {
                try {
                    endpoint = ConnectionManager.this._catcher.getAnEndpoint();
                }
                catch (InterruptedException exc2) {
                    return;
                }
            } while (ConnectionManager.this.isConnected(endpoint));
            Assert.that(endpoint != null);
            ManagedConnection connection = new ManagedConnection(endpoint.getHostname(), endpoint.getPort(), ConnectionManager.this._router, ConnectionManager.this);
            try {
                ConnectionManager.this.initializeFetchedConnection(connection, this);
                ConnectionManager.this.sendInitialPingRequest(connection);
                connection.loopForMessages();
            }
            catch (IOException e) {
            }
            catch (Exception e) {
                ConnectionManager.this._callback.error(2, e);
            }
        }
    }

    private class GroupOutgoingConnectionThread
    extends Thread {
        private ManagedConnection _connection;
        private PingRequest _specialPing;

        public GroupOutgoingConnectionThread(ManagedConnection connection, PingRequest specialPing) {
            this._connection = connection;
            this._specialPing = specialPing;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                ConnectionManager.this._router.sendPingRequest(this._specialPing, this._connection);
                this._connection.loopForMessages();
            }
            catch (IOException e) {
            }
            catch (Exception e) {
                ConnectionManager.this._callback.error(2, e);
            }
        }
    }

    private class OutgoingConnectionThread
    extends Thread {
        private ManagedConnection _connection;
        private boolean _doInitialization;

        public OutgoingConnectionThread(ManagedConnection connection, boolean doInitialization) {
            this._connection = connection;
            this._doInitialization = doInitialization;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                String origHost;
                if (this._doInitialization) {
                    ConnectionManager.this.initializeExternallyGeneratedConnection(this._connection);
                }
                if ((origHost = this._connection.getOrigHost()) != null && origHost.equals(SettingsManager.DEDICATED_LIMEWIRE_ROUTER)) {
                    String group = "none:" + ConnectionManager.this._settings.getConnectionSpeed();
                    GroupPingRequest pingRequest = ConnectionManager.this._router.createGroupPingRequest(group);
                    this._connection.send(pingRequest);
                    try {
                        this._connection.flush();
                    }
                    catch (IOException e) {}
                } else {
                    ConnectionManager.this.sendInitialPingRequest(this._connection);
                }
                this._connection.loopForMessages();
            }
            catch (IOException e) {
            }
            catch (Exception e) {
                ConnectionManager.this._callback.error(2, e);
            }
        }
    }

    private class AllowUltraFastConnect
    implements Runnable {
        private AllowUltraFastConnect() {
        }

        public void run() {
            SettingsManager settings = SettingsManager.instance();
            int outgoing = settings.getKeepAlive();
            int desired = Math.min(outgoing, 3);
            Iterator iter = ConnectionManager.this.getConnections().iterator();
            while (iter.hasNext()) {
                ManagedConnection c = (ManagedConnection)iter.next();
                if (c.getNumMessagesReceived() < 4) continue;
                --desired;
            }
            if (desired <= 0) {
                ConnectionManager.this.setKeepAlive(outgoing);
                ConnectionManager.this.deactivateUltraFastConnectShutdown();
            }
        }
    }
}

