/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PingRequest;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;

public class ConnectionWatchdog
implements Runnable {
    private static final int EVALUATE_TIME = 10000;
    private static final int REEVALUATE_TIME = 2000;
    private ConnectionManager manager;
    private MessageRouter router;

    public ConnectionWatchdog(ConnectionManager manager, MessageRouter router) {
        this.manager = manager;
        this.router = router;
    }

    private List findDuds() {
        HashMap snapshot = new HashMap();
        Iterator iter = this.manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            if (!c.isKillable()) continue;
            snapshot.put((Object)c, (Object)new ConnectionState(c));
        }
        try {
            Thread.currentThread();
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ArrayList ret = new ArrayList();
        Iterator iter2 = this.manager.getInitializedConnections().iterator();
        while (iter2.hasNext()) {
            ConnectionState oldState;
            ConnectionState currentState;
            Object state;
            ManagedConnection c = (ManagedConnection)iter2.next();
            if (!c.isKillable() || (state = snapshot.get((Object)c)) == null || !(currentState = new ConnectionState(c)).notProgressedSince(oldState = (ConnectionState)state)) continue;
            ret.add((Object)c);
        }
        return ret;
    }

    private void killIfStillDud(List connections) {
        HashMap snapshot = new HashMap();
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            if (!c.isKillable()) continue;
            snapshot.put((Object)c, (Object)new ConnectionState(c));
            c.setHorizonEnabled(false);
            this.router.sendPingRequest(new PingRequest(2), c);
        }
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Iterator iter2 = connections.iterator();
        while (iter2.hasNext()) {
            ConnectionState oldState;
            ConnectionState currentState;
            ManagedConnection c = (ManagedConnection)iter2.next();
            if (!c.isKillable()) continue;
            c.setHorizonEnabled(true);
            Object state = snapshot.get((Object)c);
            if (state == null || !(currentState = new ConnectionState(c)).notProgressedSince(oldState = (ConnectionState)state)) continue;
            this.manager.remove(c);
        }
    }

    public void run() {
        while (true) {
            List duds;
            if ((duds = this.findDuds()).size() <= 0) {
                continue;
            }
            this.killIfStillDud(duds);
        }
    }

    private static class ConnectionState {
        long sentDropped;
        long sent;
        long received;

        ConnectionState(ManagedConnection c) {
            this.sentDropped = c.getNumSentMessagesDropped();
            this.sent = c.getNumMessagesSent();
            this.received = c.getNumMessagesReceived();
        }

        boolean notProgressedSince(ConnectionState old) {
            long numSent = this.sent - old.sent;
            long numSentDropped = this.sentDropped - old.sentDropped;
            long numReceived = this.received - old.received;
            if (numSent == numSentDropped && numSent != 0L) {
                return true;
            }
            return numReceived == 0L;
        }

        public String toString() {
            return "{sent: " + this.sent + ", sdropped: " + this.sentDropped + "}";
        }
    }
}

