/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class DownloadManager {
    private ActivityCallback callback;
    private MessageRouter router;
    private Acceptor acceptor;
    private FileManager fileManager;
    private List active = new LinkedList();
    private List waiting = new LinkedList();

    public void initialize(ActivityCallback callback, MessageRouter router, Acceptor acceptor, FileManager fileManager) {
        this.callback = callback;
        this.router = router;
        this.acceptor = acceptor;
        this.fileManager = fileManager;
    }

    private synchronized boolean writeSnapshot() {
        ArrayList buf = new ArrayList();
        buf.addAll((Collection)this.active);
        buf.addAll((Collection)this.waiting);
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(SettingsManager.instance().getDownloadSnapshotFile()));
            out.writeObject(buf);
            out.flush();
            out.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean readSnapshot() {
        List buf = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(SettingsManager.instance().getDownloadSnapshotFile()));
            buf = (List)in.readObject();
        }
        catch (IOException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        try {
            Iterator iter = buf.iterator();
            while (iter.hasNext()) {
                ManagedDownloader downloader = (ManagedDownloader)iter.next();
                this.waiting.add((Object)downloader);
                downloader.initialize(this);
                this.callback.addDownload(downloader);
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public synchronized Downloader getFiles(RemoteFileDesc[] files, boolean overwrite) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        String conflict = this.conflicts(files, null);
        if (conflict != null) {
            throw new AlreadyDownloadingException(conflict);
        }
        if (!overwrite) {
            File downloadDir = SettingsManager.instance().getSaveDirectory();
            int i = 0;
            while (i < files.length) {
                String filename = files[i].getFileName();
                File completeFile = new File(downloadDir, filename);
                if (completeFile.exists()) {
                    throw new FileExistsException(filename);
                }
                ++i;
            }
        }
        ManagedDownloader downloader = new ManagedDownloader(this, files);
        this.waiting.add((Object)downloader);
        this.callback.addDownload(downloader);
        this.writeSnapshot();
        return downloader;
    }

    public synchronized String conflicts(RemoteFileDesc[] files, ManagedDownloader dloader) {
        int i = 0;
        while (i < files.length) {
            Iterator iter = this.active.iterator();
            while (iter.hasNext()) {
                ManagedDownloader md = (ManagedDownloader)iter.next();
                if (dloader != null && md == dloader || !md.conflicts(files[i])) continue;
                return files[i].getFileName();
            }
            Iterator iter2 = this.waiting.iterator();
            while (iter2.hasNext()) {
                ManagedDownloader md = (ManagedDownloader)iter2.next();
                if (dloader != null && md == dloader || !md.conflicts(files[i])) continue;
                return files[i].getFileName();
            }
            ++i;
        }
        return null;
    }

    public void acceptDownload(Socket socket) {
        try {
            GIVLine line = DownloadManager.parseGIV(socket);
            String file = line.file;
            int index = line.index;
            byte[] clientGUID = line.clientGUID;
            DownloadManager downloadManager = this;
            synchronized (downloadManager) {
                Iterator iter = this.active.iterator();
                while (iter.hasNext()) {
                    ManagedDownloader md = (ManagedDownloader)iter.next();
                    if (!md.acceptDownload(file, socket, index, clientGUID)) continue;
                    return;
                }
                Iterator iter2 = this.waiting.iterator();
                while (iter2.hasNext()) {
                    ManagedDownloader md = (ManagedDownloader)iter2.next();
                    if (!md.acceptDownload(file, socket, index, clientGUID)) continue;
                    return;
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean hasFreeSlot() {
        SettingsManager settings = SettingsManager.instance();
        return this.active.size() < settings.getMaxSimDownload();
    }

    public synchronized void waitForSlot(ManagedDownloader downloader) throws InterruptedException {
        while (!this.hasFreeSlot()) {
            this.wait();
        }
        this.waiting.remove((Object)downloader);
        this.active.add((Object)downloader);
    }

    public synchronized void yieldSlot(ManagedDownloader downloader) {
        Assert.that(downloader != null, "Null downloader");
        Assert.that(this.active != null, "Null active");
        Assert.that(this.waiting != null, "Null waiting");
        this.active.remove((Object)downloader);
        this.waiting.add((Object)downloader);
        this.notify();
    }

    public synchronized void remove(ManagedDownloader downloader, boolean success) {
        this.active.remove((Object)downloader);
        this.waiting.remove((Object)downloader);
        this.notify();
        this.callback.removeDownload(downloader);
        this.writeSnapshot();
    }

    public boolean sendPush(RemoteFileDesc file) {
        PushRequest pr = new PushRequest(GUID.makeGuid(), SettingsManager.instance().getTTL(), file.getClientGUID(), file.getIndex(), this.acceptor.getAddress(), this.acceptor.getPort());
        try {
            this.router.sendPushRequest(pr);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static GIVLine parseGIV(Socket s) throws IOException {
        s.setSoTimeout(SettingsManager.instance().getTimeout());
        InputStream istream = null;
        try {
            istream = s.getInputStream();
        }
        catch (Exception e) {
            throw new IOException();
        }
        ByteReader br = new ByteReader(istream);
        String command = br.readLine();
        if (command == null) {
            throw new IOException();
        }
        String next = br.readLine();
        if (next == null || !next.equals("")) {
            throw new IOException();
        }
        try {
            int i = command.indexOf(":");
            int index = Integer.parseInt(command.substring(0, i));
            int j = command.indexOf("/", i);
            byte[] guid = GUID.fromHexString(command.substring(i + 1, j));
            String filename = command.substring(j + 1);
            return new GIVLine(filename, index, guid);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException();
        }
        catch (NumberFormatException e) {
            throw new IOException();
        }
        catch (IllegalArgumentException e) {
            throw new IOException();
        }
    }

    private static class GIVLine {
        String file;
        int index;
        byte[] clientGUID;

        GIVLine(String file, int index, byte[] clientGUID) {
            this.clientGUID = clientGUID;
            this.file = file;
            this.index = index;
            this.clientGUID = clientGUID;
        }
    }
}

