/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import com.sun.java.util.collections.Comparable;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Endpoint
implements Cloneable,
Serializable,
Comparable {
    static final long serialVersionUID = 4686711693494625070L;
    private String hostname = null;
    int port = 0;
    private long files = -1L;
    private long kbytes = -1L;
    private byte[] hostBytes = null;
    public transient boolean processed = false;
    private int connectivity = 0;
    private transient int weight = 0;

    public void setConnectivity(int connectivity) {
        this.connectivity = connectivity;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getConnectivity() {
        return this.connectivity;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new ClassCastException();
        }
        Endpoint other = (Endpoint)o;
        if (this.weight > other.weight) {
            return 1;
        }
        if (this.weight < other.weight) {
            return -1;
        }
        return 0;
    }

    public Endpoint(String hostAndPort) throws IllegalArgumentException {
        int DEFAULT = 6346;
        int j = hostAndPort.indexOf(":");
        if (j < 0) {
            this.hostname = hostAndPort;
            this.port = 6346;
        } else {
            if (j == 0) {
                throw new IllegalArgumentException();
            }
            if (j == hostAndPort.length() - 1) {
                this.hostname = hostAndPort.substring(0, j);
                this.port = 6346;
            } else {
                this.hostname = hostAndPort.substring(0, j);
                try {
                    this.port = Integer.parseInt(hostAndPort.substring(j + 1));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    public Endpoint(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public Endpoint(byte[] hostBytes, int port) {
        this.hostBytes = hostBytes;
        this.port = port;
        this.hostname = Message.ip2string(hostBytes);
    }

    public Endpoint(String hostname, int port, long files, long kbytes) {
        this(hostname, port);
        this.files = files;
        this.kbytes = kbytes;
    }

    public Endpoint(byte[] hostBytes, int port, long files, long kbytes) {
        this(hostBytes, port);
        this.files = files;
        this.kbytes = kbytes;
    }

    public Endpoint(Endpoint ep) {
        this.connectivity = ep.connectivity;
        this.files = ep.files;
        this.hostname = ep.hostname;
        this.hostBytes = ep.hostBytes;
        this.kbytes = ep.kbytes;
        this.port = ep.port;
        this.processed = ep.processed;
        this.weight = ep.weight;
    }

    public String toString() {
        return this.hostname + ":" + this.port + " connectivity=" + this.connectivity + " files=" + this.files + " kbytes=" + this.kbytes;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public long getFiles() {
        return this.files;
    }

    public void setFiles(long files) {
        this.files = files;
    }

    public long getKbytes() {
        return this.kbytes;
    }

    public void normalizeFilesAndSize() {
        try {
            if (this.kbytes > 20000000L) {
                this.kbytes = 0L;
                this.files = 0L;
                return;
            }
            if (this.files > 5000L) {
                this.kbytes = 0L;
                this.files = 0L;
                return;
            }
            if (this.kbytes / this.files > 250000L) {
                this.kbytes = 0L;
                this.files = 0L;
                return;
            }
        }
        catch (ArithmeticException ae) {
            this.kbytes = 0L;
            this.files = 0L;
            return;
        }
    }

    public void setKbytes(long kbytes) {
        this.kbytes = kbytes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint e = (Endpoint)o;
        return this.hostname.equals(e.hostname) && this.port == e.port;
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    protected Object clone() {
        return new Endpoint(new String(this.hostname), this.port, this.files, this.kbytes);
    }

    public byte[] getHostBytes() throws UnknownHostException {
        if (this.hostBytes == null) {
            this.hostBytes = InetAddress.getByName(this.hostname).getAddress();
        }
        return this.hostBytes;
    }

    public boolean isPrivateAddress() {
        byte[] bytes;
        try {
            bytes = this.getHostBytes();
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (bytes[0] == 10) {
            return true;
        }
        if (bytes[0] == -84 && bytes[1] >= 16 && bytes[1] <= 31) {
            return true;
        }
        if (bytes[0] == -64 && bytes[1] == -88) {
            return true;
        }
        return bytes[0] == 0 && bytes[1] == 0 && bytes[2] == 0 && bytes[3] == 0;
    }

    public boolean isSameSubnet(Endpoint other) {
        byte[] b;
        int first;
        byte[] a;
        try {
            a = this.getHostBytes();
            first = ByteOrder.ubyte2int(a[0]);
            b = other.getHostBytes();
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (first <= 127) {
            return a[0] == b[0];
        }
        if (first <= 191) {
            return a[0] == b[0] && a[1] == b[1];
        }
        return a[0] == b[0] && a[1] == b[1] && a[2] == b[2];
    }
}

