/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.FileComparator;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.IntSet;
import com.limegroup.gnutella.util.StringComparator;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.Trie;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeMap;
import com.sun.java.util.collections.TreeSet;
import java.io.File;
import java.io.IOException;

public class FileManager {
    public static final String INDEXING_QUERY = "    ";
    public static final String BROWSE_QUERY = "*.*";
    private long _size = 0L;
    private int _numFiles = 0;
    private ArrayList _files;
    private Trie _index;
    private Set _extensions;
    private Map _sharedDirectories;
    private Thread _loadThread;
    private Object _loadThreadLock = new Object();
    private static FileManager _instance = new FileManager();
    private static ActivityCallback _callback;
    static final String DELIMETERS = " -._+/*()\\";

    private static final boolean isDelimeter(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    private FileManager() {
        this._files = new ArrayList();
        this._index = new Trie(true);
        this._extensions = new TreeSet((Comparator)new StringComparator());
        this._sharedDirectories = new TreeMap((Comparator)new FileComparator());
    }

    public static FileManager instance() {
        return _instance;
    }

    public void initialize(ActivityCallback callback) {
        _callback = callback;
        this.loadSettings(false);
    }

    public int getSize() {
        return ByteOrder.long2int(this._size);
    }

    public int getNumFiles() {
        return this._numFiles;
    }

    public FileDesc get(int i) throws IndexOutOfBoundsException {
        FileDesc ret = (FileDesc)this._files.get(i);
        if (ret == null) {
            throw new IndexOutOfBoundsException();
        }
        return ret;
    }

    public synchronized File[] getSharedFiles(File directory) {
        try {
            directory = FileManager.getCanonicalFile(directory);
        }
        catch (IOException e) {
            return null;
        }
        IntSet indices = (IntSet)this._sharedDirectories.get((Object)directory);
        if (indices == null) {
            return null;
        }
        File[] ret = new File[indices.size()];
        IntSet.IntSetIterator iter = indices.iterator();
        int i = 0;
        while (iter.hasNext()) {
            FileDesc fd = (FileDesc)this._files.get(iter.next());
            Assert.that(fd != null, "Directory has null entry");
            ret[i] = new File(fd._path);
            ++i;
        }
        return ret;
    }

    public void loadSettings(boolean notifyOnClear) {
        Object object = this._loadThreadLock;
        synchronized (object) {
            if (this._loadThread != null) {
                this._loadThread.interrupt();
                try {
                    this._loadThread.join();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            final String[] directories = this.loadSettingsInternal();
            if (notifyOnClear) {
                _callback.clearSharedFiles();
            }
            this._loadThread = new Thread("FileManager.loadSettings"){

                public void run() {
                    int i = 0;
                    while (i < directories.length && !FileManager.this._loadThread.isInterrupted()) {
                        FileManager.this.addDirectory(new File(directories[i]), null);
                        ++i;
                    }
                    if (!FileManager.this._loadThread.isInterrupted()) {
                        FileManager.this.trim();
                    }
                }
            };
            this._loadThread.start();
        }
    }

    private synchronized String[] loadSettingsInternal() {
        this._size = 0L;
        this._numFiles = 0;
        this._files = new ArrayList();
        this._index = new Trie(true);
        this._extensions = new TreeSet((Comparator)new StringComparator());
        this._sharedDirectories = new TreeMap((Comparator)new FileComparator());
        String[] extensions = StringUtils.split(SettingsManager.instance().getExtensions().trim(), ';');
        int i = 0;
        while (i < extensions.length) {
            this._extensions.add((Object)extensions[i].toLowerCase());
            ++i;
        }
        Object[] directories = StringUtils.split(SettingsManager.instance().getDirectories().trim(), ';');
        Arrays.sort((Object[])directories, (Comparator)new Comparator(){

            public int compare(Object a, Object b) {
                return ((String)a).length() - ((String)b).length();
            }
        });
        return directories;
    }

    private void addDirectory(File directory, File parent) {
        try {
            directory = FileManager.getCanonicalFile(directory);
            if (!directory.exists() || !directory.isDirectory()) {
                return;
            }
        }
        catch (IOException e) {
            return;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (this._sharedDirectories.get((Object)directory) != null) {
                return;
            }
            this._sharedDirectories.put((Object)directory, (Object)new IntSet());
            if (_callback != null) {
                _callback.addSharedDirectory(directory, parent);
            }
        }
        File[] file_list = FileManager.listFiles(directory);
        if (file_list == null) {
            return;
        }
        int n = file_list.length;
        ArrayList directories = new ArrayList();
        int i = 0;
        while (i < n && !this._loadThread.isInterrupted()) {
            if (file_list[i].isDirectory()) {
                directories.add((Object)file_list[i]);
            } else {
                this.addFile(file_list[i]);
            }
            ++i;
        }
        Iterator iter = directories.iterator();
        while (iter.hasNext() && !this._loadThread.isInterrupted()) {
            this.addDirectory((File)iter.next(), directory);
        }
    }

    public synchronized boolean addFileIfShared(File file) {
        File f = null;
        try {
            f = FileManager.getCanonicalFile(file);
            if (!f.exists()) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        File dir = FileManager.getParentFile(file);
        if (dir == null) {
            return false;
        }
        if (this._sharedDirectories.containsKey((Object)dir)) {
            return this.addFile(file);
        }
        return false;
    }

    private synchronized boolean addFile(File file) {
        String path = file.getAbsolutePath();
        String name = file.getName();
        if (this.hasExtension(name)) {
            long n = file.length();
            if (n > Integer.MAX_VALUE || n < 0L) {
                return false;
            }
            this._size += n;
            this._files.add((Object)new FileDesc(this._files.size(), name, path, (int)n));
            ++this._numFiles;
            int j = this._files.size() - 1;
            File parent = FileManager.getParentFile(file);
            Assert.that(parent != null, "Null parent to \"" + file + "\"");
            IntSet siblings = (IntSet)this._sharedDirectories.get((Object)parent);
            Assert.that(siblings != null, "Add directory \"" + parent + "\" not in " + this._sharedDirectories);
            boolean added = siblings.add(j);
            Assert.that(added, "File " + j + " already found in " + siblings);
            if (_callback != null) {
                _callback.addSharedFile(file, parent);
            }
            String[] keywords = StringUtils.split(path, DELIMETERS);
            int i = 0;
            while (i < keywords.length) {
                String keyword = keywords[i];
                IntSet indices = (IntSet)this._index.get(keyword);
                if (indices == null) {
                    indices = new IntSet();
                    this._index.add(keyword, indices);
                }
                indices.add(j);
                ++i;
            }
            return true;
        }
        return false;
    }

    public synchronized boolean removeFileIfShared(File f) {
        try {
            f = FileManager.getCanonicalFile(f);
        }
        catch (IOException e) {
            return false;
        }
        int i = 0;
        while (i < this._files.size()) {
            File candidate;
            FileDesc fd = (FileDesc)this._files.get(i);
            if (fd != null && f.equals(candidate = new File(fd._path))) {
                this._files.set(i, null);
                --this._numFiles;
                this._size -= (long)fd._size;
                File parent = FileManager.getParentFile(f);
                IntSet siblings = (IntSet)this._sharedDirectories.get((Object)parent);
                Assert.that(siblings != null, "Rem directory \"" + parent + "\" not in " + this._sharedDirectories);
                boolean removed = siblings.remove(i);
                Assert.that(removed, "File " + i + " not found in " + siblings);
                String[] keywords = StringUtils.split(fd._path, DELIMETERS);
                int j = 0;
                while (j < keywords.length) {
                    String keyword = keywords[j];
                    IntSet indices = (IntSet)this._index.get(keyword);
                    if (indices != null) {
                        indices.remove(i);
                    }
                    ++j;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean renameFileIfShared(File oldName, File newName) {
        boolean bl;
        ActivityCallback savedCallback;
        block5: {
            boolean bl2;
            block4: {
                savedCallback = _callback;
                _callback = null;
                try {
                    boolean removed = this.removeFileIfShared(oldName);
                    if (!removed) {
                        boolean bl3 = false;
                        Object var10_6 = null;
                        _callback = savedCallback;
                        return bl3;
                    }
                    boolean added = this.addFileIfShared(newName);
                    if (!added) {
                        bl2 = false;
                        break block4;
                    }
                    bl = true;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    _callback = savedCallback;
                    throw throwable;
                }
            }
            Object var10_7 = null;
            _callback = savedCallback;
            return bl2;
        }
        Object var10_8 = null;
        _callback = savedCallback;
        return bl;
    }

    private synchronized void trim() {
        this._index.trim(new Function(){

            public Object apply(Object intSet) {
                ((IntSet)intSet).trim();
                return intSet;
            }
        });
    }

    private boolean hasExtension(String filename) {
        int begin = filename.lastIndexOf(".");
        if (begin == -1) {
            return false;
        }
        String ext = filename.substring(begin + 1).toLowerCase();
        return this._extensions.contains((Object)ext);
    }

    public static File getParentFile(File f) {
        String name = f.getParent();
        if (name == null) {
            return null;
        }
        try {
            return FileManager.getCanonicalFile(new File(name));
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static File[] listFiles(File f) {
        String[] children = f.list();
        if (children == null) {
            return null;
        }
        File[] ret = new File[children.length];
        int i = 0;
        while (i < children.length) {
            ret[i] = new File(f, children[i]);
            ++i;
        }
        return ret;
    }

    public static File getCanonicalFile(File f) throws IOException {
        return new File(f.getCanonicalPath());
    }

    public synchronized Response[] query(QueryRequest request) {
        String str = request.getQuery();
        if (str.equals(INDEXING_QUERY) || str.equals(BROWSE_QUERY)) {
            if (this._numFiles == 0) {
                return null;
            }
            Response[] ret = new Response[this._numFiles];
            int j = 0;
            int i = 0;
            while (i < this._files.size()) {
                FileDesc desc = (FileDesc)this._files.get(i);
                if (desc != null) {
                    Response r;
                    Assert.that(j < ret.length, "_numFiles is too small");
                    ret[j] = r = new Response(desc._index, desc._size, desc._name);
                    ++j;
                }
                ++i;
            }
            Assert.that(j == ret.length, "_numFiles is too large");
            return ret;
        }
        IntSet matches = this.search(str);
        if (matches == null) {
            return null;
        }
        Response[] response = new Response[matches.size()];
        int j = 0;
        IntSet.IntSetIterator iter = matches.iterator();
        while (iter.hasNext()) {
            int i = iter.next();
            FileDesc desc = (FileDesc)this._files.get(i);
            response[j] = new Response(desc._index, desc._size, desc._name);
            ++j;
        }
        return response;
    }

    protected IntSet search(String query) {
        IntSet ret = null;
        int i = 0;
        while (i < query.length()) {
            if (FileManager.isDelimeter(query.charAt(i))) {
                ++i;
                continue;
            }
            int j = i + 1;
            while (j < query.length()) {
                if (FileManager.isDelimeter(query.charAt(j))) break;
                ++j;
            }
            Iterator iter = this._index.getPrefixedBy(query, i, j);
            if (iter.hasNext()) {
                IntSet matches = null;
                while (iter.hasNext()) {
                    IntSet s = (IntSet)iter.next();
                    if (matches == null) {
                        if (i == 0 && j == query.length() && !iter.hasNext()) {
                            return s;
                        }
                        matches = new IntSet();
                    }
                    matches.addAll(s);
                }
                if (ret == null) {
                    ret = matches;
                } else {
                    ret.retainAll(matches);
                }
            } else {
                return null;
            }
            if (ret.size() == 0) {
                return null;
            }
            i = j;
        }
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return ret;
    }
}

