/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.sun.java.util.collections.Random;

public class GUID {
    private static final int SZ = 16;
    private static Random rand = new Random();
    private byte[] bytes;

    public GUID(byte[] bytes) {
        Assert.that(bytes.length == 16);
        this.bytes = bytes;
    }

    public static byte[] makeGuid() {
        byte[] ret = new byte[16];
        rand.nextBytes(ret);
        ret[8] = -1;
        ret[15] = 0;
        short a = ByteOrder.leb2short(ret, 4);
        short b = ByteOrder.leb2short(ret, 6);
        short tag = GUID.tag(a, b);
        ByteOrder.short2leb(tag, ret, 9);
        return ret;
    }

    private static short tag(short a, short b) {
        int product = (a + 2) * (b + 3);
        short productMiddle = (short)(product >> 8);
        return productMiddle;
    }

    public boolean isLimeGUID() {
        return GUID.isLimeGUID(this.bytes);
    }

    public static boolean isLimeGUID(byte[] bytes) {
        short expectedTag;
        short a = ByteOrder.leb2short(bytes, 4);
        short b = ByteOrder.leb2short(bytes, 6);
        short foundTag = ByteOrder.leb2short(bytes, 9);
        return foundTag == (expectedTag = GUID.tag(a, b));
    }

    public final boolean isWindowsGUID() {
        return GUID.isWindowsGUID(this.bytes);
    }

    public static boolean isWindowsGUID(byte[] bytes) {
        return (bytes[8] & 0xC0) == 128;
    }

    public final boolean isNewGUID() {
        return GUID.isNewGUID(this.bytes);
    }

    public static boolean isNewGUID(byte[] bytes) {
        return bytes[8] == -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GUID)) {
            return false;
        }
        Assert.that(o != null, "Null o in GUID.equals");
        byte[] bytes2 = ((GUID)o).bytes();
        Assert.that(this.bytes != null, "Null bytes in GUID.equals");
        Assert.that(bytes2 != null, "Null bytes2 in GUID.equals");
        int i = 0;
        while (i < 16) {
            if (this.bytes[i] != bytes2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int sum = 0;
        int i = 0;
        while (i < 16) {
            sum += this.bytes[i];
            ++i;
        }
        return sum;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public String toString() {
        return this.toHexString();
    }

    public String toHexString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < 16) {
            int val = ByteOrder.ubyte2int(this.bytes[i]);
            String str = Integer.toHexString(val);
            while (str.length() < 2) {
                str = "0" + str;
            }
            buf.append(str);
            ++i;
        }
        return buf.toString().toUpperCase();
    }

    public static byte[] fromHexString(String sguid) throws IllegalArgumentException {
        byte[] bytes = new byte[16];
        try {
            int i = 0;
            while (i < 16) {
                bytes[i] = (byte)Integer.parseInt(sguid.substring(i * 2, i * 2 + 2), 16);
                ++i;
            }
            return bytes;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }
}

