/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.PingRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class GroupPingRequest
extends PingRequest
implements Serializable {
    private byte[] payload;

    public GroupPingRequest(byte ttl, int port, byte[] ip, long files, long kbytes, String group) {
        super(ttl, (byte)(14 + group.length() + 1));
        this.payload = new byte[14 + group.length() + 1];
        ByteOrder.short2leb((short)port, this.payload, 0);
        this.payload[2] = ip[0];
        this.payload[3] = ip[1];
        this.payload[4] = ip[2];
        this.payload[5] = ip[3];
        ByteOrder.int2leb((int)files, this.payload, 6);
        ByteOrder.int2leb((int)kbytes, this.payload, 10);
        byte[] gbytes = group.getBytes();
        System.arraycopy(gbytes, 0, this.payload, 14, gbytes.length);
        this.payload[this.payload.length - 1] = 0;
    }

    public GroupPingRequest(byte[] guid, byte ttl, byte hops, byte[] payload) {
        super(guid, ttl, hops, (byte)payload.length);
        Assert.that(payload.length >= 15);
        this.payload = payload;
    }

    public void writePayload(OutputStream out) throws IOException {
        out.write(this.payload);
    }

    public int getPort() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this.payload, 0));
    }

    public String getIP() {
        byte[] ip = this.getAddress();
        String ret = Message.ip2string(ip);
        return ret;
    }

    public byte[] getAddress() {
        byte[] ip = new byte[]{this.payload[2], this.payload[3], this.payload[4], this.payload[5]};
        return ip;
    }

    public long getFiles() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 6));
    }

    public long getKbytes() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 10));
    }

    public String getGroup() {
        return new String(this.payload, 14, this.payload.length - 15);
    }

    public boolean equals(Object obj) {
        byte[] ip;
        if (!(obj instanceof GroupPingRequest)) {
            return false;
        }
        GroupPingRequest gpr = (GroupPingRequest)obj;
        byte[] myip = this.getAddress();
        return myip[0] == (ip = gpr.getAddress())[0] && myip[1] == ip[1] && myip[2] == ip[2] && myip[3] == ip[3] && this.getPort() == gpr.getPort();
    }

    public String toString() {
        return "GroupPingRequest(" + this.getIP() + ":" + this.getPort() + "," + this.getGroup() + ", " + super.toString() + ")";
    }
}

