/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.BucketQueue;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.Set;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;

public class HostCatcher {
    private static final int GOOD_SIZE = 30;
    private static final int NORMAL_SIZE = 70;
    private static final int BAD_SIZE = 10;
    private static final int SIZE = 110;
    private static final int GOOD_PRIORITY = 2;
    private static final int NORMAL_PRIORITY = 1;
    private static final int BAD_PRIORITY = 0;
    private BucketQueue queue = new BucketQueue(new int[]{10, 70, 30});
    private Set set = new HashSet();
    private Acceptor acceptor;
    private ConnectionManager manager;
    private ActivityCallback callback;
    private SettingsManager settings = SettingsManager.instance();
    private Thread routerConnectorThread;
    private boolean stale = true;
    private Object staleLock = new Object();
    private int staleWaiters = 0;
    private Object staleWaitersLock = new Object();
    private boolean gotGoodPong = false;
    private Object gotGoodPongLock = new Object();
    private static final int STALE_TIME = 172800000;
    private static final int RETRY_TIME = 300000;
    private static final int CONNECT_TIME = 6000;
    private boolean alwaysNotifyKnownHost = false;

    public HostCatcher(ActivityCallback callback) {
        this.callback = callback;
    }

    public void initialize(Acceptor acceptor, ConnectionManager manager) {
        this.acceptor = acceptor;
        this.manager = manager;
    }

    public void connectToRouter() {
        this.routerConnectorThread = new RouterConnectorThread();
        this.routerConnectorThread.start();
    }

    public void initialize(Acceptor acceptor, ConnectionManager manager, String filename) {
        this.acceptor = acceptor;
        this.manager = manager;
        try {
            this.read(filename);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private synchronized void read(String filename) throws FileNotFoundException, IOException {
        BufferedReader in = null;
        in = new BufferedReader(new FileReader(filename));
        int i = 0;
        while (i < 110) {
            block9: {
                String line = in.readLine();
                if (line == null) break;
                int index = line.indexOf(58);
                if (index != -1) {
                    String host = line.substring(0, index);
                    int port = 0;
                    try {
                        port = Integer.parseInt(line.substring(index + 1));
                    }
                    catch (NumberFormatException e) {
                        break block9;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        break block9;
                    }
                    Endpoint e = new Endpoint(host, port);
                    if (e.isPrivateAddress()) {
                        e.setWeight(0);
                    } else {
                        e.setWeight(1);
                    }
                    if (!this.set.contains((Object)e) && !this.isMe(host, port)) {
                        Endpoint removed = this.queue.insert(e);
                        if (removed != null) {
                            this.set.remove((Object)removed);
                        }
                        this.set.add((Object)e);
                        this.notify();
                    }
                }
            }
            ++i;
        }
    }

    public synchronized void write(String filename) throws IOException {
        Endpoint e;
        FileWriter out = new FileWriter(filename);
        HashSet connections = new HashSet();
        Iterator iter = this.manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            Connection c = (Connection)iter.next();
            if (!c.isOutgoing()) continue;
            e = new Endpoint(c.getInetAddress().getHostAddress(), c.getPort());
            connections.add((Object)e);
            this.writeInternal(out, e);
        }
        int i = this.queue.size() - 1;
        while (i >= 0) {
            e = this.queue.extractMax();
            if (!connections.contains((Object)e)) {
                this.writeInternal(out, e);
            }
            --i;
        }
        out.close();
    }

    private void writeInternal(Writer out, Endpoint e) throws IOException {
        out.write(e.getHostname() + ":" + e.getPort() + "\n");
    }

    public void spy(PingReply pr, ManagedConnection receivingConnection) {
        Endpoint e = new Endpoint(pr.getIP(), pr.getPort(), pr.getFiles(), pr.getKbytes());
        if (this.manager.isConnected(e)) {
            return;
        }
        if (this.isMe(e.getHostname(), e.getPort())) {
            return;
        }
        if (HostCatcher.isRouter(pr.getIPBytes())) {
            return;
        }
        if (e.isPrivateAddress()) {
            e.setWeight(0);
        } else if (receivingConnection != null && receivingConnection.isRouterConnection()) {
            e.setWeight(2);
        } else {
            e.setWeight(1);
        }
        boolean notifyGUI = false;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (!this.set.contains((Object)e)) {
                this.set.add((Object)e);
                Endpoint ejected = this.queue.insert(e);
                if (ejected != null) {
                    this.set.remove((Object)ejected);
                }
                if (ejected == null) {
                    notifyGUI = true;
                }
                this.notify();
            }
        }
        if (e.getWeight() == 2) {
            Object object = this.gotGoodPongLock;
            synchronized (object) {
                this.gotGoodPong = true;
                this.gotGoodPongLock.notify();
            }
        }
        if (this.alwaysNotifyKnownHost) {
            this.callback.knownHost(e);
        } else if (notifyGUI) {
            this.callback.knownHost(e);
        }
    }

    private boolean hasRouterHost() {
        if (!this.queue.isEmpty()) {
            Endpoint e = this.queue.getMax();
            return e.getWeight() == 2;
        }
        return false;
    }

    public Endpoint getAnEndpoint() throws InterruptedException {
        Object object;
        if (this.settings.getUseQuickConnect() && this.stale) {
            Object object2;
            try {
                Object object3 = this.staleWaitersLock;
                synchronized (object3) {
                    ++this.staleWaiters;
                    this.staleWaitersLock.notify();
                }
                object = this.staleLock;
                synchronized (object) {
                    if (this.stale) {
                        this.staleLock.wait(6000L);
                    }
                }
                Object var5_6 = null;
                object2 = this.staleWaitersLock;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                Object object4 = this.staleWaitersLock;
                synchronized (object4) {
                    --this.staleWaiters;
                }
                throw throwable;
            }
            synchronized (object2) {
                --this.staleWaiters;
            }
        }
        Endpoint endpoint = null;
        object = this;
        synchronized (object) {
            while (true) {
                try {
                    endpoint = this.getAnEndpointInternal();
                }
                catch (NoSuchElementException e) {
                    this.wait();
                    continue;
                }
                break;
            }
        }
        return endpoint;
    }

    private Endpoint getAnEndpointInternal() throws NoSuchElementException {
        if (!this.queue.isEmpty()) {
            Endpoint e = this.queue.extractMax();
            boolean ok = this.set.remove((Object)e);
            Assert.that(ok, "Rep. invariant for HostCatcher broken.");
            return e;
        }
        throw new NoSuchElementException();
    }

    public int getNumHosts() {
        return this.queue.size();
    }

    public synchronized Iterator getHosts() {
        return new BucketQueue(this.queue).iterator();
    }

    public synchronized Iterator getBestHosts(int n) {
        return new BucketQueue(this.queue).iterator(n);
    }

    public synchronized void removeHost(String host, int port) {
        boolean removed2;
        Endpoint e = new Endpoint(host, port);
        boolean removed1 = this.set.remove((Object)e);
        Assert.that(removed1 == (removed2 = this.queue.removeAll(e)), "Rep. invariant for HostCatcher broken.");
    }

    public synchronized void clear() {
        this.queue.clear();
        this.set.clear();
        this.expire();
    }

    public synchronized void silentClear() {
        this.queue.clear();
        this.set.clear();
    }

    public synchronized void expire() {
        this.routerConnectorThread.interrupt();
    }

    private boolean isMe(String host, int port) {
        byte[] cIP;
        try {
            cIP = InetAddress.getByName(host).getAddress();
        }
        catch (IOException e) {
            return false;
        }
        if (cIP[0] == 127) {
            return port == this.acceptor.getPort();
        }
        byte[] managerIP = this.acceptor.getAddress();
        return Arrays.equals((byte[])cIP, (byte[])managerIP) && port == this.acceptor.getPort();
    }

    private static boolean isRouter(byte[] ip) {
        return ip[0] == 64 && ip[1] == 61 && ip[2] == 25 && (ip[3] == -85 || ip[3] >= -117 && ip[3] <= -113);
    }

    public String toString() {
        return this.queue.toString();
    }

    public void setAlwaysNotifyKnownHost(boolean notifyKnownHost) {
        this.alwaysNotifyKnownHost = notifyKnownHost;
    }

    private class RouterConnectorThread
    extends Thread {
        RouterConnectorThread() {
            this.setDaemon(true);
            this.setName("RouterConnectorThread");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                HostCatcher.this.stale = true;
                Object object = HostCatcher.this.staleWaitersLock;
                synchronized (object) {
                    while (HostCatcher.this.staleWaiters == 0) {
                        try {
                            HostCatcher.this.staleWaitersLock.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                try {
                    this.connectUntilPong();
                }
                catch (InterruptedException e) {
                    continue;
                }
                try {
                    Thread.sleep(172800000L);
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }

        private void connectUntilPong() throws InterruptedException {
            HostCatcher.this.gotGoodPong = false;
            while (!HostCatcher.this.gotGoodPong) {
                String[] hosts = HostCatcher.this.settings.getQuickConnectHosts();
                int i = 0;
                while (i < hosts.length) {
                    block14: {
                        Endpoint e;
                        try {
                            e = new Endpoint(hosts[i]);
                        }
                        catch (IllegalArgumentException exc) {
                            break block14;
                        }
                        try {
                            HostCatcher.this.manager.createRouterConnection(e.getHostname(), e.getPort());
                        }
                        catch (IOException exc) {
                            break block14;
                        }
                        Object object = HostCatcher.this.gotGoodPongLock;
                        synchronized (object) {
                            if (!HostCatcher.this.gotGoodPong) {
                                HostCatcher.this.gotGoodPongLock.wait(6000L);
                            }
                        }
                    }
                    ++i;
                }
                if (HostCatcher.this.stale) {
                    Object object = HostCatcher.this.staleLock;
                    synchronized (object) {
                        HostCatcher.this.stale = false;
                        HostCatcher.this.staleLock.notifyAll();
                    }
                }
                if (HostCatcher.this.gotGoodPong) continue;
                Thread.sleep(300000L);
            }
        }
    }
}

