/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.StandardMessageRouter;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.chat.Chatter;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class Main
implements ActivityCallback {
    public static void main(String[] args) {
        Main callback = new Main();
        RouterService service = new RouterService(callback, new StandardMessageRouter(callback));
        service.initialize();
        System.out.println("For a command list type help.");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("LimeRouter> ");
            try {
                String command = in.readLine();
                if (command == null) break;
                if (command.equals("help")) {
                    System.out.println("catcher                  Print host catcher.");
                    System.out.println("connect <host> [<port>]  Connect to a host[:port].");
                    System.out.println("help                     Print this message.");
                    System.out.println("listen <port>            Set the port you are listening on.");
                    System.out.println("query <string>           Send a query to the network.");
                    System.out.println("quit                     Quit the application.");
                    System.out.println("update                   Send pings to update the statistics.");
                } else {
                    if (command.equals("quit")) break;
                    if (command.equals("stat")) {
                        System.out.println("Number of hosts: " + service.getNumHosts());
                        System.out.println("Number of files: " + service.getNumFiles());
                        System.out.println("Size of files: " + service.getTotalFileSize());
                    } else if (command.equals("update")) {
                        service.updateHorizon();
                    } else if (command.equals("catcher")) {
                        Iterator iter = service.getHosts();
                        while (iter.hasNext()) {
                            System.out.println(iter.next().toString());
                        }
                    }
                }
                String[] commands = Main.split(command);
                if (commands.length >= 2 && commands[0].equals("connect")) {
                    try {
                        int port = 6346;
                        if (commands.length >= 3) {
                            port = Integer.parseInt(commands[2]);
                        }
                        service.connectToHostBlocking(commands[1], port);
                    }
                    catch (IOException e) {
                        System.out.println("Couldn't establish connection.");
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Please specify a valid port.");
                    }
                    continue;
                }
                if (commands.length >= 2 && commands[0].equals("query")) {
                    int i = command.indexOf(32);
                    Assert.that(i != -1 && i < command.length());
                    String query = command.substring(i + 1);
                    service.query(query, 0);
                    continue;
                }
                if (commands.length != 2 || !commands[0].equals("listen")) continue;
                try {
                    int port = Integer.parseInt(commands[1]);
                    service.setListeningPort(port);
                }
                catch (NumberFormatException e) {
                    System.out.println("Please specify a valid port.");
                }
                catch (IOException e) {
                    System.out.println("Couldn't change port.  Try another value.");
                }
            }
            catch (IOException e) {
                System.exit(1);
            }
        }
        System.out.println("Good bye.");
        service.shutdown();
    }

    public void connectionInitializing(Connection c) {
        String host = c.getOrigHost();
        int port = c.getOrigPort();
        String direction = null;
        String direction2 = null;
        if (c.isOutgoing()) {
            direction = "outgoing";
            direction2 = "to ";
        } else {
            direction = "incoming";
            direction2 = "from ";
        }
    }

    public void connectionInitialized(Connection c) {
        String host = c.getOrigHost();
        int n = c.getOrigPort();
    }

    public void connectionClosed(Connection c) {
        String host = c.getOrigHost();
        int n = c.getOrigPort();
    }

    public void knownHost(Endpoint e) {
    }

    public void handleQueryReply(QueryReply qr) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println("Query reply from " + qr.getIP() + ":" + qr.getPort() + ":");
            try {
                Iterator iter = qr.getResults();
                while (iter.hasNext()) {
                    System.out.println("   " + ((Response)iter.next()).getName());
                }
            }
            catch (BadPacketException badPacketException) {
                // empty catch block
            }
        }
    }

    public void handleQueryString(String query) {
    }

    public void error(int message) {
        this.error(message, null);
    }

    public void error(Throwable problem) {
    }

    public void error(int message, Throwable t) {
        System.out.println("Error: " + message);
    }

    public static String[] split(String s) {
        int n = (s = s.trim()).length();
        if (n == 0) {
            return new String[0];
        }
        Vector buf = new Vector();
        int i = 0;
        block0: while (i < n) {
            Assert.that(s.charAt(i) != ' ');
            int j = s.indexOf(32, i + 1);
            if (j == -1) {
                j = n;
            }
            buf.add((Object)s.substring(i, j));
            i = j + 1;
            while (j < n) {
                if (s.charAt(i) != ' ') continue block0;
                ++i;
            }
        }
        String[] ret = new String[buf.size()];
        int i2 = 0;
        while (i2 < ret.length) {
            ret[i2] = (String)buf.get(i2);
            ++i2;
        }
        return ret;
    }

    public boolean overwriteFile(String file) {
        return false;
    }

    public void addDownload(Downloader mgr) {
    }

    public void removeDownload(Downloader mgr) {
    }

    public void addUpload(Uploader mgr) {
    }

    public void removeUpload(Uploader mgr) {
    }

    public void setPort(int port) {
    }

    public int getNumUploads() {
        return 0;
    }

    public void addSharedDirectory(File file, File parent) {
    }

    public void addSharedFile(File file, File parent) {
    }

    public void clearSharedFiles() {
    }

    public void acceptChat(Chatter chat) {
    }

    public void receiveMessage(Chatter chat) {
    }

    public void chatUnavailable(Chatter chatter) {
    }

    public void chatErrorMessage(Chatter chatter, String st) {
    }
}

