/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.SpamFilter;
import com.limegroup.gnutella.util.Buffer;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;

public class ManagedConnection
extends Connection
implements ReplyHandler {
    private MessageRouter _router;
    private ConnectionManager _manager;
    private volatile SpamFilter _routeFilter = SpamFilter.newRouteFilter();
    private volatile SpamFilter _personalFilter = SpamFilter.newPersonalFilter();
    private static final int QUEUE_TIME = 750;
    private static final int BATCH_SIZE = 50;
    private static final int QUEUE_SIZE = 500;
    private Object _outputQueueLock = new Object();
    private volatile Buffer _outputQueue = new Buffer(500);
    private volatile Buffer _oldOutputQueue = new Buffer(500);
    private volatile boolean _flushImmediately = false;
    private Object _flushLock = new Object();
    private int _numMessagesSent;
    private int _numMessagesReceived;
    private int _numReceivedMessagesDropped;
    private int _numSentMessagesDropped;
    private int _lastReceived;
    private int _lastRecvDropped;
    private int _lastSent;
    private int _lastSentDropped;
    private boolean _horizonEnabled = true;
    private static final long HORIZON_UPDATE_TIME = 600000L;
    private long _lastRefreshHorizonTime = System.currentTimeMillis();
    private boolean _refreshedHorizonStats = false;
    private static final int MAX_PING_REPLIES = 4000;
    private Set _pingReplies = new HashSet();
    private long _totalHorizonFileSize = 0L;
    private long _numHorizonFiles = 0L;
    private long _numHorizonHosts = 0L;
    private long _nextTotalHorizonFileSize = 0L;
    private long _nextNumHorizonFiles = 0L;
    private long _nextNumHorizonHosts = 0L;
    private volatile long _bytesSent;
    private volatile long _bytesReceived;
    private boolean _isRouter = false;
    private boolean _isKillable = true;

    ManagedConnection(String host, int port, MessageRouter router, ConnectionManager manager) {
        this(host, port, router, manager, false);
    }

    ManagedConnection(String host, int port, MessageRouter router, ConnectionManager manager, boolean isRouter) {
        super(host, port);
        this._router = router;
        this._manager = manager;
        this._isRouter = isRouter;
        new OutputRunner();
    }

    ManagedConnection(Socket socket, MessageRouter router, ConnectionManager manager) {
        super(socket);
        this._router = router;
        this._manager = manager;
        new OutputRunner();
    }

    public Message receive() throws IOException, BadPacketException {
        Message m = null;
        try {
            m = super.receive();
            this._bytesReceived += (long)m.getTotalLength();
        }
        catch (IOException e) {
            this._manager.remove(this);
            throw e;
        }
        ++this._numMessagesReceived;
        this._router.countMessage();
        return m;
    }

    public Message receive(int timeout) throws IOException, BadPacketException, InterruptedIOException {
        Message m = null;
        try {
            m = super.receive(timeout);
            this._bytesReceived += (long)m.getTotalLength();
        }
        catch (IOException e) {
            this._manager.remove(this);
            throw e;
        }
        ++this._numMessagesReceived;
        this._router.countMessage();
        return m;
    }

    public void send(Message m) {
        Object object = this._outputQueueLock;
        synchronized (object) {
            ++this._numMessagesSent;
            this._router.countMessage();
            if (this._outputQueue.isFull()) {
                ++this._numSentMessagesDropped;
                if (ManagedConnection.isDisposeable(m)) {
                    return;
                }
                int i = this._outputQueue.getSize() - 1;
                while (i >= 0) {
                    Message mi = (Message)this._outputQueue.get(i);
                    if (ManagedConnection.isDisposeable(mi)) break;
                    --i;
                }
                if (i >= 0) {
                    this._outputQueue.set(i, m);
                } else {
                    this._outputQueue.addFirst(m);
                }
            } else {
                this._outputQueue.addFirst(m);
                if (this._outputQueue.getSize() >= 50) {
                    this._outputQueueLock.notify();
                }
            }
        }
    }

    public void flush() throws IOException {
        Object object = this._outputQueueLock;
        synchronized (object) {
            this._flushImmediately = true;
            this._outputQueueLock.notify();
        }
        Object object2 = this._flushLock;
        synchronized (object2) {
            while (!this._outputQueue.isEmpty() || !this._oldOutputQueue.isEmpty()) {
                try {
                    this._flushLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                super.flush();
            }
        }
    }

    private void superSend(Message m) throws IOException {
        super.send(m);
        this._bytesSent += (long)m.getTotalLength();
    }

    private void superFlush() throws IOException {
        super.flush();
    }

    private static boolean isDisposeable(Message m) {
        return m instanceof PingRequest && m.getHops() != 0 || m instanceof PingReply;
    }

    void loopForMessages() throws IOException {
        while (true) {
            Message m = null;
            try {
                m = this.receive();
                if (m == null) {
                }
            }
            catch (BadPacketException e) {}
            continue;
            if (!this._routeFilter.allow(m)) {
                this._router.countFilteredMessage();
                ++this._numReceivedMessagesDropped;
                continue;
            }
            m.hop();
            if (m instanceof PingRequest) {
                this._router.handlePingRequestPossibleDuplicate((PingRequest)m, this);
                continue;
            }
            if (m instanceof PingReply) {
                this._router.handlePingReply((PingReply)m, this);
                continue;
            }
            if (m instanceof QueryRequest) {
                this._router.handleQueryRequestPossibleDuplicate((QueryRequest)m, this);
                continue;
            }
            if (m instanceof QueryReply) {
                this._router.handleQueryReply((QueryReply)m, this);
                continue;
            }
            if (!(m instanceof PushRequest)) continue;
            this._router.handlePushRequest((PushRequest)m, this);
        }
    }

    public void countDroppedMessage() {
        ++this._numReceivedMessagesDropped;
    }

    public boolean isPersonalSpam(Message m) {
        return !this._personalFilter.allow(m);
    }

    public void setRouteFilter(SpamFilter filter) {
        this._routeFilter = filter;
    }

    public void setPersonalFilter(SpamFilter filter) {
        this._personalFilter = filter;
    }

    public void handlePingReply(PingReply pingReply, ManagedConnection receivingConnection) {
        this.send(pingReply);
    }

    public void handleQueryReply(QueryReply queryReply, ManagedConnection receivingConnection) {
        this.send(queryReply);
    }

    public void handlePushRequest(PushRequest pushRequest, ManagedConnection receivingConnection) {
        this.send(pushRequest);
    }

    public int getNumMessagesSent() {
        return this._numMessagesSent;
    }

    public int getNumMessagesReceived() {
        return this._numMessagesReceived;
    }

    public int getNumSentMessagesDropped() {
        return this._numSentMessagesDropped;
    }

    public long getNumReceivedMessagesDropped() {
        return this._numReceivedMessagesDropped;
    }

    public synchronized float getPercentReceivedDropped() {
        int rdiff = this._numMessagesReceived - this._lastReceived;
        int ddiff = this._numReceivedMessagesDropped - this._lastRecvDropped;
        float percent = rdiff == 0 ? 0.0f : (float)ddiff / (float)rdiff * 100.0f;
        this._lastReceived = this._numMessagesReceived;
        this._lastRecvDropped = this._numReceivedMessagesDropped;
        return percent;
    }

    public synchronized float getPercentSentDropped() {
        int rdiff = this._numMessagesSent - this._lastSent;
        int ddiff = this._numSentMessagesDropped - this._lastSentDropped;
        float percent = rdiff == 0 ? 0.0f : (float)ddiff / (float)rdiff * 100.0f;
        this._lastSent = this._numMessagesSent;
        this._lastSentDropped = this._numSentMessagesDropped;
        return percent;
    }

    public synchronized long getBytesReceived() {
        long ret = this._bytesReceived;
        this._bytesReceived = 0L;
        return ret;
    }

    public synchronized long getBytesSent() {
        long ret = this._bytesSent;
        this._bytesSent = 0L;
        return ret;
    }

    public synchronized void setHorizonEnabled(boolean enable) {
        this._horizonEnabled = enable;
    }

    public synchronized void updateHorizonStats(PingReply pingReply) {
        if (!this._horizonEnabled) {
            return;
        }
        Endpoint host = new Endpoint(pingReply.getIP(), pingReply.getPort());
        if (this._pingReplies.size() < 4000 && this._pingReplies.add((Object)host)) {
            this._nextTotalHorizonFileSize += pingReply.getKbytes();
            this._nextNumHorizonFiles += pingReply.getFiles();
            ++this._nextNumHorizonHosts;
        }
    }

    public synchronized void refreshHorizonStats() {
        long now = System.currentTimeMillis();
        long elapsed = now - this._lastRefreshHorizonTime;
        if (elapsed < 600000L) {
            return;
        }
        this._lastRefreshHorizonTime = now;
        this._numHorizonHosts = this._nextNumHorizonHosts;
        this._numHorizonFiles = this._nextNumHorizonFiles;
        this._totalHorizonFileSize = this._nextTotalHorizonFileSize;
        this._nextNumHorizonHosts = 0L;
        this._nextNumHorizonFiles = 0L;
        this._nextTotalHorizonFileSize = 0L;
        this._pingReplies.clear();
        this._refreshedHorizonStats = true;
    }

    public synchronized long getNumHosts() {
        if (this._refreshedHorizonStats) {
            return this._numHorizonHosts;
        }
        return this._nextNumHorizonHosts;
    }

    public synchronized long getNumFiles() {
        if (this._refreshedHorizonStats) {
            return this._numHorizonFiles;
        }
        return this._nextNumHorizonFiles;
    }

    public synchronized long getTotalFileSize() {
        if (this._refreshedHorizonStats) {
            return this._totalHorizonFileSize;
        }
        return this._nextTotalHorizonFileSize;
    }

    public boolean isRouterConnection() {
        return this._isRouter;
    }

    public void setKillable(boolean killable) {
        this._isKillable = killable;
    }

    public boolean isKillable() {
        return this._isKillable;
    }

    private class OutputRunner
    extends Thread {
        public OutputRunner() {
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            while (ManagedConnection.this.isOpen()) {
                Object object = ManagedConnection.this._outputQueueLock;
                synchronized (object) {
                    try {
                        if (!ManagedConnection.this._flushImmediately && ManagedConnection.this._outputQueue.getSize() < 50) {
                            ManagedConnection.this._outputQueueLock.wait(750L);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    ManagedConnection.this._flushImmediately = false;
                    if (ManagedConnection.this._outputQueue.isEmpty()) {
                        continue;
                    }
                    Buffer tmp = ManagedConnection.this._outputQueue;
                    ManagedConnection.this._outputQueue = ManagedConnection.this._oldOutputQueue;
                    ManagedConnection.this._outputQueue.clear();
                    ManagedConnection.this._oldOutputQueue = tmp;
                }
                try {
                    while (!ManagedConnection.this._oldOutputQueue.isEmpty()) {
                        ManagedConnection.this.superSend((Message)ManagedConnection.this._oldOutputQueue.removeLast());
                    }
                    ManagedConnection.this.superFlush();
                }
                catch (IOException e) {
                    ManagedConnection.this._manager.remove(ManagedConnection.this);
                }
                Object object2 = ManagedConnection.this._flushLock;
                synchronized (object2) {
                    if (ManagedConnection.this._outputQueue.isEmpty()) {
                        ManagedConnection.this._flushLock.notify();
                    }
                }
            }
        }
    }
}

