/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

public class MediaType {
    private String description;
    private String[] extensions;

    public MediaType(String description, String[] extensions) {
        this.description = description;
        this.extensions = extensions;
    }

    public boolean matches(String filename) {
        if (this.extensions == null) {
            return true;
        }
        int j = filename.lastIndexOf(".");
        if (j == -1 || j == filename.length()) {
            return false;
        }
        String suffix = filename.substring(j + 1).toLowerCase();
        int i = 0;
        while (i < this.extensions.length) {
            if (suffix.equals(this.extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return this.description;
    }

    public static MediaType[] getDefaultMediaTypes() {
        MediaType any = new MediaType("Any Type", null);
        MediaType text = new MediaType("Documents", new String[]{"html", "htm", "xml", "txt", "pdf", "ps", "rtf", "doc", "tex"});
        MediaType programs = new MediaType("Programs", new String[]{"exe", "zip", "gz", "gzip", "hqx", "tar", "tgz", "z", "sit", "hqx", "bin", "dmg"});
        MediaType audio = new MediaType("Audio", new String[]{"mp3", "wav", "au", "aif", "aiff", "ra", "ram", "rmj", "lqt", "ogg"});
        MediaType video = new MediaType("Video", new String[]{"mpg", "mpeg", "asf", "qt", "mov", "avi", "mpe", "swf", "dcr", "rm", "ram"});
        MediaType images = new MediaType("Images", new String[]{"gif", "jpg", "jpeg", "jpe", "png", "tif", "tiff"});
        return new MediaType[]{any, text, programs, audio, video, images};
    }
}

