/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GroupPingRequest;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.SettingsManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class Message
implements Serializable {
    public static final byte F_PING = 0;
    public static final byte F_PING_REPLY = 1;
    public static final byte F_PUSH = 64;
    public static final byte F_QUERY = -128;
    public static final byte F_QUERY_REPLY = -127;
    private byte[] guid;
    private byte func;
    private byte ttl;
    private byte hops;
    private int length;

    static byte[] makeGuid() {
        return GUID.makeGuid();
    }

    protected void repOk() {
        Assert.that(this.guid.length == 16);
        Assert.that(this.func == 0 || this.func == 1 || this.func == 64 || this.func == -128 || this.func == -127, "Bad function code");
        if (this.func == 1) {
            Assert.that(this.length == 14, "Bad pong length: " + this.length);
        }
        if (this.func == 64) {
            Assert.that(this.length == 26, "Bad push length: " + this.length);
        }
        Assert.that(this.ttl >= 0, "Negative TTL: " + this.ttl);
        Assert.that(this.hops >= 0, "Negative hops: " + this.hops);
        Assert.that(this.length >= 0, "Negative length: " + this.length);
    }

    protected Message(byte func, byte ttl, int length) {
        this(Message.makeGuid(), func, ttl, 0, length);
    }

    protected Message(byte[] guid, byte func, byte ttl, byte hops, int length) {
        this.guid = guid;
        this.func = func;
        this.ttl = ttl;
        this.hops = hops;
        this.length = length;
    }

    public static Message read(InputStream in) throws BadPacketException, IOException {
        return Message.read(in, new byte[23]);
    }

    static Message read(InputStream in, byte[] buf) throws BadPacketException, IOException {
        int i = 0;
        while (i < 23) {
            int got;
            try {
                got = in.read(buf, i, 23 - i);
            }
            catch (InterruptedIOException e) {
                if (i == 0) {
                    return null;
                }
                throw e;
            }
            if (got == -1) {
                throw new IOException("Connection closed.");
            }
            i += got;
        }
        byte[] guid = new byte[16];
        int i2 = 0;
        while (i2 < 16) {
            guid[i2] = buf[i2];
            ++i2;
        }
        byte func = buf[16];
        byte ttl = buf[17];
        byte hops = buf[18];
        int length = ByteOrder.leb2int(buf, 19);
        if (length < 0 || length > SettingsManager.instance().getMaxLength()) {
            throw new IOException("Unreasonable message length: " + length);
        }
        byte[] payload = null;
        if (length != 0) {
            payload = new byte[length];
            int i3 = 0;
            while (i3 < length) {
                int got = in.read(payload, i3, length - i3);
                if (got == -1) {
                    throw new IOException("Connection closed.");
                }
                i3 += got;
            }
        }
        byte softMax = SettingsManager.instance().getSoftMaxTTL();
        byte hardMax = SettingsManager.instance().getMaxTTL();
        if (hops < 0) {
            throw new BadPacketException("Negative (or very large) hops");
        }
        if (ttl < 0) {
            throw new BadPacketException("Negative (or very large) TTL");
        }
        if (hops > softMax) {
            throw new BadPacketException("Hops already exceeds soft maximum");
        }
        if (ttl + hops > hardMax) {
            throw new BadPacketException("TTL+hops exceeds hard max; probably spam");
        }
        if (ttl + hops > softMax) {
            ttl = (byte)(softMax - hops);
            Assert.that(ttl >= 0);
        }
        switch (func) {
            case 0: {
                if (length >= 15) {
                    return new GroupPingRequest(guid, ttl, hops, payload);
                }
                if (length > 0) break;
                return new PingRequest(guid, ttl, hops);
            }
            case 1: {
                if (length != 14) break;
                return new PingReply(guid, ttl, hops, payload);
            }
            case -128: {
                if (length < 3) break;
                return new QueryRequest(guid, ttl, hops, payload);
            }
            case -127: {
                if (length < 26) break;
                return new QueryReply(guid, ttl, hops, payload);
            }
            case 64: {
                if (length != 26) break;
                return new PushRequest(guid, ttl, hops, payload);
            }
        }
        throw new BadPacketException("Unrecognized function code: " + func);
    }

    public void write(OutputStream out) throws IOException {
        byte[] buf = new byte[23];
        int i = 0;
        while (i < 16) {
            buf[i] = this.guid[i];
            ++i;
        }
        buf[16] = this.func;
        buf[17] = this.ttl;
        buf[18] = this.hops;
        ByteOrder.int2leb(this.length, buf, 19);
        out.write(buf);
        this.writePayload(out);
    }

    protected abstract void writePayload(OutputStream var1) throws IOException;

    public byte[] getGUID() {
        return this.guid;
    }

    public byte getFunc() {
        return this.func;
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte ttl) throws IllegalArgumentException {
        if (ttl < 0) {
            throw new IllegalArgumentException();
        }
        this.ttl = ttl;
    }

    public byte getHops() {
        return this.hops;
    }

    public int getLength() {
        return this.length;
    }

    public int getTotalLength() {
        return 23 + this.length;
    }

    static String ip2string(byte[] ip) {
        StringBuffer buf = new StringBuffer();
        buf.append(ByteOrder.ubyte2int(ip[0]) + ".");
        buf.append(ByteOrder.ubyte2int(ip[1]) + ".");
        buf.append(ByteOrder.ubyte2int(ip[2]) + ".");
        buf.append(ByteOrder.ubyte2int(ip[3]) + "");
        return buf.toString();
    }

    public byte hop() {
        this.hops = (byte)(this.hops + 1);
        if (this.ttl > 0) {
            byte by = this.ttl;
            this.ttl = (byte)(by - 1);
            return by;
        }
        return this.ttl;
    }

    public String toString() {
        return "{guid=" + new GUID(this.guid).toString() + ", ttl=" + this.ttl + "}";
    }
}

