/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GroupPingRequest;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouteTable;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.UploadManager;
import com.sun.java.util.collections.List;
import java.io.IOException;

public abstract class MessageRouter {
    protected HostCatcher _catcher;
    protected ConnectionManager _manager;
    protected Acceptor _acceptor;
    private byte[] _clientGUID;
    private ForMeReplyHandler _forMeReplyHandler = new ForMeReplyHandler();
    private RouteTable _pingRouteTable = new RouteTable(2048);
    private RouteTable _queryRouteTable = new RouteTable(2048);
    private RouteTable _pushRouteTable = new RouteTable(2048, true);
    private volatile int _numMessages;
    private volatile int _numPingRequests;
    private volatile int _numPingReplies;
    private volatile int _numQueryRequests;
    private volatile int _numQueryReplies;
    private volatile int _numPushRequests;
    private volatile int _numFilteredMessages;
    private volatile int _numRouteErrors;
    protected UploadManager _uploadManager;

    protected MessageRouter() {
        try {
            this._clientGUID = new GUID(GUID.fromHexString(SettingsManager.instance().getClientID())).bytes();
        }
        catch (IllegalArgumentException e) {
            this._clientGUID = Message.makeGuid();
        }
    }

    public void initialize(Acceptor acceptor, ConnectionManager manager, HostCatcher catcher, UploadManager uploadManager) {
        this._acceptor = acceptor;
        this._manager = manager;
        this._catcher = catcher;
        this._uploadManager = uploadManager;
    }

    public String getPingRouteTableDump() {
        return this._pingRouteTable.toString();
    }

    public String getQueryRouteTableDump() {
        return this._queryRouteTable.toString();
    }

    public String getPushRouteTableDump() {
        return this._pushRouteTable.toString();
    }

    public void removeConnection(ManagedConnection connection) {
        this._pingRouteTable.removeReplyHandler(connection);
        this._queryRouteTable.removeReplyHandler(connection);
        this._pushRouteTable.removeReplyHandler(connection);
    }

    final void handlePingRequestPossibleDuplicate(PingRequest pingRequest, ManagedConnection receivingConnection) {
        if (this._pingRouteTable.tryToRouteReply(pingRequest.getGUID(), receivingConnection)) {
            this.handlePingRequest(pingRequest, receivingConnection);
        }
    }

    final void handleQueryRequestPossibleDuplicate(QueryRequest queryRequest, ManagedConnection receivingConnection) {
        if (this._queryRouteTable.tryToRouteReply(queryRequest.getGUID(), receivingConnection)) {
            this.handleQueryRequest(queryRequest, receivingConnection);
        }
    }

    protected void handlePingRequest(PingRequest pingRequest, ManagedConnection receivingConnection) {
        ++this._numPingRequests;
        if (pingRequest.getTTL() > 0) {
            this.broadcastPingRequest(pingRequest, receivingConnection, this._manager);
        }
        this.respondToPingRequest(pingRequest, this._acceptor);
    }

    public void handleQueryRequest(QueryRequest queryRequest, ManagedConnection receivingConnection) {
        ++this._numQueryRequests;
        if (receivingConnection.getNumMessagesReceived() <= 2 && queryRequest.getHops() <= 1 && queryRequest.getQuery().equals("    ")) {
            receivingConnection.setKillable(false);
        }
        if (queryRequest.getTTL() > 0) {
            this.broadcastQueryRequest(queryRequest, receivingConnection, this._manager);
        }
        this.respondToQueryRequest(queryRequest, this._acceptor, this._clientGUID);
    }

    public void sendPingRequest(PingRequest pingRequest, ManagedConnection connection) {
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this._forMeReplyHandler);
        connection.send(pingRequest);
    }

    public void sendQueryRequest(QueryRequest queryRequest, ManagedConnection connection) {
        this._queryRouteTable.routeReply(queryRequest.getGUID(), this._forMeReplyHandler);
        connection.send(queryRequest);
    }

    public void broadcastPingRequest(PingRequest pingRequest) {
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this._forMeReplyHandler);
        this.broadcastPingRequest(pingRequest, null, this._manager);
    }

    public void broadcastQueryRequest(QueryRequest queryRequest) {
        this._queryRouteTable.routeReply(queryRequest.getGUID(), this._forMeReplyHandler);
        this.broadcastQueryRequest(queryRequest, null, this._manager);
    }

    protected void broadcastPingRequest(PingRequest pingRequest, ManagedConnection receivingConnection, ConnectionManager manager) {
        List list = manager.getInitializedConnections2();
        int i = 0;
        while (i < list.size()) {
            ManagedConnection c = (ManagedConnection)list.get(i);
            if (c != receivingConnection) {
                c.send(pingRequest);
            }
            ++i;
        }
    }

    protected void broadcastQueryRequest(QueryRequest queryRequest, ManagedConnection receivingConnection, ConnectionManager manager) {
        List list = manager.getInitializedConnections2();
        int i = 0;
        while (i < list.size()) {
            ManagedConnection c = (ManagedConnection)list.get(i);
            if (c != receivingConnection) {
                c.send(queryRequest);
            }
            ++i;
        }
    }

    protected abstract void respondToPingRequest(PingRequest var1, Acceptor var2);

    protected abstract void respondToQueryRequest(QueryRequest var1, Acceptor var2, byte[] var3);

    public void handlePingReply(PingReply pingReply, ManagedConnection receivingConnection) {
        this._catcher.spy(pingReply, receivingConnection);
        ReplyHandler replyHandler = this._pingRouteTable.getReplyHandler(pingReply.getGUID());
        if (replyHandler != null) {
            ++this._numPingReplies;
            replyHandler.handlePingReply(pingReply, receivingConnection);
        } else {
            ++this._numRouteErrors;
            receivingConnection.countDroppedMessage();
        }
    }

    public void handleQueryReply(QueryReply queryReply, ManagedConnection receivingConnection) {
        ReplyHandler replyHandler = this._queryRouteTable.getReplyHandler(queryReply.getGUID());
        if (replyHandler != null) {
            ++this._numQueryReplies;
            this._pushRouteTable.routeReply(queryReply.getClientGUID(), receivingConnection);
            replyHandler.handleQueryReply(queryReply, receivingConnection);
        } else {
            ++this._numRouteErrors;
            receivingConnection.countDroppedMessage();
        }
    }

    public void handlePushRequest(PushRequest pushRequest, ManagedConnection receivingConnection) {
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(pushRequest.getClientGUID());
        if (replyHandler != null) {
            ++this._numPingReplies;
            replyHandler.handlePushRequest(pushRequest, receivingConnection);
        } else {
            ++this._numRouteErrors;
            receivingConnection.countDroppedMessage();
        }
    }

    public void sendPingReply(PingReply pingReply) throws IOException {
        ReplyHandler replyHandler = this._pingRouteTable.getReplyHandler(pingReply.getGUID());
        if (replyHandler == null) {
            throw new IOException();
        }
        replyHandler.handlePingReply(pingReply, null);
    }

    public void sendQueryReply(QueryReply queryReply) throws IOException {
        ReplyHandler replyHandler = this._queryRouteTable.getReplyHandler(queryReply.getGUID());
        if (replyHandler == null) {
            throw new IOException();
        }
        this._pushRouteTable.routeReply(queryReply.getClientGUID(), this._forMeReplyHandler);
        replyHandler.handleQueryReply(queryReply, null);
    }

    public void sendPushRequest(PushRequest pushRequest) throws IOException {
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(pushRequest.getClientGUID());
        if (replyHandler == null) {
            throw new IOException();
        }
        replyHandler.handlePushRequest(pushRequest, null);
    }

    public GroupPingRequest createGroupPingRequest(String group) {
        FileManager fm = FileManager.instance();
        int num_files = fm.getNumFiles();
        int kilobytes = fm.getSize() / 1024;
        GroupPingRequest pingRequest = new GroupPingRequest(SettingsManager.instance().getTTL(), this._acceptor.getPort(), this._acceptor.getAddress(), num_files, kilobytes, group);
        return pingRequest;
    }

    protected abstract void handlePingReplyForMe(PingReply var1, ManagedConnection var2);

    protected abstract void handleQueryReplyForMe(QueryReply var1, ManagedConnection var2);

    protected abstract void handlePushRequestForMe(PushRequest var1, ManagedConnection var2);

    public void countMessage() {
        ++this._numMessages;
    }

    public void countFilteredMessage() {
        ++this._numFilteredMessages;
    }

    public int getNumPingRequests() {
        return this._numPingRequests;
    }

    public int getNumPingReplies() {
        return this._numPingReplies;
    }

    public int getNumQueryRequests() {
        return this._numQueryRequests;
    }

    public int getNumQueryReplies() {
        return this._numQueryReplies;
    }

    public int getNumPushRequests() {
        return this._numPushRequests;
    }

    public int getNumFilteredMessages() {
        return this._numFilteredMessages;
    }

    public int getNumRouteErrors() {
        return this._numRouteErrors;
    }

    public int getNumDroppedMessages() {
        return this._numFilteredMessages + this._numRouteErrors;
    }

    public int getNumMessages() {
        return this._numMessages;
    }

    private final class ForMeReplyHandler
    implements ReplyHandler {
        public void handlePingReply(PingReply pingReply, ManagedConnection receivingConnection) {
            MessageRouter.this.handlePingReplyForMe(pingReply, receivingConnection);
        }

        public void handleQueryReply(QueryReply queryReply, ManagedConnection receivingConnection) {
            MessageRouter.this.handleQueryReplyForMe(queryReply, receivingConnection);
        }

        public void handlePushRequest(PushRequest pushRequest, ManagedConnection receivingConnection) {
            MessageRouter.this.handlePushRequestForMe(pushRequest, receivingConnection);
        }

        public boolean isOpen() {
            return true;
        }
    }
}

