/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PingReply
extends Message
implements Serializable {
    private byte[] payload;

    public PingReply(byte[] guid, byte ttl, int port, byte[] ip, long files, long kbytes) {
        super(guid, (byte)1, ttl, (byte)0, 14);
        this.payload = new byte[14];
        ByteOrder.short2leb((short)port, this.payload, 0);
        this.payload[2] = ip[0];
        this.payload[3] = ip[1];
        this.payload[4] = ip[2];
        this.payload[5] = ip[3];
        ByteOrder.int2leb((int)files, this.payload, 6);
        ByteOrder.int2leb((int)kbytes, this.payload, 10);
    }

    public PingReply(byte[] guid, byte ttl, byte hops, byte[] payload) {
        super(guid, (byte)1, ttl, hops, 14);
        this.payload = payload;
    }

    protected void writePayload(OutputStream out) throws IOException {
        out.write(this.payload);
    }

    public String toString() {
        return "PingReply(" + this.getIP() + ":" + this.getPort() + ", " + super.toString() + ")";
    }

    public int getPort() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this.payload, 0));
    }

    public String getIP() {
        byte[] ip = new byte[]{this.payload[2], this.payload[3], this.payload[4], this.payload[5]};
        String ret = Message.ip2string(ip);
        return ret;
    }

    public byte[] getIPBytes() {
        byte[] ip = new byte[]{this.payload[2], this.payload[3], this.payload[4], this.payload[5]};
        return ip;
    }

    public long getFiles() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 6));
    }

    public long getKbytes() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 10));
    }
}

